/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.stage.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.extension.project.commands.stage.StageMessages;
import oracle.dbtools.extension.project.commands.stage.objectclasses.DbDiffObject;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.exceptions.StageProcessException;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;

public class RdbmsSchemaDiffManager {
    static Comparator<String> naturalOrderURIs = (o1, o2) -> {
        String[] uri1 = o1.split("/");
        String[] uri2 = o2.split("/");
        int version1 = uri1[0].equals("main") ? Integer.MAX_VALUE : Integer.parseInt(uri1[0]);
        int version2 = uri2[0].equals("main") ? Integer.MAX_VALUE : Integer.parseInt(uri2[0]);
        return Integer.compare(version1, version2);
    };
    static Comparator<String> reverseOrderURIs = (o1, o2) -> {
        String[] uri1 = o1.split("/");
        String[] uri2 = o2.split("/");
        int version1 = uri1[0].equals("main") ? Integer.MAX_VALUE : Integer.parseInt(uri1[0]);
        int version2 = uri2[0].equals("main") ? Integer.MAX_VALUE : Integer.parseInt(uri2[0]);
        return Integer.compare(version2, version1);
    };

    public static boolean isRdbmsDiffProject() {
        return Objects.equals(ProjectSettings.getConfigValue("rdbmsSchemaDiff.isRdbmsSchemaDiff"), true);
    }

    public static Map<String, List<String>> loadURIs(Integer src, Integer trg) {
        if (!RdbmsSchemaDiffManager.isRdbmsDiffProject() || src == null || trg == null) {
            return null;
        }
        String upgradeOrDowngrade = trg > src ? "upgrade" : "downgrade";
        List<String> objectsURIs = ProjectSettings.getSettingAsList("rdbmsSchemaDiff." + upgradeOrDowngrade + "Scripts.URIs");
        HashMap<String, List<String>> finalObjectsURIs = new HashMap<String, List<String>>();
        for (String URI2 : objectsURIs) {
            List<String> tmp;
            String objectName;
            String[] elements = URI2.split("/");
            if (upgradeOrDowngrade.equalsIgnoreCase("upgrade") && (Integer.parseInt(elements[0]) < src || Integer.parseInt(elements[0]) >= trg) || upgradeOrDowngrade.equalsIgnoreCase("downgrade") && (Integer.parseInt(elements[0]) >= src || Integer.parseInt(elements[0]) < trg)) continue;
            String objectNameExt = elements[3];
            int lastDotIndex = objectNameExt.lastIndexOf(46);
            String string = objectName = lastDotIndex == -1 ? objectNameExt : objectNameExt.substring(0, lastDotIndex);
            if (finalObjectsURIs.containsKey(objectName.toLowerCase())) {
                tmp = (List)finalObjectsURIs.get(objectName.toLowerCase());
                tmp.add(URI2);
                if (upgradeOrDowngrade.equalsIgnoreCase("upgrade")) {
                    tmp.sort(naturalOrderURIs);
                } else {
                    tmp.sort(reverseOrderURIs);
                }
            } else {
                tmp = new ArrayList<String>();
                tmp.add(URI2);
            }
            finalObjectsURIs.put(objectName, tmp);
        }
        return finalObjectsURIs;
    }

    public static Integer getSourceVersion() {
        if (!RdbmsSchemaDiffManager.isRdbmsDiffProject()) {
            return null;
        }
        if (ProjectSettings.getConfigValue("rdbmsSchemaDiff.sourceVersion").equals("main")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt((String)ProjectSettings.getConfigValue("rdbmsSchemaDiff.sourceVersion"));
    }

    public static Integer getTargetVersion() {
        if (!RdbmsSchemaDiffManager.isRdbmsDiffProject()) {
            return null;
        }
        if (ProjectSettings.getConfigValue("rdbmsSchemaDiff.targetVersion").equals("main")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt((String)ProjectSettings.getConfigValue("rdbmsSchemaDiff.targetVersion"));
    }

    public static void writeScript(DbDiffObject entry, String objectName, List<String> URIs) throws StageProcessException {
        if (!RdbmsSchemaDiffManager.isRdbmsDiffProject() || RdbmsSchemaDiffManager.getSourceVersion() == null || RdbmsSchemaDiffManager.getTargetVersion() == null) {
            return;
        }
        String upgradeOrDowngrade = RdbmsSchemaDiffManager.getTargetVersion() > RdbmsSchemaDiffManager.getSourceVersion() ? "upgrades" : "downgrades";
        for (String URI2 : URIs) {
            String issuesPath = (String)ProjectSettings.getConfigValue("rdbmsSchemaDiff.issuesPath");
            Path projectPath = ProjectConfig.getCurrentWorkingProjectRoot();
            Path fullPath = projectPath.resolve(issuesPath);
            Path scriptsPath = fullPath.resolve(upgradeOrDowngrade).resolve(URI2);
            try {
                RdbmsSchemaDiffManager.writeInStageGeneratedFile(Files.readString(scriptsPath), entry);
            }
            catch (IOException e) {
                throw new StageProcessException(StageMessages.format("RDBMS_MANAGED_OBJECTS_EXCEPTION", entry.getObjectName(), scriptsPath.toString()));
            }
        }
    }

    private static void writeInStageGeneratedFile(String script, DbDiffObject entry) {
        if (!RdbmsSchemaDiffManager.isRdbmsDiffProject()) {
            return;
        }
        if (entry.getRawOutput() == null) {
            entry.setRawOutput(script);
        } else {
            entry.setRawOutput(entry.getRawOutput() + "\n" + script);
        }
    }
}

