/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.project.commands.show;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.extension.project.commands.show.ShowMessages;
import oracle.dbtools.extension.project.core.config.ProjectConfig;
import oracle.dbtools.extension.project.core.settings.ProjectSettings;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;

public class ShowProject
extends CommandListener
implements IShowCommand {
    private static final String[] SHOW_PROJECT = new String[]{"project"};

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return false;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String[] getShowAliases() {
        return SHOW_PROJECT;
    }

    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String currentProjectPath = ProjectConfig.getCurrentWorkingProjectName();
        if (currentProjectPath == null || currentProjectPath.isEmpty()) {
            ctx.writeln(ShowMessages.getString("NO_PROJECT_AVAILABLE"));
            return true;
        }
        ProjectSettings.loadUserSettings(ProjectConfig.getCurrentWorkingProjectRoot().toString());
        String currentProjectSqlClVersion = ProjectConfig.getSqlclVersion();
        String currentProjectRoot = ProjectConfig.getCurrentWorkingProjectRoot().toString();
        ctx.writeln(MessageFormat.format(ShowMessages.getString("SHOW_PROJECT"), ProjectSettings.getSettingAsString("project"), currentProjectSqlClVersion, currentProjectRoot));
        return true;
    }

    public boolean needsDatabase() {
        return false;
    }

    public boolean inShowAll() {
        return false;
    }
}

