/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.xml.navigator;

import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.xml.navigator.ChildTypeElement;
import oracle.dbtools.xml.navigator.ItemDescriptor;
import oracle.xml.parser.v2.XMLNode;

public class NodeElement
extends ItemDescriptor {
    private static final String INSTANCE_CLASS = "instanceClass";
    private static final String ITEM_CLASS = "itemClass";
    private static final String NODE_CLASS = "nodeClass";
    private List<ChildTypeElement> childTypes;
    private String nodeClass;
    private String implementationClass;
    private String instanceClass;

    NodeElement(XMLNode node) {
        super(node);
        this.nodeClass = NodeElement.getAttributeValue("", NODE_CLASS, node);
        this.implementationClass = NodeElement.getAttributeValue("", ITEM_CLASS, node);
        this.instanceClass = NodeElement.getAttributeValue("", INSTANCE_CLASS, node);
        XMLNode[] children = NodeElement.getElements("childType", node);
        if (children != null && children.length > 0) {
            this.childTypes = new ArrayList<ChildTypeElement>();
            for (XMLNode child : children) {
                ChildTypeElement childDesc = new ChildTypeElement(child);
                if (childDesc.getName() == null) continue;
                this.childTypes.add(childDesc);
            }
        }
    }

    public List<ChildTypeElement> getChildTypes() {
        return NodeElement.wrapList(this.childTypes);
    }

    public String getNodeClass() {
        return this.nodeClass;
    }

    public String getImplementationClass() {
        return this.implementationClass;
    }

    public String getInstanceClass() {
        return this.instanceClass;
    }
}

