/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.util.GCReapHandler;
import oracle.dbtools.util.Logger;

public final class GCTracker {
    private static GCTracker instance = null;
    private final Map<Reference, GCReapHandler> handlerMap = new HashMap<Reference, GCReapHandler>();
    private final ReferenceQueue reaped = new ReferenceQueue();
    private boolean tracking = true;

    private GCTracker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GCTracker getInstance() {
        if (instance != null) return instance;
        Class<GCTracker> clazz = GCTracker.class;
        synchronized (GCTracker.class) {
            if (instance != null) return instance;
            instance = new GCTracker();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTracking(boolean setting) {
        if (this.tracking != setting) {
            GCTracker gCTracker = this;
            synchronized (gCTracker) {
                this.tracking = setting;
            }
        }
    }

    public boolean isTracking() {
        return this.tracking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(Object referent, GCReapHandler handler) {
        if (this.tracking) {
            GCTracker gCTracker = this;
            synchronized (gCTracker) {
                if (this.tracking) {
                    this.handlePendingReap();
                    PhantomReference<Object> ref = new PhantomReference<Object>(referent, this.reaped);
                    this.handlerMap.put(ref, handler);
                }
            }
        }
    }

    public void pollReferentReapQueue() {
        this.pollReferentReapQueue(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollReferentReapQueue(boolean force) {
        if (force || this.tracking) {
            GCTracker gCTracker = this;
            synchronized (gCTracker) {
                this.handlePendingReap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReferentReapQueue() {
        GCTracker gCTracker = this;
        synchronized (gCTracker) {
            this.purgeReferentReapQueue(this.isTracking());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeReferentReapQueue(boolean tracking) {
        GCTracker gCTracker = this;
        synchronized (gCTracker) {
            this.setTracking(tracking);
            this.handlerMap.clear();
            Reference ref = this.reaped.poll();
            while (ref != null) {
                ref = this.reaped.poll();
            }
        }
    }

    private void handlePendingReap() {
        Reference ref = this.reaped.poll();
        while (ref != null) {
            GCReapHandler handler = this.handlerMap.remove(ref);
            if (handler != null) {
                try {
                    handler.referentDequeued();
                }
                catch (Exception e) {
                    Logger.finest(GCTracker.class, e);
                }
            }
            ref = this.reaped.poll();
        }
    }
}

