/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;

public class Directory {
    public static List<String> visitor4Directory(String location, String[] exts, ScriptExecutor se) throws IOException {
        LinkedList<String> ret = new LinkedList<String>();
        if (se != null && se.getInterrupted()) {
            return ret;
        }
        for (String ext : exts) {
            for (String f : Directory.filesInDirectory(location, ext, se)) {
                if ("".equals(f)) {
                    ret.add(location);
                    return ret;
                }
                ret.add(location + "/" + f);
            }
        }
        File file = new File(location);
        String[] directories = file.list(new FilenameFilter(){

            @Override
            public boolean accept(File current, String name) {
                File tmp = new File(current, name);
                boolean isSymbolicLink = Files.isSymbolicLink(tmp.toPath());
                if (isSymbolicLink) {
                    return false;
                }
                return tmp.isDirectory();
            }
        });
        if (directories != null) {
            for (String dir : directories) {
                ret.addAll(Directory.visitor4Directory(location + "/" + dir, exts, se));
            }
        }
        return ret;
    }

    public static List<String> filesInDirectory(String location, String ext, ScriptExecutor se) throws IOException {
        if (se != null && se.getInterrupted()) {
            return new LinkedList<String>();
        }
        Object postfix = ext.contains(".") ? ext : "." + ext;
        File file = new File(location);
        if (file.isFile()) {
            String[] files = new String[]{""};
            return Arrays.asList(files);
        }
        String[] files = file.list(new FilenameFilter((String)postfix){
            final /* synthetic */ String val$postfix;
            {
                this.val$postfix = string;
            }

            @Override
            public boolean accept(File current, String name) {
                if (!name.endsWith(this.val$postfix)) {
                    return false;
                }
                return new File(current, name).isFile();
            }
        });
        return Arrays.asList(files);
    }
}

