/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.runner;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class SqlClCommandsRunner {
    private final ScriptExecutor executor;
    private final ScriptRunnerContext context;
    private final BufferedOutputStream originalOs;

    private SqlClCommandsRunner(Builder builder) {
        this.context = builder.context != null ? builder.context : new ScriptRunnerContext();
        this.context.putProperty("script.runner.using.systemout", true);
        this.originalOs = this.context.getOutputStream() == null ? new BufferedOutputStream(System.out) : new BufferedOutputStream(this.context.getOutputStream().getMainStream());
        this.executor = new ScriptExecutor(builder.connection);
        this.executor.setScriptRunnerContext(this.context);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String run(String command) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            String string;
            try (BufferedOutputStream bos = new BufferedOutputStream(output);){
                this.executor.setOut(bos);
                this.executor.setStmt(command);
                this.executor.run();
                bos.flush();
                this.context.getOutputStream().replaceMainStream(this.originalOs);
                string = output.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Connection connection;
        private ScriptRunnerContext context;

        private Builder() {
        }

        public Builder connection(Connection connection) {
            this.connection = connection;
            return this;
        }

        public Builder context(ScriptRunnerContext context) {
            this.context = context;
            return this;
        }

        public SqlClCommandsRunner build() {
            return new SqlClCommandsRunner(this);
        }
    }
}

