/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

public class XLIFFHelper {
    private static final Logger LOGGER = Logger.getLogger(XLIFFHelper.class.getName());
    private ClassLoader m_cl;
    private XMLDocument _document;
    private DOMParser _parser;
    private String _name;

    public XLIFFHelper(ClassLoader cl, String name) {
        this.m_cl = cl;
        this.setBaseDocName(name);
    }

    private void setBaseDocName(String name) {
        this._name = name;
        this._document = null;
        this._parser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() {
        InputStream in = null;
        if (this._name != null) {
            try {
                String localeCodeXliff = String.valueOf(Locale.getDefault()) + ".xliff";
                String baseName = this._name.substring(0, this._name.lastIndexOf("."));
                String trName = baseName + "_" + localeCodeXliff;
                in = this.m_cl.getResourceAsStream(trName);
                if (in == null && localeCodeXliff.lastIndexOf("_") > 0) {
                    String langCodeXliff = localeCodeXliff.substring(0, localeCodeXliff.lastIndexOf("_")) + ".xliff";
                    trName = baseName + "_" + langCodeXliff;
                    in = this.m_cl.getResourceAsStream(trName);
                }
                if (in == null) {
                    return;
                }
                if (this._parser == null) {
                    this._parser = new DOMParser();
                } else {
                    this._parser.reset();
                }
                this._parser.setPreserveWhitespace(false);
                this._parser.parse(in);
                this._document = this._parser.getDocument();
            }
            catch (XMLParseException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (SAXException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (IOException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public String getTranslation(String key) {
        if (!System.getProperty("user.language").equalsIgnoreCase("en")) {
            if (this._document == null && this._name != null) {
                this.open();
            }
            try {
                String path = "file/body/trans-unit[source = '" + key + "']/target";
                if (this._document != null && key != null && key.length() > 0) {
                    XMLNode node1 = (XMLNode)this._document.getFirstChild();
                    XMLNode node = (XMLNode)node1.selectSingleNode(path);
                    if (node != null) {
                        return node.getTextContent();
                    }
                    return key;
                }
                return key;
            }
            catch (XSLException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
            catch (DOMException e) {
                LOGGER.log(Level.WARNING, e.getStackTrace()[0].toString(), e);
            }
        }
        return key;
    }
}

