/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.query.db;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import oracle.dbtools.raptor.query.db.QueryItem;

public class QueryDB {
    private static int MAX_CACHE_SIZE = 5000;
    private static QueryDB INSTANCE;
    private final Object LOCK = new Object();
    private long SEQ = 0L;
    private final Cache<String, Long> QI_CHECKSUM_CACHE = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE).build();
    private final Cache<Long, QueryItem> QI_CACHE = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE).build();

    public static synchronized QueryDB getDatabase() {
        if (INSTANCE == null) {
            INSTANCE = new QueryDB();
        }
        return INSTANCE;
    }

    private QueryDB() {
    }

    public QueryItem getNewQueryItem() {
        QueryItem ret = new QueryItem();
        this.put(ret);
        return ret;
    }

    public QueryItem get(long id) {
        return (QueryItem)this.QI_CACHE.getIfPresent((Object)id);
    }

    public QueryItem get(String md) {
        Long id = (Long)this.QI_CHECKSUM_CACHE.getIfPresent((Object)md);
        if (id == null) {
            return null;
        }
        return this.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(QueryItem item) {
        Object object = this.LOCK;
        synchronized (object) {
            if (item.getPk() == null) {
                item.setPk(this.SEQ++);
            }
            this.QI_CACHE.put((Object)item.getPk(), (Object)item);
            if (item.getChecksum() != null) {
                this.QI_CHECKSUM_CACHE.put((Object)item.getChecksum(), (Object)item.getPk());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncate() {
        Object object = this.LOCK;
        synchronized (object) {
            long size = this.QI_CACHE.size();
            this.QI_CACHE.invalidateAll();
            return size;
        }
    }

    public long getRowCount() {
        return this.QI_CACHE.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryItem findSharedQuery(String shareId) {
        QueryItem ret = null;
        if (shareId != null) {
            Object object = this.LOCK;
            synchronized (object) {
                Collection qis = this.QI_CACHE.asMap().values();
                for (QueryItem qi : qis) {
                    if (!shareId.equals(qi.getId())) continue;
                    ret = qi;
                    break;
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextSeq() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.SEQ++;
        }
    }
}

