/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.parser;

import oracle.dbtools.raptor.newscriptrunner.util.parser.Expression;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ExpressionBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.parser.GrammarBuildContext;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Id;
import oracle.dbtools.raptor.newscriptrunner.util.parser.NamedExpressionVisitor;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Node;
import oracle.dbtools.raptor.newscriptrunner.util.parser.ParseError;
import oracle.dbtools.raptor.newscriptrunner.util.parser.Syntax;
import oracle.dbtools.raptor.newscriptrunner.util.tokenizer.Token;

class RootBuilder
extends ExpressionBuilder {
    private final Id id;
    private final Expression expression;

    RootBuilder(Id id, Expression expression) {
        this.id = id;
        this.expression = expression;
    }

    @Override
    protected Expression build(GrammarBuildContext context) {
        return context.compose(new Root(context, this));
    }

    private static class Root
    implements Expression {
        private final Id id;
        private final Expression expression;

        Root(GrammarBuildContext context, RootBuilder builder) {
            this.id = builder.id;
            this.expression = builder.expression;
        }

        @Override
        public Syntax getSyntax() {
            return new Syntax("", false);
        }

        @Override
        public void visitNamedExpressions(NamedExpressionVisitor visitor) {
            this.expression.visitNamedExpressions(visitor);
        }

        @Override
        public void parse(Node node) {
            if (this.expression != null) {
                Node childNode = node.createChildContext(this.id, this.expression);
                this.expression.parse(childNode);
                if (childNode.isMatched()) {
                    Token firstUnconsumedToken = childNode.firstUnconsumedToken();
                    if (firstUnconsumedToken == null) {
                        node.addChildNode(childNode);
                        node.setMatched();
                    } else {
                        ParseError childError = childNode.getParseError();
                        if (childError != null) {
                            node.setParseError(childError);
                        } else {
                            node.setParseErrorUsing(firstUnconsumedToken);
                        }
                    }
                } else {
                    node.setParseError(childNode.getParseError());
                }
                node.mergeCompletions(childNode.getCompletions());
                node.mergeSemanticErrors(childNode.getSemanticErrors());
            }
        }

        public String toString() {
            return "ROOT";
        }
    }
}

