/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpBundleBuilder;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpPages;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStringExtension;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpStrings;
import oracle.dbtools.raptor.newscriptrunner.util.help.PageAssembler;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;

public class HelpPagesBuilder {
    private int lineSize;
    private boolean alphaSort;
    private boolean enableColorCode = true;
    private final Map<HelpStringExtension, String> extensionMap = new HashMap<HelpStringExtension, String>();
    private final Map<String, String> helpPageRenames = new HashMap<String, String>();
    private final List<HelpContainer> helpContainers = new ArrayList<HelpContainer>();
    private final List<PageAssembler> pageAssemblers = new ArrayList<PageAssembler>();
    private final Environment environment;

    public HelpPagesBuilder(Environment environment) {
        this.environment = environment;
    }

    public HelpPagesBuilder lineSize(int lineSize) {
        this.lineSize = lineSize;
        return this;
    }

    public HelpPagesBuilder alphaSort() {
        this.alphaSort = true;
        return this;
    }

    public HelpPagesBuilder addHelpIdExtension(HelpStringExtension extension, String extensionString) {
        this.extensionMap.put(extension, extensionString);
        return this;
    }

    public HelpPagesBuilder addHelpPageRename(String oldPagePath, String newPagePath) {
        this.helpPageRenames.put(oldPagePath, newPagePath);
        return this;
    }

    public HelpPagesBuilder addHelpContainer(HelpContainer container) {
        this.helpContainers.add(container);
        return this;
    }

    public HelpPagesBuilder addHelpContainerFor(Object forObject) {
        this.addHelpContainerFor(forObject, "Help");
        return this;
    }

    public HelpPagesBuilder addHelpContainerFor(Object forObject, String bundleName) {
        StringBuilder buff = new StringBuilder();
        buff.append(forObject.getClass().getPackageName()).append(".").append(bundleName);
        this.helpContainers.add(new HelpBundleBuilder(buff.toString()).classLoader(forObject.getClass().getClassLoader()).build());
        return this;
    }

    public HelpPagesBuilder addPage(PageAssembler page) {
        this.pageAssemblers.add(page);
        return this;
    }

    public HelpPagesBuilder addPages(Iterable<PageAssembler> pages) {
        for (PageAssembler page : pages) {
            this.pageAssemblers.add(page);
        }
        return this;
    }

    public HelpPagesBuilder enableColorCode(boolean enable) {
        this.enableColorCode = enable;
        return this;
    }

    public HelpPages build() {
        return new HelpPagesImpl(this);
    }

    private static class HelpPagesImpl
    implements HelpPages {
        private final int lineSize;
        private final boolean alphaSort;
        private final boolean enableColorCode;
        private final List<HelpContainer> helpContainers;
        private final Map<HelpStringExtension, String> extensionMap;
        private final List<String> helpPaths = new ArrayList<String>();
        private final Map<String, PageAssembler> pageAssemblerMap = new HashMap<String, PageAssembler>();
        private final Environment environment;

        private HelpPagesImpl(HelpPagesBuilder builder) {
            this.lineSize = builder.lineSize;
            this.alphaSort = builder.alphaSort;
            this.enableColorCode = builder.enableColorCode;
            this.helpContainers = builder.helpContainers;
            this.extensionMap = builder.extensionMap;
            this.environment = builder.environment;
            for (PageAssembler assembler : builder.pageAssemblers) {
                String pagePath = assembler.getPagePath();
                if (builder.helpPageRenames.containsKey(pagePath)) {
                    pagePath = builder.helpPageRenames.get(pagePath);
                }
                this.helpPaths.add(pagePath);
                if (this.pageAssemblerMap.containsKey(pagePath)) {
                    throw new IllegalArgumentException("duplicate page path '" + pagePath + "' detected for page of class '" + assembler.getClass().getSimpleName());
                }
                this.pageAssemblerMap.put(pagePath, assembler);
            }
        }

        @Override
        public Optional<String> get(String pagePath) {
            PageAssembler pageAssembler;
            int firstSlashIndex = pagePath.indexOf(47);
            if (firstSlashIndex != -1) {
                pagePath = pagePath.substring(0, firstSlashIndex);
            }
            if ((pageAssembler = this.pageAssemblerMap.get(pagePath)) != null) {
                ArrayList<HelpContainer> pageHelpContainers = new ArrayList<HelpContainer>(this.helpContainers);
                pageHelpContainers.addAll(pageAssembler.getHelpContainers());
                AggregatingHelpStrings helpStrings = new AggregatingHelpStrings(this.extensionMap, pageHelpContainers, this.environment);
                int ls = this.lineSize > 0 ? this.lineSize : this.environment.getConsoleLineSize();
                return Optional.of(pageAssembler.getPage(ls, this.alphaSort, this.environment.getLocale(), helpStrings, this.getMoreHelpTopics(pagePath), this.enableColorCode));
            }
            return Optional.empty();
        }

        private List<String> getMoreHelpTopics(String pagePath) {
            ArrayList<String> moreHelpTopics = new ArrayList<String>();
            String[] pathComponents = null;
            for (String otherPath : this.helpPaths) {
                String tail;
                if (otherPath.length() <= pagePath.length() || !otherPath.startsWith(pagePath + "/") || (tail = otherPath.substring(pagePath.length() + 1)).contains("/")) continue;
                if (pathComponents == null) {
                    pathComponents = pagePath.split("/");
                }
                StringBuilder buff = new StringBuilder();
                for (String pathComponent : pathComponents) {
                    buff.append(pathComponent).append(' ');
                }
                buff.append(tail);
                moreHelpTopics.add(buff.toString());
            }
            return moreHelpTopics;
        }
    }

    private static class AggregatingHelpStrings
    implements HelpStrings {
        private final Map<HelpStringExtension, String> extensionMap;
        private final List<HelpContainer> helpContainers;
        private final Environment environment;

        private AggregatingHelpStrings(Map<HelpStringExtension, String> extensionMap, List<HelpContainer> helpContainer, Environment environment) {
            this.extensionMap = extensionMap;
            this.helpContainers = helpContainer;
            this.environment = environment;
        }

        @Override
        public String get(String id) {
            return this.lookup(id);
        }

        @Override
        public String get(HelpStringExtension extension, String id) {
            String defaultString;
            String key;
            String helpString;
            String extensionString = this.extensionMap.get(extension);
            if (extensionString == null) {
                extensionString = extension.getDefault();
            }
            if ((helpString = this.lookup(key = id + "_" + extensionString)) == null && extension == Extensions.SUMMARY && (defaultString = this.lookup(id)) != null) {
                int period = defaultString.indexOf(46);
                helpString = period > 0 ? defaultString.substring(0, period) : defaultString;
            }
            return helpString;
        }

        private String lookup(String key) {
            for (HelpContainer helpContainer : this.helpContainers) {
                Optional<String> textOpt = helpContainer.get(key, this.environment);
                if (!textOpt.isPresent()) continue;
                return textOpt.get();
            }
            return null;
        }
    }

    public static enum Extensions implements HelpStringExtension
    {
        SUMMARY{

            @Override
            public String getDefault() {
                return "SH";
            }
        };

    }
}

