/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.util.help;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import oracle.dbtools.raptor.newscriptrunner.util.help.HelpContainer;
import oracle.dbtools.raptor.newscriptrunner.util.service.Environment;

public class HelpBundleBuilder {
    private final String bundleName;
    private Locale locale;
    private ClassLoader classLoader;

    public HelpBundleBuilder(String bundleName) {
        this.bundleName = bundleName;
    }

    public HelpBundleBuilder locale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public HelpBundleBuilder classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public HelpContainer build() {
        return new HelpContainerImpl(this);
    }

    private static class HelpContainerImpl
    implements HelpContainer {
        private final String bundleName;
        private final Locale givenLocale;
        private final ClassLoader classLoader;

        public HelpContainerImpl(HelpBundleBuilder builder) {
            this.bundleName = builder.bundleName;
            this.givenLocale = builder.locale;
            this.classLoader = builder.classLoader;
        }

        @Override
        public String getContainerName() {
            return this.bundleName;
        }

        @Override
        public Optional<String> get(String key, Environment environment) {
            Locale locale = this.givenLocale == null ? environment.getLocale() : this.givenLocale;
            ResourceBundle resourceBundle = this.getResourceBundle(locale);
            if (resourceBundle != null && resourceBundle.containsKey(key)) {
                return Optional.of(resourceBundle.getString(key));
            }
            return Optional.empty();
        }

        private ResourceBundle getResourceBundle(Locale locale) {
            try {
                if (this.classLoader != null) {
                    return ResourceBundle.getBundle(this.bundleName, locale, this.classLoader);
                }
                return ResourceBundle.getBundle(this.bundleName, locale);
            }
            catch (MissingResourceException ex) {
                Logger.getLogger(this.getClass().getName()).severe(ex.getMessage());
                return null;
            }
        }
    }
}

