/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.parameterparser.validators;

import java.util.List;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.ParmResources;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.validators.AbstractValidatorService;

public class IntegerValidator
extends AbstractValidatorService<Integer> {
    @Override
    public Integer getParameter(String parm) throws ParameterFailedValidationException {
        try {
            return Integer.parseInt(parm);
        }
        catch (Exception e) {
            throw new ParameterFailedValidationException(ParmResources.format("BAD_PARM_VALUE", parm, this.pName, "Integer"));
        }
    }

    @Override
    public String parmToString() {
        return String.valueOf(this.parmValue);
    }

    @Override
    public List<Integer> StringToTypeList(String stringList) {
        try {
            String[] tempArray;
            for (String number : tempArray = stringList.split(",")) {
                this.allowedValues.add(Integer.parseInt(number.trim()));
            }
            return this.allowedValues;
        }
        catch (Exception e) {
            return null;
        }
    }
}

