/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowSystemOut
implements IShowCommand {
    private static final String[] SHOWSYSTEMOUT = new String[]{"systemout"};

    @Override
    public String[] getShowAliases() {
        return SHOWSYSTEMOUT;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowSystemOut(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    private boolean doShowSystemOut(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getProperty("script.runner.using.systemout") != null) {
                ctx.write("systemout \"" + ((Boolean)ctx.getProperty("script.runner.using.systemout")).toString() + "\"\n");
            } else {
                ctx.write("systemout \"\" \n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }
}

