/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowLocale
implements IShowCommand {
    @Override
    public String[] getShowAliases() {
        return new String[]{"locale"};
    }

    private void print(ScriptRunnerContext ctx, String val) {
        ctx.write(ScriptUtils.wordwrapNotXml(1, (Integer)ctx.getProperty("script.runner.setlinesize"), new StringBuffer(val)).toString());
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String pad = new String(new char[11]).replace('\u0000', '-');
        ctx.write("Locale Detail\n" + pad + "\n");
        int ls = (Integer)ctx.getProperty("script.runner.setlinesize");
        pad = new String(new char[ls]).replace('\u0000', '-');
        ctx.write(pad + "\n");
        this.print(ctx, "user.language= " + System.getProperty("user.language") + "\n");
        this.print(ctx, "user.region= " + System.getProperty("user.region") + "\n");
        this.print(ctx, "file.encoding= " + System.getProperty("file.encoding") + "\n");
        ctx.write(pad + "\n");
        return true;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

