/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.show;

import java.sql.Connection;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.IStoreCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.StoreRegistry;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class ShowArraycmd
implements IShowCommand,
IStoreCommand {
    private static final String[] SHOWARRAYCMD = new String[]{"array", "arrays", "arraysi", "arraysiz", "arraysize"};

    @Override
    public String[] getShowAliases() {
        return SHOWARRAYCMD;
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        return this.doShowArraycmd(conn, ctx, cmd);
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return true;
    }

    private boolean doShowArraycmd(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        try {
            if (ctx.getProperty("script.runner.arraysize") != null) {
                ctx.write("arraysize " + (String)ctx.getProperty("script.runner.arraysize") + "\n");
            } else {
                ctx.write("arraysize " + Messages.getString("DEFAULTARRAYSIZE") + "\n");
            }
        }
        catch (Exception e) {
            ctx.write(e.getLocalizedMessage());
        }
        return true;
    }

    @Override
    public String getStoreCommand(ScriptRunnerContext ctx) {
        String string = "";
        if (ctx.getProperty("script.runner.arraysize") != null) {
            return StoreRegistry.getCommand("arraysize ", (String)ctx.getProperty("script.runner.arraysize"));
        }
        return StoreRegistry.getCommand("arraysize ", Messages.getString("DEFAULTARRAYSIZE"));
    }
}

