/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.connector;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectionContext;
import oracle.dbtools.raptor.newscriptrunner.commands.connect.ConnectorArgs;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.CloudConfigProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.OracleStandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.StandardFormConnector;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.URLProperty;
import oracle.dbtools.raptor.newscriptrunner.commands.connector.WalletValue;
import oracle.jdbc.datasource.OracleDataSource;

public class CloudWalletConnector
extends OracleStandardFormConnector {
    public CloudWalletConnector(ConnectorArgs args) {
        super(args);
    }

    @Override
    protected StandardFormConnector.ConnectionRec createOracleStandardFormConnection(List<String> urlMessage, String connectDB, Properties props) {
        String connectName = props.getProperty("user");
        Connection myconn = null;
        String successfulAttempt = null;
        if (connectDB == null || connectDB.equals("")) {
            connectDB = this.ctx.getService(ConnectionContext.class).getCurrentPropertyValues().getValueOf(URLProperty.URL);
        }
        if (connectDB != null && !connectDB.equals("")) {
            WalletValue walletValue = this.properties.getValueOf(CloudConfigProperty.CLOUDCONFIG);
            String serviceAlias = walletValue.getCloudServiceAlias(connectDB);
            StringBuilder url = new StringBuilder();
            url.append("jdbc:oracle:thin:@");
            if (serviceAlias != null) {
                url.append(serviceAlias);
            } else {
                url.append(connectDB);
            }
            try {
                myconn = this.logConnectionURL(urlMessage, connectName, url.toString(), props, true);
            }
            catch (Throwable ee) {
                this.ctx.putProperty("sqldev.last.err.message.forsqlcode", ee.getMessage());
            }
        }
        return new StandardFormConnector.ConnectionRec(this, myconn, successfulAttempt);
    }

    @Override
    protected void configureDataSource(OracleDataSource datasource, String url, Properties filteredProps) throws SQLException {
        WalletValue walletValue = this.properties.getValueOf(CloudConfigProperty.CLOUDCONFIG);
        walletValue.configureDataSource(datasource, url, filteredProps, this.properties);
    }
}

