/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Aliases;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetricsParser {
    private static final String ID = "id";
    private static final String QUERYTYPE = "querytype";
    private static final String QUERIES = "queries";
    protected static Logger LOGGER = Logger.getLogger(MetricsParser.class.getName());
    ArrayList<Alias> aliases = new ArrayList();

    public ArrayList<Alias> processXML(URL u) throws Exception {
        return this.processXML(u.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Alias> processXML(InputStream is) throws Exception {
        try {
            DOMParser parser = new DOMParser();
            this.aliases.clear();
            parser.setPreserveWhitespace(false);
            parser.parse(is);
            XMLDocument document = parser.getDocument();
            NodeList rootNodes = document.getChildNodes();
            for (int i = 0; i < rootNodes.getLength(); ++i) {
                this.processNodes(rootNodes.item(i));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.aliases;
    }

    private void processNodes(Node item) {
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(QUERYTYPE)) continue;
            this.newItem(child);
        }
    }

    private void newItem(Node child) {
        String aliasname = XMLHelper.getAttributeNode(child, ID);
        String description = "";
        ObjectQueries queries = new ObjectQueries(null);
        NodeList items = child.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node x = items.item(i);
            if (!x.getNodeName().equalsIgnoreCase(QUERIES)) continue;
            queries = new ObjectQueries((XMLNode)x);
        }
        Alias alias = new Alias(aliasname, description, queries, "system", true);
        this.aliases.add(alias);
    }

    public static void main(String[] args) {
        MetricsParser mp = new MetricsParser();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        List<Path> paths = FileUtils.getFilesInPackage("oracle/dbtools/raptor/metrics/", "xml");
        URL u = cl.getResource("oracle/dbtools/raptor/metrics/sysjob/OsStat.xml");
        try {
            for (Path p : paths) {
                ArrayList<Alias> aliases = mp.processXML(p.toUri().toURL());
                Aliases.getInstance().add(aliases);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

