/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands.alias;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.Alias;
import oracle.dbtools.raptor.newscriptrunner.commands.alias.ParserUtil;
import oracle.dbtools.raptor.query.Bind;
import oracle.dbtools.raptor.query.ObjectQueries;
import oracle.dbtools.raptor.query.Query;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AliasParser {
    private static final String ALIAS = "alias";
    private static final String ALIASES = "aliases";
    private static final String DESC = "description";
    private static final String QUERIES = "queries";
    private static final String QUERY = "query";
    private static final String MINVERSION = "minversion";
    private static final String SQL = "sql";
    private static final String BINDS = "binds";
    private static final String BIND = "bind";
    private static final String TOOLTIP = "tooltip";
    private static final String ID = "id";
    public static final String NAME = "name";
    public static final String NULLDEFAULTS = "nulldefaults";
    public static final String GROUP = "group";
    protected static Logger LOGGER = Logger.getLogger(AliasParser.class.getName());
    ArrayList<Alias> aliases = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putXML(File f, ArrayList<Alias> aliasAL) throws Exception {
        f.createNewFile();
        Element e = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Element rootEle = dom.createElement(ALIASES);
        for (Alias anAlias : aliasAL) {
            e = dom.createElement(ALIAS);
            e.setAttribute(NAME, anAlias.getName());
            if (anAlias.isNullDefaults()) {
                e.setAttribute(NULLDEFAULTS, "true");
            }
            if (anAlias.getGroup() != null && !anAlias.getGroup().isBlank()) {
                e.setAttribute(GROUP, anAlias.getGroup());
            }
            Element desc = dom.createElement(DESC);
            desc.appendChild(dom.createCDATASection(anAlias.getDesc() == null ? "" : anAlias.getDesc()));
            e.appendChild(desc);
            Element queries = dom.createElement(QUERIES);
            for (Query aQuery : anAlias.getQueries().getQueries()) {
                Element tooltip;
                Element bind;
                Element binds;
                Element query = dom.createElement(QUERY);
                String minVersion = aQuery.getMinversion() != null ? aQuery.getMinversion().toString() : "8";
                query.setAttribute(MINVERSION, minVersion);
                Element sql = dom.createElement(SQL);
                sql.appendChild(dom.createCDATASection(aQuery.getSql()));
                query.appendChild(sql);
                if (Alias.isHostCommand(aQuery.getSql()) && aQuery.getHostBinds() != null && aQuery.getHostBinds().size() > 0) {
                    binds = dom.createElement(BINDS);
                    for (Bind aBind : aQuery.getHostBinds()) {
                        bind = dom.createElement(BIND);
                        bind.setAttribute(ID, aBind.getName());
                        tooltip = dom.createElement(TOOLTIP);
                        tooltip.appendChild(dom.createCDATASection(aBind.getTooltip()));
                        bind.appendChild(tooltip);
                        binds.appendChild(bind);
                    }
                    query.appendChild(binds);
                } else if (aQuery.getBinds() != null && aQuery.getBinds().size() > 0) {
                    binds = dom.createElement(BINDS);
                    for (Bind aBind : aQuery.getBinds()) {
                        bind = dom.createElement(BIND);
                        bind.setAttribute(ID, aBind.getName());
                        tooltip = dom.createElement(TOOLTIP);
                        tooltip.appendChild(dom.createCDATASection(aBind.getTooltip()));
                        bind.appendChild(tooltip);
                        binds.appendChild(bind);
                    }
                    query.appendChild(binds);
                }
                queries.appendChild(query);
            }
            e.appendChild(queries);
            rootEle.appendChild(e);
        }
        dom.appendChild(rootEle);
        FileOutputStream fos = null;
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("cdata-section-elements", "sql description");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            fos = new FileOutputStream(f.getAbsolutePath());
            tr.transform(new DOMSource(dom), new StreamResult(fos));
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, ioe.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Alias> processXML(InputStream is) throws Exception {
        try {
            DOMParser parser = new DOMParser();
            this.aliases.clear();
            parser.setPreserveWhitespace(false);
            parser.parse(is);
            XMLDocument document = parser.getDocument();
            NodeList rootNodes = document.getChildNodes();
            for (int i = 0; i < rootNodes.getLength(); ++i) {
                this.processNodes(rootNodes.item(i));
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.aliases;
    }

    public ArrayList<Alias> processXML(URL u) throws Exception {
        return this.processXML(u.openStream());
    }

    private void processNodes(Node item) {
        NodeList children = item.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String childName = child.getNodeName();
            if (!childName.equalsIgnoreCase(ALIAS)) continue;
            this.newItem(child);
        }
    }

    private void newItem(Node child) {
        String aliasname = XMLHelper.getAttributeNode(child, NAME);
        String group = XMLHelper.getAttributeNode(child, GROUP);
        String nullDefaults = XMLHelper.getAttributeNode(child, NULLDEFAULTS);
        String desc = "";
        ObjectQueries queries = null;
        NodeList items = child.getChildNodes();
        for (int i = 0; i < items.getLength(); ++i) {
            Node x = items.item(i);
            if (x.getNodeName().equalsIgnoreCase(DESC)) {
                desc = ParserUtil.getCdataValue(x);
            }
            if (!x.getNodeName().equalsIgnoreCase(QUERIES)) continue;
            queries = new ObjectQueries((XMLNode)x);
        }
        Alias newAlias = new Alias(aliasname, desc, queries, group, "true".equalsIgnoreCase(nullDefaults));
        this.aliases.add(newAlias);
    }

    public static void main(String[] args) {
        AliasParser ap = new AliasParser();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL u = cl.getResource("oracle/dbtools/raptor/newscriptrunner/commands/alias/aliases.xml");
        try {
            ap.processXML(u);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

