/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.R4)
public class SetLDAPCon
extends CommandListener
implements IShowCommand {
    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setldapcon")) {
            String[] parts = cmd.getSQLOrig().split(" ");
            if (parts.length < 3 || parts.length == 3 && parts[2].equalsIgnoreCase("default")) {
                ctx.write(Messages.getString("LDAPCONCLEARED"));
                ctx.putProperty("script.runner.ldapcon", null);
                return true;
            }
            ctx.putProperty("script.runner.ldapcon", parts[2]);
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String format = null;
        format = ctx.getProperties().containsKey("script.runner.ldapcon") && ctx.getProperties().get("script.runner.ldapcon") != null ? (String)ctx.getProperties().get("script.runner.ldapcon") : "Default";
        ctx.write("");
        ctx.write(MessageFormat.format(Messages.getString("LDAPCON"), format) + "\n");
        return true;
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"ldapcon"};
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }
}

