/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.DefaultConnectionIdentifier;
import oracle.dbtools.db.VersionTracker;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.SetDdlCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowCommand;
import oracle.dbtools.raptor.newscriptrunner.commands.show.IShowPrefixNameNewline;
import oracle.dbtools.raptor.newscriptrunner.restricted.Restricted;

@Restricted(level=Restricted.Level.NONE)
public class SetDDLSettings
extends CommandListener
implements IHelp,
IShowCommand,
IShowPrefixNameNewline {
    public static final String DDL_PARMS = "ddl.parms";
    public static final String PRETTY = "PRETTY";
    public static final String SQLTERMINATOR = "SQLTERMINATOR";
    public static final String CONSTRAINTS = "CONSTRAINTS";
    public static final String REF_CONSTRAINTS = "REF_CONSTRAINTS";
    public static final String CONSTRAINTS_AS_ALTER = "CONSTRAINTS_AS_ALTER";
    public static final String OID = "OID";
    public static final String SIZE_BYTE_KEYWORD = "SIZE_BYTE_KEYWORD";
    public static final String PARTITIONING = "PARTITIONING";
    public static final String SEGMENT_ATTRIBUTES = "SEGMENT_ATTRIBUTES";
    public static final String STORAGE = "STORAGE";
    public static final String TABLESPACE = "TABLESPACE";
    public static final String SPECIFICATION = "SPECIFICATION";
    public static final String BODY = "BODY";
    public static final String FORCE = "FORCE";
    public static final String INSERT = "INSERT";
    public static final String INHERIT = "INHERIT";
    public static final String RESET = "RESET";
    public static final String COLLATION_CLAUSE = "COLLATION_CLAUSE";
    public static final String EMIT_SCHEMA = "EMIT_SCHEMA";
    public static final String DEFAULT = "DEFAULT";
    static final ArrayList<String> ddlCollateOptions = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("NEVER");
            this.add("ALWAYS");
            this.add("NON_DEFAULT");
        }
    };
    static final ArrayList<String> ddlBooleanOptions = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("ON");
            this.add("OFF");
            this.add("TRUE");
            this.add("FALSE");
        }
    };
    static final String SET_BOOL_DDL = "declare \n FUNCTION ifelse (bool_in IN varchar2) \n   RETURN boolean \n IS \n BEGIN \n   IF bool_in = 'OFF' \n   THEN \n     RETURN false; \n  ELSE \n     RETURN true; \n  END IF;\n  END; \n begin \n dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,ifelse(:VALUE)); \n end;\n";
    static final String SET_STRING_DDL = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,:VALUE); end;";

    public static HashMap<String, Object> getDDLParameters(ScriptRunnerContext ctx) {
        try {
            ScriptRunnerContext.Parameters parms = ctx.getParameterInstance();
            HashMap<String, Object> set = parms.getParameters(DDL_PARMS);
            if (ctx == null || parms == null || set == null) {
                SetDDLSettings.resetDDLParameters(ctx);
            }
        }
        catch (Exception e) {
            SetDDLSettings.resetDDLParameters(ctx);
        }
        return SetDDLSettings.getDefaultMap(ctx);
    }

    public static HashMap<String, Object> getDefaultMap(ScriptRunnerContext ctx) {
        HashMap<String, Object> defaultMap = new HashMap<String, Object>();
        boolean col = true;
        Version ver = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(ctx.getCurrentConnection()));
        if (ver.compareTo(new Version("13")) < 0) {
            col = false;
        }
        defaultMap.put(PRETTY, "ON");
        defaultMap.put(SQLTERMINATOR, "ON");
        defaultMap.put(CONSTRAINTS, "ON");
        defaultMap.put(REF_CONSTRAINTS, "ON");
        defaultMap.put(CONSTRAINTS_AS_ALTER, "ON");
        defaultMap.put(OID, "ON");
        defaultMap.put(SIZE_BYTE_KEYWORD, "ON");
        defaultMap.put(PARTITIONING, "ON");
        defaultMap.put(SEGMENT_ATTRIBUTES, "ON");
        defaultMap.put(STORAGE, "ON");
        defaultMap.put(TABLESPACE, "ON");
        defaultMap.put(SPECIFICATION, "ON");
        defaultMap.put(BODY, "ON");
        defaultMap.put(FORCE, "ON");
        defaultMap.put(INSERT, "ON");
        defaultMap.put(INHERIT, "ON");
        if (col) {
            defaultMap.put(COLLATION_CLAUSE, "NEVER");
        }
        defaultMap.put(EMIT_SCHEMA, "ON");
        return defaultMap;
    }

    public static void resetDDLParameters(ScriptRunnerContext ctx) {
        ctx.getParameterInstance().resetParameters(DDL_PARMS);
        boolean col = true;
        Version ver = VersionTracker.getDbVersion(DefaultConnectionIdentifier.createIdentifier(ctx.getCurrentConnection()));
        if (ver.compareTo(new Version("12.1")) < 0) {
            col = false;
        }
        for (String key : SetDDLSettings.getDefaultMap(ctx).keySet()) {
            if (SetDDLSettings.getDefaultMap(ctx).get(key).equals(COLLATION_CLAUSE)) {
                if (!col) continue;
                SetDDLSettings.setDDLParameter(ctx, new Parameter(key, (String)SetDDLSettings.getDefaultMap(ctx).get(key)), false);
                continue;
            }
            SetDDLSettings.setDDLParameter(ctx, new Parameter(key, (String)SetDDLSettings.getDefaultMap(ctx).get(key)), false);
        }
    }

    public static void setDDLParameter(Connection conn, String key, String value) throws SQLException {
        String sql = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        DBUtil dbUtil = DBUtil.getInstance(conn);
        sql = key.equals(COLLATION_CLAUSE) ? SET_STRING_DDL : SET_BOOL_DDL;
        binds.put("OPTION", key);
        binds.put("VALUE", value);
        dbUtil.execute(sql, binds);
        SQLException e = dbUtil.getLastException();
        if (e != null) {
            throw e;
        }
    }

    public static void setDDLParameter(ScriptRunnerContext ctx, Parameter parmsObj, boolean report) {
        if (ctx.getParameterInstance().getParameters(DDL_PARMS) == null) {
            SetDDLSettings.resetDDLParameters(ctx);
        }
        String sql = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        if (ctx.getCurrentConnection() == null) {
            ctx.write(SetDdlCommand.format("INVALID_CONNECTION", parmsObj.getParm()));
            return;
        }
        DBUtil dbUtil = DBUtil.getInstance(ctx.getCurrentConnection());
        if (!SetDDLSettings.validateParamAndOption(parmsObj, ctx)) {
            if (SetDDLSettings.validateParameter(parmsObj, ctx)) {
                ctx.write(SetDdlCommand.format("INVALID_PARAM", parmsObj.getParm()));
            } else {
                ctx.write(SetDdlCommand.format("INVALID_VALUE", parmsObj.getValue(), parmsObj.getParm()));
            }
            return;
        }
        if (parmsObj.getParm().equals(COLLATION_CLAUSE)) {
            sql = SET_STRING_DDL;
        } else {
            if (parmsObj.getParm().equals(RESET)) {
                SetDDLSettings.resetDDLParameters(ctx);
                if (report) {
                    ctx.write(SetDdlCommand.format("SET_DDL_RESET", new Object[0]));
                }
                return;
            }
            sql = SET_BOOL_DDL;
        }
        binds.put("OPTION", parmsObj.getParm());
        binds.put("VALUE", parmsObj.getValue());
        dbUtil.execute(sql, binds);
        SQLException e = dbUtil.getLastException();
        if (e != null) {
            ctx.write(SetDdlCommand.format("SETDDL_ERROR", e.getMessage(), parmsObj.getValue()));
            return;
        }
        if (!parmsObj.getParm().equals(DEFAULT)) {
            ctx.getParameterInstance().putParameter(DDL_PARMS, parmsObj.getParm(), parmsObj.getValue());
        }
        if (report) {
            if (parmsObj.getParm().equals(DEFAULT)) {
                ctx.write(SetDdlCommand.format("SET_DDL_RESET", new Object[0]));
            } else {
                ctx.write(SetDdlCommand.format("SET_DDL_OUTPUT", parmsObj.getParm(), parmsObj.getValue()));
            }
        }
    }

    public static void setDDLParameter(ScriptRunnerContext ctx, String name, String value) {
        SetDDLSettings.setDDLParameter(ctx, new Parameter(name, value), false);
    }

    private static boolean validateParamAndOption(Parameter parmsObj, ScriptRunnerContext ctx) {
        if (parmsObj.getParm().toUpperCase().equals(COLLATION_CLAUSE)) {
            if (ddlCollateOptions.contains(parmsObj.getValue().toUpperCase())) {
                parmsObj.setValue(parmsObj.getValue().toUpperCase());
                parmsObj.setParm(parmsObj.getParm().toUpperCase());
                return true;
            }
            return false;
        }
        if (SetDDLSettings.getDefaultMap(ctx).containsKey(parmsObj.getParm().toUpperCase()) && !parmsObj.getParm().toUpperCase().equals(COLLATION_CLAUSE)) {
            if (ddlBooleanOptions.contains(parmsObj.getValue().toUpperCase())) {
                if (parmsObj.getValue().toUpperCase().equals("TRUE") || parmsObj.getValue().toUpperCase().equals("ON")) {
                    parmsObj.setValue("ON");
                    parmsObj.setParm(parmsObj.getParm().toUpperCase());
                    return true;
                }
                if (parmsObj.getValue().toUpperCase().equals("FALSE") || parmsObj.getValue().toUpperCase().equals("OFF")) {
                    parmsObj.setValue("OFF");
                    parmsObj.setParm(parmsObj.getParm().toUpperCase());
                    return true;
                }
                return false;
            }
            return false;
        }
        if (parmsObj.getParm().toUpperCase().equals(RESET) && (parmsObj.getValue().toUpperCase().equals("TRUE") || parmsObj.getValue().toUpperCase().equals("ON"))) {
            parmsObj.setValue("ON");
            parmsObj.setParm(parmsObj.getParm().toUpperCase());
            return true;
        }
        return false;
    }

    private static boolean validateParameter(Parameter parmsObj, ScriptRunnerContext ctx) {
        if (parmsObj.getParm() != null && SetDDLSettings.getDefaultMap(ctx).containsKey(parmsObj.getParm().toUpperCase())) {
            parmsObj.setParm((String)SetDDLSettings.getDefaultMap(ctx).get(parmsObj.getParm().toUpperCase()));
            return true;
        }
        return false;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public String getCommand() {
        return "SETDDL";
    }

    @Override
    public String getHelp() {
        return SetDdlCommand.getString("SETDDL");
    }

    @Override
    public String[] getShowAliases() {
        return new String[]{"DDL"};
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("setddl")) {
            return false;
        }
        String[] cmds = cmd.getSQLOrig().toLowerCase().split("\\s+");
        int length = cmds.length;
        if (conn == null) {
            ctx.write(SetDdlCommand.getString("INVALID_CONNECTION"));
            return true;
        }
        Parameter parmObj = new Parameter();
        if (length == 4) {
            parmObj.setParm(cmds[2].toUpperCase());
            parmObj.setValue(cmds[3].toUpperCase());
        } else if (length == 3) {
            parmObj.setParm(cmds[2].toUpperCase());
            parmObj.setValue("TRUE");
        } else {
            ctx.write(SetDdlCommand.getString("INVALID_COMMAND"));
            return true;
        }
        try {
            if (SetDDLSettings.validateParamAndOption(parmObj, ctx)) {
                SetDDLSettings.setDDLParameter(ctx, new Parameter(parmObj.getParm(), parmObj.getValue()), true);
            } else if (SetDDLSettings.validateParameter(parmObj, ctx)) {
                ctx.write(SetDdlCommand.format("INVALID_PARAM", parmObj.getParm()));
            } else {
                ctx.write(SetDdlCommand.format("INVALID_VALUE", parmObj.getValue(), parmObj.getParm()));
            }
            return true;
        }
        catch (Exception e) {
            ctx.write(e.getMessage());
            return true;
        }
    }

    @Override
    public boolean handleShow(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        if (ctx != null && (ctx.getParameterInstance().getParameters(DDL_PARMS) == null || ctx.getParameterInstance().getParameters(DDL_PARMS).size() == 0)) {
            ctx.getParameterInstance().putParameterSet(DDL_PARMS, SetDDLSettings.getDefaultMap(ctx));
        }
        ctx.getParameterInstance().printParametersAsTable(DDL_PARMS, SetDDLSettings.getDefaultMap(ctx));
        return true;
    }

    @Override
    public boolean inShowAll() {
        return false;
    }

    @Override
    public boolean isSqlPlus() {
        return false;
    }

    @Override
    public boolean needsDatabase() {
        return false;
    }

    public static class Parameter {
        String parm = null;
        String value = null;

        public Parameter() {
        }

        public Parameter(String parm, String value) {
            this.parm = parm;
            this.value = value;
        }

        public String getParm() {
            return this.parm;
        }

        public String getValue() {
            return this.value;
        }

        public void setParm(String parm) {
            this.parm = parm;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static enum SET_DDL_PARAMS {
        PRETTY,
        SQLTERMINATOR,
        CONSTRAINTS,
        REF_CONSTRAINTS,
        CONSTRAINTS_AS_ALTER,
        OID,
        SIZE_BYTE_KEYWORD,
        PARTITIONING,
        SEGMENT_ATTRIBUTES,
        STORAGE,
        TABLESPACE,
        SPECIFICATION,
        BODY,
        FORCE,
        INSERT,
        INHERIT,
        RESET,
        COLLATION_CLAUSE,
        EMIT_SCHEMA;

    }

    public static enum SET_DDL_OPTIONS {
        ON,
        OFF,
        TRUE,
        FALSE;

    }

    public static enum SET_COLLATION_OPTIONS {
        NEVER,
        ALWAYS,
        NON_DEFAULT;

    }
}

