/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import oracle.dbtools.raptor.utils.QuotedStringTokenizer;

public class CommitParser {
    private String originalStmt;
    private boolean work = false;
    private boolean comment = false;
    private String commentString;
    private boolean force;
    private String forceString;
    private int forceSCNInteger;
    private boolean write;
    private boolean wait;
    private boolean batch;
    private boolean allCorruptTxns;
    private String corruptXid = null;

    public static void main(String[] args) {
        CommitParser cp = new CommitParser("A default String");
        System.out.println(cp.parse("COMMIT") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK FORCE 'ABC'") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK FORCE CORRUPT_XID_ALL") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK FORCE CORRUPT_XID 'ABC'") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK COMMENT 'ABC DE'") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK COMMENT \"ABC DE FGH\"") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE IMMEDIATE") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE BATCH") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE IMMEDIATE NOWAIT") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE IMMEDIATE WAIT") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE BATCH WAIT") ? "TRUE" : "FALSE");
        System.out.println(cp.parse("COMMIT WORK WRITE BATCH NOWAIT") ? "TRUE" : "FALSE");
    }

    public CommitParser(String commitString) {
        this.originalStmt = commitString;
    }

    public String getOriginalStmt() {
        return this.originalStmt;
    }

    public boolean isWork() {
        return this.work;
    }

    public boolean hasComment() {
        return this.comment;
    }

    public String getCommentString() {
        return this.commentString;
    }

    public boolean hasForce() {
        return this.force;
    }

    public String getForceString() {
        return this.forceString;
    }

    public int getForceSCNInteger() {
        return this.forceSCNInteger;
    }

    public boolean hasWrite() {
        return this.write;
    }

    public boolean isWriteBatch() {
        return this.batch;
    }

    public boolean forceAllCorruptTxns() {
        return this.allCorruptTxns;
    }

    public String getCorruptXid() {
        return this.corruptXid;
    }

    public boolean parse(String anotherCommit) {
        this.originalStmt = anotherCommit;
        return this.parse();
    }

    public boolean parse() {
        QuotedStringTokenizer qst = new QuotedStringTokenizer(this.originalStmt);
        if (qst.hasMoreTokens()) {
            String first = qst.nextToken().toLowerCase();
            if (!first.trim().equals("commit")) {
                return false;
            }
            if (!qst.hasMoreTokens()) {
                return true;
            }
        }
        block48: while (qst.hasMoreTokens()) {
            String token;
            switch (token = qst.nextToken().toLowerCase()) {
                case "work": {
                    this.work = true;
                    continue block48;
                }
                case "force": {
                    String x;
                    this.force = true;
                    if (qst.hasMoreTokens()) {
                        this.forceString = qst.nextToken();
                        if (!qst.hasMoreTokens()) continue block48;
                        switch (x = qst.nextToken()) {
                            case ",": {
                                if (!qst.hasMoreTokens()) break;
                                String y = qst.nextToken();
                                try {
                                    int z;
                                    this.forceSCNInteger = z = Integer.parseInt(y);
                                    break;
                                }
                                catch (NumberFormatException nfe) {
                                    return false;
                                }
                            }
                            case "CORRUPT_XID_ALL": {
                                this.allCorruptTxns = true;
                                break;
                            }
                            case "CORRUPT_XID": {
                                if (qst.hasMoreTokens()) {
                                    this.corruptXid = qst.nextToken();
                                    break;
                                }
                                return false;
                            }
                        }
                        continue block48;
                    }
                    return false;
                }
                case "comment": {
                    this.comment = true;
                    if (qst.hasMoreTokens()) {
                        this.commentString = qst.nextToken();
                        continue block48;
                    }
                    return false;
                }
                case "write": {
                    String y;
                    String x;
                    this.write = true;
                    if (qst.hasMoreTokens()) {
                        switch (x = qst.nextToken().toLowerCase()) {
                            case "wait": {
                                this.wait = true;
                                break;
                            }
                            case "nowait": {
                                this.wait = false;
                                break;
                            }
                            case "immediate": {
                                this.batch = false;
                                break;
                            }
                            case "batch": {
                                this.batch = true;
                            }
                        }
                    }
                    if (!qst.hasMoreTokens()) continue block48;
                    switch (y = qst.peekNextToken().toLowerCase()) {
                        case "wait": {
                            qst.nextToken();
                            this.wait = true;
                            break;
                        }
                        case "nowait": {
                            qst.nextToken();
                            this.wait = false;
                            break;
                        }
                        case "immediate": {
                            qst.nextToken();
                            this.batch = false;
                            break;
                        }
                        case "batch": {
                            qst.nextToken();
                            this.batch = true;
                        }
                    }
                    continue block48;
                }
            }
            System.out.println("failed");
            return false;
        }
        return true;
    }
}

