/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.io.IOException;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.newscriptrunner.Clearable;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.HelpMessages;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;
import oracle.dbtools.raptor.newscriptrunner.console.IConsoleClearScreen;

public class Clear
extends CommandListener
implements IHelp {
    private static final String ALLCLR_PTRN = "(?:\\bcol(?:u|um|umn|umns)?\\b|\\bscr(?:e|ee|een)?\\b|\\bcomp(?:|u|ut|ute|utes)\\b|\\bbre(?:ak|aks)?\\b|\\bbuf(?:f|fe|fer)?\\b|\\bsq(?:l)?\\b|\\btimi(?:n|ng)?\\b|\\bcontext\\b)";
    private static final String CLEAR = "CLEAR";

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String sqlpcmd = cmd.getSql().toLowerCase().trim().replaceAll("\\s+", " ");
        String[] cmds = sqlpcmd.split(" ", 2);
        String clroption = "";
        boolean top = ctx.getTopLevel();
        boolean bval = false;
        if (cmds.length > 1) {
            Pattern pattern = null;
            pattern = Pattern.compile(ALLCLR_PTRN, 4);
            if (pattern != null) {
                Matcher matcher = pattern.matcher(cmds[1]);
                if (!matcher.find()) {
                    ctx.write(MessageFormat.format("SP2-0158: unknown CLEAR option \"{0}\"\n", cmds[1]));
                    ctx.errorLog(ctx.getSourceRef(), MessageFormat.format("SP2-0158: unknown CLEAR option \"{0}\"\n", cmds[1]), cmd.getSql());
                    return true;
                }
                matcher = pattern.matcher(cmds[1]);
                while (matcher.find()) {
                    String match = matcher.group();
                    if (match.equals("col") || match.equals("colu") || match.equals("colum") || match.equals("column") || match.equals("columns")) {
                        ctx.getStoredFormatCmds().clear();
                        bval = true;
                        if (!top) continue;
                        ctx.write(Messages.getString("Clear.6"));
                        continue;
                    }
                    if (match.equals("buff") || match.equals("buffe") || match.equals("buffer")) {
                        if (ctx.getSQLPlusBuffer() == null) continue;
                        ctx.getSQLPlusBuffer().clear();
                        ctx.getSQLPlusBuffer().getBufferSafe().clear();
                        if (!top) continue;
                        ctx.write(Messages.getString("Clear.2"));
                        continue;
                    }
                    if (match.equals("sql")) {
                        if (ctx.getSQLPlusBuffer() == null) continue;
                        ctx.getSQLPlusBuffer().clear();
                        ctx.getSQLPlusBuffer().getBufferSafe().clear();
                        if (!top) continue;
                        ctx.write(Messages.getString("Clear.4"));
                        continue;
                    }
                    if (match.equals("comp") || match.equals("compu") || match.equals("comput") || match.equals("compute") || match.equals("computes")) {
                        ctx.getStoredComputeCmds().clear();
                        if (!top) continue;
                        ctx.write(Messages.getString("Clear.5"));
                        continue;
                    }
                    if (match.startsWith("bre")) {
                        ctx.getStoredBreakCmds().clear();
                        if (!top) continue;
                        ctx.write(Messages.getString("Clear.7"));
                        continue;
                    }
                    if (match.equals("context")) {
                        ctx.deferredReInitClear();
                        if (!top) continue;
                        ctx.write(Messages.getString("Clear.8"));
                        continue;
                    }
                    if (match.equals("timi") || match.equals("timin") || match.equals("timing")) {
                        ctx.write(Messages.getString("Timing.Obsolete"));
                        return true;
                    }
                    if (match.equals("scr") || match.equals("scre") || match.equals("scree") || match.equals("screen")) {
                        if (ctx.getSQLPlusConsoleReader() != null) {
                            try {
                                String prompt = ctx.getPrompt();
                                IConsoleClearScreen runner = (IConsoleClearScreen)ctx.getSQLPlusConsoleReader();
                                runner.setPrompt("");
                                runner.doClearScreen((String)ctx.getProperty("sqlcl.clear.screen"));
                                runner.setPrompt(prompt);
                                bval = true;
                            }
                            catch (IOException prompt) {
                                // empty catch block
                            }
                        }
                        if (!(ctx.getOutputComponent() instanceof Clearable)) continue;
                        final Clearable clearme = (Clearable)ctx.getOutputComponent();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    clearme.clear();
                                }
                                catch (Exception e) {
                                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getStackTrace()[0].toString(), e);
                                }
                            }
                        });
                        bval = true;
                        continue;
                    }
                    ctx.write(MessageFormat.format("SP2-0158: unknown CLEAR option \"{0}\"\n", match));
                    ctx.errorLog(ctx.getSourceRef(), MessageFormat.format("SP2-0158: unknown CLEAR option \"{0}\"\n", cmds[1]), cmd.getSql());
                    return true;
                }
            }
        } else if (!ctx.isSQLPlusClassic()) {
            ctx.write(this.getHelp());
        }
        return bval;
    }

    @Override
    public String getCommand() {
        return CLEAR;
    }

    @Override
    public String getHelp() {
        return HelpMessages.getString(CLEAR);
    }

    @Override
    public boolean isSqlPlus() {
        return true;
    }
}

