/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.newscriptrunner.commands;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Messages;

public class Break
extends CommandListener {
    private static final String m_lineSeparator = System.getProperty("line.separator");
    private static final String BREAK = "\\b(?i:br(?:e\\b|ea\\b|eak\\b))";
    private static final String ON = "\\b(?i:(?:on|by|across))\\b";
    private static final String REPORT_ELEMENT = "(?:\\b(?i:report)\\b|\\b(?i:row)\\b|((?!(?i:report)|(?i:row))([\\p{Graph}\\u00b7])+))";
    private static final String SKIP1 = "(?i:\\bski(?:|p)\\b)(\\s+\\d+)?";
    private static final String SKIP2 = "((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b)";
    private static final String SKIP = "(?:(?i:\\bski(?:|p)\\b)(\\s+\\d+)?|((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b))";
    private static final String DUP = "(?i:dup(?:|licates))";
    private static final String NODUP = "(?i:no)(?i:dup(?:|licates))";
    private static final String DUP_OR_NODUP = "(?:(?i:dup(?:|licates))|(?i:no)(?i:dup(?:|licates)))";
    private static final String ACTION = "(?:(?:(?i:\\bski(?:|p)\\b)(\\s+\\d+)?|((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b))|(?:(?i:dup(?:|licates))|(?i:no)(?i:dup(?:|licates))))";
    private static final String CMD = "\\b(?i:br(?:e\\b|ea\\b|eak\\b))(\\s+\\b(?i:(?:on|by|across))\\b\\s+(?:\\b(?i:report)\\b|\\b(?i:row)\\b|((?!(?i:report)|(?i:row))([\\p{Graph}\\u00b7])+))(\\s+(?:(?:(?i:\\bski(?:|p)\\b)(\\s+\\d+)?|((?i:\\bski(?:|p)\\b)\\s+)?(?i:\\bpage\\b))|(?:(?i:dup(?:|licates))|(?i:no)(?i:dup(?:|licates)))))*)+";
    private static final String CLEAR = "\\b(?i:cl(?:e\\b|ea\\b|ear\\b))\\s+\\b(?i:br(?:e\\b|ea\\b|eak\\b))";

    @Override
    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String brkcmd = cmd.getSql().trim();
        LinkedHashMap<String, ArrayList<String>> storedBreakcmds = ctx.getStoredBreakCmds();
        Pattern ptrn = Pattern.compile(CMD);
        Matcher m = ptrn.matcher(brkcmd);
        boolean matches = m.matches();
        if (matches) {
            String[] rptElesActions;
            brkcmd = brkcmd.trim();
            storedBreakcmds.clear();
            brkcmd = brkcmd.replaceFirst("\\b(?i:br(?:e\\b|ea\\b|eak\\b))\\s+", "");
            for (String rptEleActions : rptElesActions = brkcmd.split("(\\s*\\b(?i:(?:on|by|across))\\b\\s*)")) {
                if (rptEleActions.length() <= 0) continue;
                ArrayList<String> actions = new ArrayList<String>();
                String rptElement = rptEleActions.split("\\s+")[0];
                rptElement = rptElement.replaceAll("(^(\\\"|\\')|(\\\"|\\')$)", "");
                String reActions = rptEleActions.replaceFirst(Pattern.quote(rptElement), "").replaceFirst("\\s+", "");
                Pattern aptrn = Pattern.compile(ACTION);
                Matcher amtchr = aptrn.matcher(reActions);
                while (amtchr.find()) {
                    if (amtchr.group().matches(SKIP2)) {
                        actions.add("page");
                        continue;
                    }
                    if (amtchr.group().matches(SKIP1)) {
                        if (amtchr.group(1) == null || amtchr.group(1).trim().equals("0")) continue;
                        actions.add(amtchr.group());
                        continue;
                    }
                    actions.add(amtchr.group());
                }
                if (actions.size() == 0) {
                    actions.add("nodup");
                } else {
                    Iterator iter = actions.iterator();
                    boolean hasDuporNoDup = false;
                    while (iter.hasNext()) {
                        String action = (String)iter.next();
                        if (!action.matches(DUP_OR_NODUP)) continue;
                        hasDuporNoDup = true;
                        break;
                    }
                    if (!hasDuporNoDup) {
                        actions.add("nodup");
                    }
                }
                String key = this.getKeyForStr(ctx.getStoredBreakCmds(), rptElement);
                if (key != null && (rptElement.equalsIgnoreCase("report") || rptElement.equalsIgnoreCase("row"))) {
                    ctx.getStoredBreakCmds().put(key, actions);
                    continue;
                }
                LinkedHashMap<String, ArrayList<String>> stoBrkcmds = new LinkedHashMap<String, ArrayList<String>>();
                if (rptElement.equalsIgnoreCase("report")) {
                    stoBrkcmds.put(rptElement, actions);
                    stoBrkcmds.putAll(ctx.getStoredBreakCmds());
                    ctx.setStoredBreakCmds(stoBrkcmds);
                    continue;
                }
                if (rptElement.equalsIgnoreCase("row")) {
                    stoBrkcmds.putAll(ctx.getStoredBreakCmds());
                    stoBrkcmds.put(rptElement, actions);
                    ctx.setStoredBreakCmds(stoBrkcmds);
                    continue;
                }
                String rowKey = this.getKeyForStr(ctx.getStoredBreakCmds(), "row");
                if (rowKey != null) {
                    ArrayList<String> rowVal = new ArrayList<String>();
                    ArrayList<String> orowVal = ctx.getStoredBreakCmds().get(rowKey);
                    rowVal.addAll(orowVal);
                    stoBrkcmds.putAll(ctx.getStoredBreakCmds());
                    stoBrkcmds.remove(rowKey);
                    stoBrkcmds.put(rptElement, actions);
                    stoBrkcmds.put(rowKey, rowVal);
                    ctx.setStoredBreakCmds(stoBrkcmds);
                    continue;
                }
                ctx.getStoredBreakCmds().put(rptElement, actions);
            }
        } else if (brkcmd.matches(BREAK)) {
            Object breakcmd = "";
            if (storedBreakcmds.size() > 0) {
                breakcmd = "break ";
                String spaces = String.format("%1$" + ((String)breakcmd).length() + "s", " ");
                Iterator<String> iter = storedBreakcmds.keySet().iterator();
                int k = -1;
                while (iter.hasNext()) {
                    String rptElement = iter.next();
                    ArrayList<String> actions = storedBreakcmds.get(rptElement);
                    if (++k > 0) {
                        breakcmd = (String)breakcmd + spaces;
                    }
                    for (int i = 0; i < actions.size(); ++i) {
                        if (i == 0) {
                            breakcmd = (String)breakcmd + "on " + rptElement + " ";
                        }
                        String action = actions.get(i);
                        breakcmd = (String)breakcmd + action + " ";
                    }
                    breakcmd = (String)breakcmd + m_lineSeparator;
                }
                ctx.write((String)breakcmd + m_lineSeparator);
            } else {
                ctx.write(Messages.getString("NOBREAKS") + m_lineSeparator);
            }
        } else {
            String bcmd = brkcmd;
            String[] patterns = new String[]{BREAK, ON, REPORT_ELEMENT, ACTION};
            for (int i = 0; i < patterns.length; ++i) {
                Pattern p = Pattern.compile(patterns[i]);
                Matcher a = p.matcher(bcmd);
                if (a.find()) {
                    if (patterns[i].equals(REPORT_ELEMENT)) {
                        bcmd = bcmd.replaceFirst(patterns[i], "").trim();
                        continue;
                    }
                    bcmd = bcmd.replaceAll(patterns[i], "").trim();
                    continue;
                }
                if (patterns[i].equals(ON)) {
                    ctx.write(Messages.getString("BRK_SPEC") + m_lineSeparator);
                } else {
                    if (!patterns[i].equals(ACTION)) continue;
                    ctx.write(MessageFormat.format(Messages.getString("BRK_ACTN"), bcmd.split("\\s+")[0]) + m_lineSeparator);
                }
                break;
            }
        }
        return false;
    }

    private String getKeyForStr(LinkedHashMap<String, ArrayList<String>> storedBreakcmds, String forStr) {
        String key = null;
        for (String s : storedBreakcmds.keySet()) {
            if (!forStr.equalsIgnoreCase(s)) continue;
            key = s;
            return key;
        }
        return key;
    }

    public static boolean hasRowElement(LinkedHashMap<String, ArrayList<String>> storedBreakcmds) {
        boolean flag = false;
        for (String s : storedBreakcmds.keySet()) {
            if (!s.matches("(?i:row)")) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    @Override
    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }
}

