/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.format;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.arbori.util.DbObjNames;
import oracle.dbtools.app.SqlRecognizer;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetFormatter;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.format.Messages;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.newscriptrunner.ScriptUtils;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.dbtools.util.Closeables;
import oracle.jdbc.OracleResultSet;

public class ResultSetFormatterWrapper
extends ResultsFormatterWrapper {
    private ResultSet m_rs;
    private ResultSetMetaData m_meta;
    private String m_sql;
    private int[] m_dataTypes;
    private ObjectType m_objectType = ObjectType.PROPRIETARY;
    private int _maxRows = 0;
    private Parsed m_parsed;
    private ArrayList<Integer> m_exportCols = null;
    private int m_colCount = 0;
    private List<String> recogCols = null;

    public ResultSetFormatterWrapper() {
        this.m_objectType = ObjectType.PROPRIETARY;
    }

    public ResultSetFormatterWrapper(ResultSet rs, int maxRows) {
        this(rs, maxRows, null, null);
    }

    public ResultSetFormatterWrapper(ResultSet rs, int maxRows, Parsed parsed, String sql) {
        this.setResultSet(rs, ObjectType.PROPRIETARY, parsed, sql);
        this._maxRows = maxRows;
    }

    public ResultSetFormatterWrapper(ResultSet rs, ObjectType objectType) {
        this.setResultSet(rs, objectType, null, null);
    }

    public ResultSetFormatterWrapper(ResultSet rs, ArrayList<Integer> exportCols, List<String> exportColNames, int[] exportSizes, int[] exportDataTypes, String sql) {
        this.m_rs = rs;
        this.setSQL(sql);
        this.m_exportCols = exportCols;
        this.setColumnNames(exportColNames);
        this.setColumnSizes(exportSizes);
        this.setPrecisions(exportSizes);
        this.m_dataTypes = exportDataTypes;
    }

    public ResultSetFormatterWrapper(ResultSet rs, ArrayList<Integer> exportCols, String sql) {
        this.m_exportCols = exportCols;
        this.setSQL(sql);
        this.setResultSet(rs);
    }

    public ResultSetFormatterWrapper(ResultSet rs, ArrayList<Integer> exportCols) {
        this(rs, exportCols, null);
    }

    protected void setResultSet(ResultSet rs) {
        this.m_rs = rs;
        try {
            this.m_meta = this.m_rs.getMetaData();
            this.m_colCount = this.m_exportCols == null ? this.m_meta.getColumnCount() : this.m_exportCols.size();
            ArrayList<String> colNames = new ArrayList<String>();
            int[] colSizes = new int[this.m_colCount + 1];
            int[] precisions = new int[this.m_colCount + 1];
            int[] scales = new int[this.m_colCount + 1];
            for (int i = 0; i < this.m_colCount; ++i) {
                int ci = this.m_exportCols == null ? i : this.m_exportCols.get(i);
                String columnName = this.getCol(ci);
                switch (this.m_meta.getColumnType(i + 1)) {
                    case 91: 
                    case 92: 
                    case 93: {
                        colSizes[i] = 25;
                        break;
                    }
                    default: {
                        colSizes[i] = columnName.length();
                    }
                }
                colNames.add(columnName);
                scales[i] = this.m_meta.getScale(ci + 1);
                precisions[i] = this.m_meta.getPrecision(ci + 1);
            }
            this.setColumnNames(colNames);
            this.setColumnSizes(colSizes);
            this.setScales(scales);
            this.setPrecisions(precisions);
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
    }

    protected void setResultSet(ResultSet rs, ObjectType objectType) {
        this.m_objectType = objectType;
        this.setResultSet(rs);
    }

    private String getCol(int i) {
        String columnName = null;
        try {
            columnName = this.m_meta.getColumnName(i + 1);
        }
        catch (SQLException ex) {
            ResultSetFormatterWrapper.logException(String.format("getColumnName(%d) failed", i), ex);
        }
        if (columnName != null && !columnName.contains("-") && !columnName.contains("/")) {
            return columnName;
        }
        try {
            String newColName = this.getColumnNameFromParsed2(i);
            if (newColName != null) {
                return DbObjNames.handleMixedCase((String)newColName);
            }
            throw new Exception(String.format("recognized name for column at index %d is null", i));
        }
        catch (Throwable ex) {
            ResultSetFormatterWrapper.logException(String.format("getColumnNameFromParsed2(%d) failed", i), ex);
            return columnName == null ? "COL" + i : columnName;
        }
    }

    private static void logException(String message, Throwable thrown) {
        Logger l = Logger.getLogger("oracle.dbtools");
        l.log(Level.WARNING, message, thrown);
    }

    public String getColumnNameFromParsed2(int i) {
        if (this.m_sql == null) {
            return null;
        }
        if (this.recogCols == null) {
            this.recogCols = SqlRecognizer.getColumnNames(this.m_sql);
        }
        if (i >= this.recogCols.size()) {
            return null;
        }
        return this.recogCols.get(i);
    }

    protected void setResultSet(ResultSet rs, ObjectType objectType, Parsed parsed, String sql) {
        this.m_objectType = objectType;
        this.setSQL(sql);
        this.m_parsed = parsed;
        this.setResultSet(rs);
    }

    @Override
    public Connection getConnection() {
        Connection conn = null;
        try {
            conn = this.m_rs.getStatement().getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return conn;
    }

    @Override
    public int getDataType(int col) throws SQLException {
        if (this.m_exportCols == null) {
            String colTypeName = this.m_meta.getColumnTypeName(col + 1);
            return this.m_meta.getColumnType(col + 1);
        }
        if (this.m_dataTypes == null) {
            return this.m_meta.getColumnType(this.m_exportCols.get(col) + 1);
        }
        return this.m_dataTypes[col];
    }

    @Override
    public String getDataTypeName(int col) throws SQLException {
        if (this.m_exportCols == null) {
            String colTypeName = this.m_meta.getColumnTypeName(col + 1);
            return colTypeName;
        }
        if (this.m_dataTypes == null) {
            return this.m_meta.getColumnTypeName(this.m_exportCols.get(col) + 1);
        }
        return this.m_meta.getColumnTypeName(this.m_dataTypes[col] + 1);
    }

    @Override
    public int print() throws IOException {
        int ret = 0;
        try {
            ret = this.print(null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String getSQL() {
        return this.getmSql();
    }

    private String getmSql() {
        return this.m_sql;
    }

    public void setSQL(String sql) {
        this.m_sql = sql;
        this.recogCols = null;
    }

    @Override
    public int print(IRaptorTaskProgressUpdater updater) throws IOException, ExecutionException {
        int ret = 0;
        this.m_formatter.start();
        try {
            this.m_rowNum = 0L;
            while (this.m_rs != null && (this.m_formatter.isCandidateForSpoolMax().booleanValue() && ResultSetFormatter.replaceNext(this.m_rowNum, this._maxRows, this.m_formatter.getScriptContext(), this.m_formatter.getOutputStream(), this.m_rs, null, this.m_formatter) || !this.m_formatter.isCandidateForSpoolMax().booleanValue() && this.m_rs.next()) && (this._maxRows == 0 || this.m_rowNum < (long)this._maxRows || ResultSetFormatter.maxRowsSpoolOnly(this.m_formatter.getScriptContext()))) {
                int ii;
                if (updater != null) {
                    updater.checkCanProceed();
                } else if (this.isInterrupted()) {
                    this.m_rs.getStatement().cancel();
                    break;
                }
                ++this.m_rowNum;
                this.m_formatter.log(Messages.getString("ResultSetFormatterWrapper.1") + this.m_rs.getRow());
                this.m_formatter.startRow();
                Object o = null;
                if (this.m_exportCols == null) {
                    for (ii = 0; ii < this.m_meta.getColumnCount(); ++ii) {
                        if (this.m_objectType == ObjectType.PROPRIETARY && this.m_rs instanceof OracleResultSet) {
                            try {
                                o = ScriptUtils.getOracleObjectWrap((OracleResultSet)this.m_rs, ii + 1);
                            }
                            catch (SQLException e) {
                                o = this.m_rs.getObject(ii + 1);
                            }
                        } else {
                            o = this.m_rs.getObject(ii + 1);
                        }
                        this.m_formatter.printColumn(o, ii, ii);
                    }
                } else {
                    for (ii = 0; ii < this.m_exportCols.size(); ++ii) {
                        o = this.m_objectType == ObjectType.PROPRIETARY && this.m_rs instanceof OracleResultSet ? ScriptUtils.getOracleObjectWrap((OracleResultSet)this.m_rs, this.m_exportCols.get(ii) + 1) : this.m_rs.getObject(this.m_exportCols.get(ii) + 1);
                        this.m_formatter.printColumn(o, ii, ii);
                    }
                }
                if (o instanceof ResultSet) {
                    Closeables.close((ResultSet)o);
                }
                this.m_formatter.endRow();
                ret = this.m_rs.getRow();
            }
        }
        catch (ExecutionException e) {
            try {
                if (this.m_rs != null) {
                    this.m_rs.getStatement().cancel();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.handleException(ex);
            }
        }
        catch (SQLException e) {
            ExceptionHandler.handleException(e);
        }
        catch (IOException e) {
            ExceptionHandler.handleException(e);
        }
        this.m_formatter.end();
        return ret;
    }

    @Override
    public void close() {
        if (this.m_rs != null) {
            DBUtil.closeResultSet(this.m_rs);
        }
    }

    public static enum ObjectType {
        GENERIC,
        PROPRIETARY;

    }
}

