/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.values;

import java.util.List;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.util.StringValue;

public class NamedDataValue
extends NamedValue<DataValue>
implements DataValue {
    private NamedDataValue(String name, DataValue dataValue) {
        super(name, NamedDataValue.getUnnamedDataValue(dataValue));
    }

    public static DataValue getNamedDataValue(String name, DataValue datavalue) {
        if (NamedDataValue.areEquals(name, datavalue.getName())) {
            return datavalue;
        }
        if (name == null) {
            return NamedDataValue.getUnnamedDataValue(datavalue);
        }
        return new NamedDataValue(name, datavalue);
    }

    @Override
    public final StringValue getStringValue() {
        return ((DataValue)this.value).getStringValue();
    }

    @Override
    public final StringValue getStringValue(int maxLen) {
        return ((DataValue)this.value).getStringValue(maxLen);
    }

    @Override
    public final StringValue getStringValue(StringType stringType) {
        return ((DataValue)this.value).getStringValue(stringType);
    }

    @Override
    public final StringValue getStringValue(StringType stringType, int maxLen) {
        return ((DataValue)this.value).getStringValue(stringType, maxLen);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType) {
        return this.getStringValue(connectionProvider, stringType, -1);
    }

    @Override
    public final StringValue getStringValue(DataTypeConnectionProvider connectionProvider, StringType stringType, int maxLen) {
        return ((DataValue)this.value).getStringValue(connectionProvider, stringType, maxLen);
    }

    @Override
    public final Object getTypedValue() {
        return ((DataValue)this.value).getTypedValue();
    }

    @Override
    public final Object getTypedValue(ValueType valueType) {
        return ((DataValue)this.value).getTypedValue(valueType);
    }

    @Override
    public final Object getTypedValue(Object target) {
        return ((DataValue)this.value).getTypedValue(target);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        return this.getTypedValue(connectionProvider, valueType, null);
    }

    @Override
    public final Object getTypedValue(DataTypeConnectionProvider connectionProvider, ValueType valueType, Object target) {
        return ((DataValue)this.value).getTypedValue(connectionProvider, valueType, target);
    }

    public String toString() {
        return ((DataValue)this.value).toString();
    }

    @Override
    public final boolean isNull() {
        return ((DataValue)this.value).isNull();
    }

    @Override
    public final void marshal(DataValueMarshalHandler hd, String name) {
        ((DataValue)this.value).marshal(hd, name);
    }

    @Override
    public final void marshal(DataValueMarshalHandler hd) {
        hd.marshal((DataValue)this.value, this.getName());
    }

    @Override
    public final boolean isSupported() {
        return ((DataValue)this.value).isSupported();
    }

    @Override
    public final List<DataValue> getComponents() {
        return ((DataValue)this.value).getComponents();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final DataType getDataType() {
        return ((DataValue)this.value).getDataType();
    }

    @Override
    public DataValue getBindingDataValue() {
        return ((DataValue)this.value).getBindingDataValue();
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEquals;
        boolean bl = isEquals = this == obj;
        if (!isEquals && obj instanceof DataValue) {
            DataValue objValue = (DataValue)obj;
            DataValue unnamedObj = NamedDataValue.getUnnamedDataValue(objValue);
            DataValue unnamedValue = NamedDataValue.getUnnamedDataValue((DataValue)this.value);
            isEquals = NamedDataValue.areEquals(unnamedValue, unnamedObj);
        }
        return isEquals;
    }

    private static DataValue getUnnamedDataValue(DataValue datavalue) {
        DataValue ret = datavalue;
        while (ret instanceof NamedDataValue) {
            NamedDataValue retDatavalue = (NamedDataValue)ret;
            ret = (DataValue)retDatavalue.value;
        }
        return ret;
    }

    private static boolean areEquals(Object obj1, Object obj2) {
        return obj1 == obj2 || obj1 != null && obj2 != null && obj1.equals(obj2);
    }
}

