/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.preparedstatement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStrategySplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;
import oracle.dbtools.raptor.datatypes.strategies.statement.StatementBindingBase;

public abstract class PrepareBindingBase<S extends PreparedStatement, P extends DataBinding>
extends StatementBindingBase<S, P> {
    protected PrepareBindingBase(BindContext<S> context, P param) {
        this(context, param, param.getDataType(), param.getMode());
    }

    protected PrepareBindingBase(BindContext<S> context, P param, DataType dataType, BindingMode mode) {
        super(context, param, dataType, mode);
    }

    @Override
    public final DataValue getInput() throws SQLException {
        return this.getBindContext().getInput(this);
    }

    protected final void setInput(DataValue inputValue) throws SQLException {
        this.getBindContext().cacheInput(this, inputValue);
    }

    @Override
    public final void bind(S stmt, DataValue value) throws SQLException {
        this.setStatement(stmt);
        this.setInput(value);
        this.customBind(value);
    }

    protected void customBind(DataValue value) throws SQLException {
        switch (this.getMode().getEffectiveMode()) {
            case IN: {
                this.customBindIN(value);
                break;
            }
            case OUT: {
                this.customBindOUT();
                break;
            }
            case IN_OUT: {
                this.customBindIN(value);
                this.customBindOUT();
            }
        }
    }

    protected abstract void customBindIN(DataValue var1) throws SQLException;

    @Override
    public final void bind(S stmt) throws SQLException {
        this.bind(stmt, null);
    }

    protected void customBind() throws SQLException {
        switch (this.getMode().getEffectiveMode()) {
            case OUT: 
            case IN_OUT: {
                this.customBindOUT();
            }
        }
    }

    protected abstract void customBindOUT() throws SQLException;

    @Override
    public DataValue getOutput() throws SQLException {
        return null;
    }

    @Override
    protected PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder builder) {
        return builder;
    }

    @Override
    public BindingStrategySplitMode<S, P> getSplitModeBinding() {
        return null;
    }
}

