/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.strategies.callablestatement;

import java.sql.SQLException;
import java.util.Collection;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.strategies.callablestatement.CallableBindingDatum;
import oracle.jdbc.OracleCallableStatement;

public class CallableBindingIndexTABLE<S extends OracleCallableStatement, P extends DataBinding>
extends CallableBindingDatum<S, P> {
    public CallableBindingIndexTABLE(BindContext<S> context, P param) {
        super(context, param);
    }

    @Override
    public BindingStyle getBindingStyle(BindingMode mode) {
        return BindingStyle.POSITION;
    }

    @Override
    protected void customBindIN(DataValue value, int pos) throws SQLException {
        Object[] typedValue = (Object[])value.getTypedValue(this.getBindContext().getDataTypeConnectionProvider(), ValueType.JDBC);
        Collection<NamedValue<DataType>> typeComponents = this.getDataType().getTypeComponents();
        DataType typeComponent = (DataType)((NamedValue)typeComponents.iterator().next()).getValue();
        int elemSqlType = typeComponent.getSqlDataType(ValueType.JDBC);
        Integer elemDataLength = typeComponent.getTypeMetadata().get_data_length();
        int elemMaxLen = elemDataLength != null ? elemDataLength : 0;
        ((OracleCallableStatement)this.getStatement()).setPlsqlIndexTable(pos, (Object)typedValue, typedValue.length, typedValue.length, elemSqlType, elemMaxLen);
    }

    @Override
    protected void customBindOUT(int pos) throws SQLException {
        Collection<NamedValue<DataType>> typeComponents = this.getDataType().getTypeComponents();
        DataType typeComponent = (DataType)((NamedValue)typeComponents.iterator().next()).getValue();
        int elemSqlType = typeComponent.getSqlDataType(ValueType.JDBC);
        Integer elemDataLength = typeComponent.getTypeMetadata().get_data_length();
        int elemMaxLen = elemDataLength != null ? elemDataLength : 0;
        ((OracleCallableStatement)this.getStatement()).registerIndexTableOutParameter(pos, 1000, elemSqlType, elemMaxLen);
    }

    @Override
    protected DataValue customOutput(int pos) throws SQLException {
        Object result = ((OracleCallableStatement)this.getStatement()).getPlsqlIndexTable(pos);
        return this.getDataType().getDataValue(result);
    }
}

