/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.objects.OraTIMESTAMPTZ;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.oracle.sql.TimeZoneDatum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.util.TemporalUtil;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OraTIMESTAMPTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;

public class TIMESTAMPTZ
extends TimeZoneDatum {
    protected TIMESTAMPTZ(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: {
                try {
                    if (internalValue instanceof oracle.sql.TIMESTAMPTZ) {
                        OraTIMESTAMPTZ tstz = OraTIMESTAMPTZ.getInstance((oracle.sql.TIMESTAMPTZ)internalValue);
                        return new StringValue(TemporalUtil.toRestString(tstz));
                    }
                }
                catch (Exception e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
            case GENERIC: {
                try {
                    if (internalValue instanceof oracle.sql.TIMESTAMPTZ) {
                        return new StringValue(((oracle.sql.TIMESTAMPTZ)internalValue).timestampValue(connectionProvider.getNLSConnection()).toString());
                    }
                    break;
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        Object internalValue = value.getInternalValue();
        switch (valueType) {
            case JDBC: {
                try {
                    if (internalValue instanceof oracle.sql.TIMESTAMPTZ) {
                        oracle.sql.TIMESTAMPTZ timestampValue = (oracle.sql.TIMESTAMPTZ)internalValue;
                        return oracle.sql.TIMESTAMPTZ.toTimestamp(connectionProvider.getNLSConnection(), (byte[])timestampValue.getBytes());
                    }
                    break;
                }
                catch (SQLException e) {
                    throw new DataTypeIllegalArgumentException(this, internalValue);
                }
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                if (connectionProvider.peekNLSConnection() == null) {
                    return super.customTypedClass(connectionProvider, valueType);
                }
            }
            case DATUM: {
                return oracle.sql.TIMESTAMPTZ.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -101;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value instanceof oracle.sql.TIMESTAMPTZ) {
                return value;
            }
            if (value instanceof byte[]) {
                return new oracle.sql.TIMESTAMPTZ(Arrays.copyOf((byte[])value, ((byte[])value).length));
            }
            Object superObject = super.customInternalValue(connectionProvider, value);
            if (superObject instanceof OraTIMESTAMPTZ) {
                return ((OraTIMESTAMPTZ)superObject).getDatum();
            }
            if (superObject instanceof OraTemporalDatum) {
                Timestamp ts = ((OraTemporalDatum)superObject).toTimestamp();
                if (connectionProvider.peekNLSConnection() != null) {
                    return new oracle.sql.TIMESTAMPTZ(connectionProvider.getNLSConnection(), ts);
                }
                return OraTIMESTAMPTZ.getInstance(ts.toInstant().atZone(TimeZone.getDefault().toZoneId())).getDatum();
            }
            return this.typedValueFromNLSString(connectionProvider, superObject.toString());
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value);
        }
    }

    protected oracle.sql.TIMESTAMPTZ typedValueFromNLSString(DataTypeConnectionProvider connectionProvider, String value) {
        OraTIMESTAMPTZFormat format;
        try {
            format = ((OracleNLSProvider)NLSProvider.getProvider(connectionProvider.getNLSConnection())).getOraTIMESTAMPTZFormat();
        }
        catch (ParseException pe) {
            format = null;
        }
        return format.parse(value, new ParsePosition(0));
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "TIMESTAMP_TZ_UNCONSTRAINED";
    }

    @Override
    protected String customDataTypeString() {
        Integer scale = this.typeMetadata.get_data_scale();
        if (scale != null) {
            return "TIMESTAMP (" + scale + ") WITH TIME ZONE";
        }
        return "TIMESTAMP WITH TIME ZONE";
    }
}

