/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.io.IOException;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeEncodingException;
import oracle.dbtools.raptor.datatypes.DataTypeIOException;
import oracle.dbtools.raptor.datatypes.DataTypeIllegalArgumentException;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.marshal.DataValueMarshalHandler;
import oracle.dbtools.raptor.datatypes.objects.LongBinary;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.utils.NLSUtils;
import oracle.dbtools.util.encoding.EncodingException;
import org.xml.sax.SAXException;

public class RAW
extends Datum {
    protected RAW(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        switch (stringType) {
            case NLS: {
                return new StringValue((CharSequence)NLSUtils.getValue(connectionProvider.getNLSConnection(), value.getInternalValue()));
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case JDBC: {
                return byte[].class;
            }
            case DEFAULT: {
                return oracle.sql.RAW.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -2;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        try {
            if (value instanceof oracle.sql.RAW) {
                return value;
            }
            LongBinary longBinary = LongBinary.constructFrom(value, -1);
            return new oracle.sql.RAW((byte[])longBinary.getValue());
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (EncodingException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (SQLException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
        catch (IOException e) {
            throw new DataTypeIllegalArgumentException(this, value, e);
        }
    }

    @Override
    protected void customMarshal(DataTypeConnectionProvider connectionProvider, DataValueInternal value, DataValueMarshalHandler hd, String name) throws SAXException {
        LongBinary longBinary = new LongBinary(((oracle.sql.RAW)value.getInternalValue()).getBytes());
        longBinary.marshal(this, hd, name);
    }

    @Override
    public Object startDataValue(String name, boolean isNull) {
        if (isNull) {
            return null;
        }
        return LongBinary.getBuilder(-1);
    }

    @Override
    public void bodyDataValue(NamedValue value, char[] ch, int start, int length) {
        LongBinary.LongBinaryBuilder builder = (LongBinary.LongBinaryBuilder)value.getValue();
        try {
            builder.write(ch, start, length);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
        catch (EncodingException e) {
            throw new DataTypeEncodingException(e);
        }
    }

    @Override
    public DataValue endDataValue(NamedValue value) {
        LongBinary.LongBinaryBuilder builder = (LongBinary.LongBinaryBuilder)value.getValue();
        try {
            return this.getDataValue(builder != null ? (byte[])builder.build().getValue() : null);
        }
        catch (IOException e) {
            throw new DataTypeIOException(e);
        }
    }
}

