/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.oracle.sql;

import java.util.Arrays;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.StringType;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.ValueType;
import oracle.dbtools.raptor.datatypes.impl.DataValueInternal;
import oracle.dbtools.raptor.datatypes.objects.OraINTERVALYM;
import oracle.dbtools.raptor.datatypes.oracle.sql.Datum;
import oracle.dbtools.raptor.datatypes.util.StringValue;
import oracle.dbtools.raptor.datatypes.util.TemporalUtil;

public class INTERVALYM
extends Datum {
    protected INTERVALYM(DataTypeContext context, TypeMetadata typeMetadata) {
        super(context, typeMetadata);
    }

    @Override
    protected StringValue customStringValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, StringType stringType, int maxLen) {
        Object internalValue = value.getInternalValue();
        switch (stringType) {
            case REST: {
                if (internalValue == null) break;
                return new StringValue(TemporalUtil.ISO8601format(OraINTERVALYM.getInstance((oracle.sql.INTERVALYM)internalValue)));
            }
        }
        return super.customStringValue(connectionProvider, value, stringType, maxLen);
    }

    @Override
    protected Object customTypedValue(DataTypeConnectionProvider connectionProvider, DataValueInternal value, ValueType valueType, Object target) {
        switch (valueType) {
            case JDBC: {
                return this.customTypedValue(connectionProvider, value, ValueType.DEFAULT, target);
            }
        }
        return super.customTypedValue(connectionProvider, value, valueType, target);
    }

    @Override
    protected Class customTypedClass(DataTypeConnectionProvider connectionProvider, ValueType valueType) {
        switch (valueType) {
            case DEFAULT: {
                return oracle.sql.INTERVALYM.class;
            }
        }
        return super.customTypedClass(connectionProvider, valueType);
    }

    @Override
    protected int customSqlDataType(ValueType valueType) {
        switch (valueType) {
            case DATUM: {
                return -103;
            }
        }
        return super.customSqlDataType(valueType);
    }

    @Override
    protected Object customInternalValue(DataTypeConnectionProvider connectionProvider, Object value) {
        OraINTERVALYM oraInterval;
        CharSequence text;
        if (value instanceof oracle.sql.INTERVALYM) {
            return value;
        }
        if (value instanceof byte[]) {
            return new oracle.sql.INTERVALYM(Arrays.copyOf((byte[])value, ((byte[])value).length));
        }
        if (value instanceof OraINTERVALYM) {
            return ((OraINTERVALYM)value).getDatum();
        }
        if (value instanceof CharSequence && ((text = (CharSequence)value).length() > 0 && text.charAt(0) == 'P' || text.length() > 1 && (text.charAt(0) == '+' || text.charAt(0) == '-') && text.charAt(1) == 'P') && (oraInterval = TemporalUtil.YM_ISO8601parse(text)) != null) {
            return oraInterval.getDatum();
        }
        return new oracle.sql.INTERVALYM(value.toString());
    }

    @Override
    protected String customUnconstrainedDataTypeString() {
        return "YMINTERVAL_UNCONSTRAINED";
    }

    @Override
    protected String customDataTypeString() {
        Integer precision = this.typeMetadata.get_data_precision();
        if (precision != null) {
            return "INTERVAL YEAR (" + precision + ") TO MONTH";
        }
        return "INTERVAL YEAR TO MONTH";
    }
}

