/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraResolvableDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimestampDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraConversions;
import oracle.dbtools.raptor.nls.OraTIMESTAMPLTZFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.TIMESTAMPLTZ;

public class OraTIMESTAMPLTZ
extends OraResolvableDatum
implements OraTimestampDatum {
    public static OraTIMESTAMPLTZ getInstance() {
        return OraTIMESTAMPLTZ.getInstance(Instant.now());
    }

    public static OraTIMESTAMPLTZ getInstance(TimeZone dbTimeZone) {
        if (dbTimeZone != null) {
            return OraTIMESTAMPLTZ.getInstance(dbTimeZone.toZoneId());
        }
        return OraTIMESTAMPLTZ.getInstance();
    }

    public static OraTIMESTAMPLTZ getInstance(ZoneId dbZone) {
        OraTIMESTAMPLTZ instance = OraTIMESTAMPLTZ.getInstance();
        if (dbZone != null) {
            instance.setDBZone(dbZone);
        }
        return instance;
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar, Integer nanos) {
        return calendar != null ? OraTIMESTAMPLTZ.getInstance(OraConversions.toInstant(calendar, nanos)) : null;
    }

    public static OraTIMESTAMPLTZ getInstance(Calendar calendar) {
        return OraTIMESTAMPLTZ.getInstance(calendar, null);
    }

    public static OraTIMESTAMPLTZ getInstance(TIMESTAMPLTZ datetime) {
        return datetime != null ? new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(datetime, OraResolvableDatum.Realization.LTZ_INSTANT, null)) : null;
    }

    public static OraTIMESTAMPLTZ getInstance(TIMESTAMPLTZ datetime, TimeZone dbTimeZone) {
        if (datetime == null) {
            return null;
        }
        if (dbTimeZone != null) {
            return OraTIMESTAMPLTZ.getInstance(datetime, dbTimeZone.toZoneId());
        }
        return OraTIMESTAMPLTZ.getInstance(datetime);
    }

    public static OraTIMESTAMPLTZ getInstance(TIMESTAMPLTZ datetime, ZoneId dbZone) {
        if (datetime == null) {
            return null;
        }
        if (dbZone != null) {
            return new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(datetime, OraResolvableDatum.Realization.INSTANT, dbZone));
        }
        return OraTIMESTAMPLTZ.getInstance(datetime);
    }

    public static OraTIMESTAMPLTZ getInstance(LocalDateTime datetime, ZoneId dbZone) {
        if (datetime == null) {
            return null;
        }
        if (dbZone != null) {
            return new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(ZonedDateTime.of(datetime, dbZone).toInstant(), OraResolvableDatum.Realization.INSTANT, dbZone));
        }
        return OraTIMESTAMPLTZ.getInstance(datetime);
    }

    public static OraTIMESTAMPLTZ getInstance(Instant instant) {
        return instant != null ? new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(instant)) : null;
    }

    public static OraTIMESTAMPLTZ getInstance(Date datetime) {
        return datetime != null ? OraTIMESTAMPLTZ.getInstance(datetime.toInstant()) : null;
    }

    public static OraTIMESTAMPLTZ getInstance(LocalDateTime datetime) {
        return datetime != null ? new OraTIMESTAMPLTZ(new OraTIMESTAMPLTZImpl(datetime)) : null;
    }

    public static OraTIMESTAMPLTZ getInstance(LocalDateTime datetime, TimeZone dbTimeZone) {
        if (datetime == null) {
            return null;
        }
        if (dbTimeZone != null) {
            return OraTIMESTAMPLTZ.getInstance(datetime, dbTimeZone.toZoneId());
        }
        return OraTIMESTAMPLTZ.getInstance(datetime);
    }

    public static OraTIMESTAMPLTZ getInstance(OraTemporalDatum temporalDatum) {
        OraTIMESTAMPLTZ tsLTZ = null;
        if (temporalDatum != null) {
            tsLTZ = OraTIMESTAMPLTZ.getInstance();
            tsLTZ.replicate(temporalDatum);
        }
        return tsLTZ;
    }

    protected OraTIMESTAMPLTZ(OraTIMESTAMPLTZImpl impl) {
        super(impl);
    }

    @Override
    protected OraTIMESTAMPLTZImpl getImpl() {
        return (OraTIMESTAMPLTZImpl)super.getImpl();
    }

    public final OraTIMESTAMPLTZ setDBTimeZone(TimeZone timezone) {
        return this.setDBZone(timezone != null ? timezone.toZoneId() : null);
    }

    public final TimeZone getDBTimeZone() {
        ZoneId zone = this.getDBZone();
        return zone != null ? TimeZone.getTimeZone(zone) : null;
    }

    public final OraTIMESTAMPLTZ setDBZone(ZoneId zone) {
        this.getImpl().setDBZone(zone);
        return this;
    }

    public final ZoneId getDBZone() {
        return this.getImpl().getDBZone();
    }

    @Override
    public OraTIMESTAMPLTZ setSessionTimeZone(TimeZone sessionTimeZone) {
        super.setSessionTimeZone(sessionTimeZone);
        return this;
    }

    @Override
    public OraTIMESTAMPLTZ setSessionZone(ZoneId zone) {
        super.setSessionZone(zone);
        return this;
    }

    public TIMESTAMPLTZ getDatum() {
        return (TIMESTAMPLTZ)super.getDatum();
    }

    public String toString() {
        try {
            OraTIMESTAMPLTZFormat formatter = new OraTIMESTAMPLTZFormat(new OracleNLSProvider(null).getTimeStampWithTimeZoneFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US), this.getDBTimeZone(), this.getSessionTimeZone());
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static final class OraTIMESTAMPLTZImpl
    extends OraResolvableDatum.OraResolvableDatumImpl
    implements OraTimestampDatum.OraTimestampDatumImpl {
        private transient ZoneId dbZone;

        protected OraTIMESTAMPLTZImpl(LocalDateTime datetime, OraResolvableDatum.Realization realization, ZoneId dbZone) {
            super(datetime, realization);
            this.dbZone = dbZone;
        }

        protected OraTIMESTAMPLTZImpl(Instant instant, OraResolvableDatum.Realization realization, ZoneId dbZone) {
            super(instant, realization);
            this.dbZone = dbZone;
        }

        private OraTIMESTAMPLTZImpl(TIMESTAMPLTZ datetime, OraResolvableDatum.Realization realization, ZoneId dbZone) {
            this(OraTIMESTAMPLTZImpl.unpackTIMESTAMPLTZ(datetime.shareBytes(), dbZone).toInstant(), realization, dbZone);
        }

        protected OraTIMESTAMPLTZImpl(Instant instant) {
            this(instant, OraResolvableDatum.Realization.INSTANT, null);
        }

        protected OraTIMESTAMPLTZImpl(LocalDateTime datetime) {
            this(datetime, OraResolvableDatum.Realization.LOCAL_INSTANT, null);
        }

        public ZoneId getDBZone() {
            return this.dbZone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OraTemporalDatum.Change setFractionalPrecision(int precision) {
            OraResolvableDatum.Realization oldRealization = this.getRealization();
            try {
                OraTemporalDatum.Change change = super.setFractionalPrecision(precision);
                return change;
            }
            finally {
                this.setRealization(oldRealization);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OraTemporalDatum.Change setPrecision(OraTemporalDatum.Precision precision) {
            OraResolvableDatum.Realization oldRealization = this.getRealization();
            try {
                OraTemporalDatum.Change change = super.setPrecision(precision);
                return change;
            }
            finally {
                this.setRealization(oldRealization);
            }
        }

        @Override
        public OraTemporalDatum.Change setZonedDateTime(ZonedDateTime newZDT) {
            OraTemporalDatum.Change change = super.setZonedDateTime(newZDT);
            if (this.getRealization() == OraResolvableDatum.Realization.LTZ_INSTANT && change != OraTemporalDatum.Change.NONE && change != OraTemporalDatum.Change.ZONE) {
                this.setRealization(OraResolvableDatum.Realization.INSTANT);
            }
            return change;
        }

        public OraTemporalDatum.Change setDBZone(ZoneId dbZone) {
            OraTemporalDatum.Change change = OraTemporalDatum.Change.NONE;
            if (dbZone != null && this.getRealization() == OraResolvableDatum.Realization.LTZ_INSTANT) {
                ZonedDateTime newZDT = this.getZonedDateTime();
                ZoneId savedZI = newZDT.getZone();
                newZDT.withZoneSameInstant(OraTemporalDatum.UTC_ID);
                newZDT.withZoneSameLocal(dbZone);
                newZDT.withZoneSameInstant(savedZI);
                change = this.setZonedDateTime(newZDT);
                this.setRealization(OraResolvableDatum.Realization.INSTANT);
            }
            this.dbZone = dbZone;
            return change;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OraTemporalDatum.Change replicate(OraTemporalDatum.OraTemporalDatumImpl src) {
            OraTemporalDatum.Change change = OraTemporalDatum.Change.NONE;
            OraResolvableDatum.Realization candidate = this.getRealization();
            try {
                change = super.replicate(src);
                if (src instanceof OraTIMESTAMPLTZImpl) {
                    OraTIMESTAMPLTZImpl other = (OraTIMESTAMPLTZImpl)src;
                    candidate = other.getRealization();
                    this.dbZone = other.dbZone;
                } else if (this.getRealization() == OraResolvableDatum.Realization.LOCAL_INSTANT) {
                    candidate = OraResolvableDatum.Realization.INSTANT;
                }
            }
            finally {
                this.setRealization(candidate);
            }
            return change;
        }

        @Override
        public Object clone() {
            OraTIMESTAMPLTZImpl other = (OraTIMESTAMPLTZImpl)super.clone();
            other.dbZone = this.dbZone;
            return other;
        }

        public TIMESTAMPLTZ getDatum() {
            byte[] bytes = new byte[11];
            this.packDatumBytes(bytes);
            return new TIMESTAMPLTZ(bytes);
        }

        @Override
        protected void packDatumBytes(byte[] bytes, int fractionalPrecision) {
            ZoneId zone = this.getDBZone() != null ? this.getDBZone() : OraTemporalDatum.UTC_ID;
            this.packDatumBytes(bytes, this.toInstant(), fractionalPrecision, zone);
        }

        static ZonedDateTime unpackTIMESTAMPLTZ(byte[] bytes, ZoneId dbZone) {
            if (dbZone == null) {
                dbZone = OraTemporalDatum.UTC_ID;
            }
            return OraTIMESTAMPLTZImpl.unpackTemporalDatum(bytes, dbZone);
        }
    }
}

