/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.objects;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dbtools.raptor.datatypes.objects.OraResolvableDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTemporalDatum;
import oracle.dbtools.raptor.datatypes.objects.OraTimestampDatum;
import oracle.dbtools.raptor.nls.FormatType;
import oracle.dbtools.raptor.nls.OraDATEFormat;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.i18n.util.OraLocaleInfo;
import oracle.sql.DATE;

public class OraDATE
extends OraResolvableDatum {
    public static OraDATE getInstance() {
        return OraDATE.getInstance(LocalDateTime.now());
    }

    public static OraDATE getLocalInstance() {
        return OraDATE.getInstance(Instant.now(), OraResolvableDatum.Realization.LOCAL_INSTANT);
    }

    public static OraDATE getInstance(Calendar calendar) {
        return calendar != null ? new OraDATE(new OraDATEImpl(calendar.toInstant())) : null;
    }

    public static OraDATE getLocalInstance(DATE datetime) {
        return datetime != null ? new OraDATE(new OraDATEImpl(datetime, OraResolvableDatum.Realization.LOCAL_INSTANT)) : null;
    }

    public static OraDATE getLocalInstance(LocalDateTime datetime) {
        return datetime != null ? new OraDATE(new OraDATEImpl(datetime, OraResolvableDatum.Realization.LOCAL_INSTANT)) : null;
    }

    public static OraDATE getLocalInstance(Instant instant) {
        return OraDATE.getInstance(instant, OraResolvableDatum.Realization.LOCAL);
    }

    public static OraDATE getInstance(DATE datetime) {
        return datetime != null ? new OraDATE(new OraDATEImpl(datetime)) : null;
    }

    public static OraDATE getInstance(LocalDateTime datetime) {
        return datetime != null ? new OraDATE(new OraDATEImpl(datetime)) : null;
    }

    public static OraDATE getInstance(Date datetime) {
        return datetime != null ? OraDATE.getInstance(datetime.toInstant()) : null;
    }

    public static OraDATE getInstance(Instant instant) {
        return instant != null ? new OraDATE(new OraDATEImpl(instant)) : null;
    }

    protected static OraDATE getInstance(Instant instant, OraResolvableDatum.Realization realization) {
        return instant != null ? new OraDATE(new OraDATEImpl(instant, realization)) : null;
    }

    public static OraDATE getInstance(OraTemporalDatum temporalDatum) {
        OraDATE d;
        if (temporalDatum != null) {
            d = OraDATE.getInstance();
            d.replicate(temporalDatum);
        } else {
            d = null;
        }
        return d;
    }

    protected OraDATE(OraDATEImpl impl) {
        super(impl);
    }

    @Override
    protected OraDATEImpl getImpl() {
        return (OraDATEImpl)super.getImpl();
    }

    @Override
    public OraDATE setSessionTimeZone(TimeZone sessionTimeZone) {
        super.setSessionTimeZone(sessionTimeZone);
        return this;
    }

    @Override
    public OraDATE setSessionZone(ZoneId zone) {
        super.setSessionZone(zone);
        return this;
    }

    public DATE getDatum() {
        return (DATE)super.getDatum();
    }

    public String toString() {
        try {
            OraDATEFormat formatter = new OraDATEFormat(new OracleNLSProvider(null).getDateFormat(FormatType.GENERIC), OraLocaleInfo.getInstance((Locale)Locale.US));
            return formatter.format(this.getDatum());
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    protected static final class OraDATEImpl
    extends OraResolvableDatum.OraResolvableDatumImpl
    implements OraTimestampDatum.OraTimestampDatumImpl {
        protected OraDATEImpl(LocalDateTime datetime, OraResolvableDatum.Realization realization) {
            super(datetime, realization);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(Instant instant, OraResolvableDatum.Realization realization) {
            super(instant, realization);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(Instant instant) {
            this(instant, OraResolvableDatum.Realization.INSTANT);
            this.setFractionalPrecision(0);
        }

        protected OraDATEImpl(LocalDateTime datetime) {
            this(datetime, OraResolvableDatum.Realization.LOCAL);
        }

        private OraDATEImpl(DATE datetime, OraResolvableDatum.Realization realization) {
            this(OraDATEImpl.unpackTemporalDatum(datetime.shareBytes()).toInstant(), realization);
        }

        private OraDATEImpl(DATE datetime) {
            this(datetime, OraResolvableDatum.Realization.LOCAL);
        }

        @Override
        public boolean nanosSupported() {
            return false;
        }

        public DATE getDatum() {
            byte[] bytes = new byte[7];
            this.packDatumBytes(bytes);
            return new DATE(bytes);
        }
    }
}

