/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plsql;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.plsql.Parameter;

public class Member {
    public String name;
    public String code;
    public Map<Integer, Parameter> parameters = new TreeMap<Integer, Parameter>();
    public String comment;

    public Member(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public void addParam(int charPos, Parameter prm) {
        this.parameters.put(charPos, prm);
    }

    public void setComment(String comment) {
        String tag;
        if (this.parameters != null) {
            for (int charPos : this.parameters.keySet()) {
                Parameter prm = this.parameters.get(charPos);
                String tag2 = "@param " + prm.name;
                int start = comment.indexOf(tag2);
                if (0 >= start) continue;
                prm.comment = comment.substring(start + tag2.length(), comment.indexOf("\n", start));
            }
        }
        comment = comment.replace("/**", "");
        int start = (comment = comment.replace("/*", "")).indexOf(tag = "@param");
        if (0 < start) {
            comment = comment.substring(0, start);
        }
        this.comment = comment = comment.replace("*/", "");
    }

    public String toString() {
        String ret = "name=" + this.name + ", comment=" + this.comment;
        if (this.parameters != null) {
            ret = ret + "\n";
            for (int charPos : this.parameters.keySet()) {
                ret = ret + "charPos=" + charPos + ",parameter={" + this.parameters.get(charPos).toString() + "}\n";
            }
        }
        return ret;
    }
}

