/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp.commands.sql;

import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.LanguageServer;
import oracle.dbtools.lsp.commands.CodeLens;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.json.ResponseError;
import oracle.dbtools.parser.json.Util;

public class CloseConnection
extends CodeLens {
    public CloseConnection(ParseNode node, BackgroundParser parser) {
        super(node, "Close Connection", parser);
    }

    @Override
    public Object executeCommand() {
        LanguageServer server = this.parser.languageServer;
        String cmd = this.parser.text.substring(this.parser.src.get((int)this.node.from).begin, this.parser.src.get((int)(this.node.to - 1)).end);
        try {
            String connstr = OracleDictionary.parseConnectCommand(cmd);
            server.closeConnection(connstr);
            server.documentsBump();
            LSP.windowShowMessage("Closed connection to " + OracleDictionary.conn2dirName(connstr), 3);
            return "OK";
        }
        catch (Throwable e) {
            return new ResponseError(-32603, Util.sugarcoatText((String)e.getMessage()), (Object)cmd);
        }
    }
}

