/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.lsp;

import java.sql.Connection;
import oracle.dbtools.lsp.BackgroundParser;
import oracle.dbtools.lsp.LSP;
import oracle.dbtools.lsp.dictionary.OracleDictionary;
import oracle.dbtools.lsp.features.Diagnostics;
import oracle.dbtools.parser.json.Jsonable;

public class PublishDiagnosticsParams
implements Jsonable {
    BackgroundParser parser;
    Diagnostics[] diagnostics;

    public PublishDiagnosticsParams(BackgroundParser parser, Diagnostics diagnostic) {
        this.parser = parser;
        this.diagnostics = new Diagnostics[]{diagnostic};
    }

    public PublishDiagnosticsParams(BackgroundParser parser, Diagnostics[] diagnostics) {
        this.parser = parser;
        this.diagnostics = diagnostics;
    }

    public String toJson() {
        StringBuilder ret = new StringBuilder("{  \"uri\": " + this.parser.escapedUrl() + ", \"diagnostics\": [");
        String fullConnSt = this.parser.associatedFullConnStr();
        int pos = 0;
        if (!this.parser.docUrl.contains("git:") && !this.parser.docUrl.contains("gitlens:")) {
            if (fullConnSt == null) {
                for (String c : this.parser.getLanguageServer().establishedConnections.keySet()) {
                    Object conn = this.parser.getLanguageServer().establishedConnections.get(c);
                    if (conn == null || !(conn instanceof Connection)) continue;
                    if (0 < pos++) {
                        ret.append(',');
                    }
                    String data = "`ASSOCIATE_CONNECTION` `" + c + "`";
                    ret.append(new Diagnostics(LSP.oneRange, "Associate " + OracleDictionary.conn2dirName(c), 3, data).toJson());
                }
            } else {
                String data = "`DISSOCIATE_CONNECTION` `" + this.parser.getRegistry().fullConnString() + "`";
                ret.append(new Diagnostics(LSP.oneRange, "Dissociate " + this.parser.getRegistry().abbreviatedConnString(), 4, data).toJson());
                ++pos;
            }
        }
        for (Diagnostics entry : this.diagnostics) {
            if (0 < pos++) {
                ret.append(',');
            }
            ret.append(entry.toJson());
        }
        ret.append("]}");
        return ret.toString();
    }
}

