/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension;

import java.util.Iterator;
import java.util.ServiceLoader;
import oracle.dbtools.extension.MultiCommandSQLCLService;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;

public class SQLCLServices {
    private static SQLCLServices service;
    private final ServiceLoader<SQLCLService> loader = ServiceLoader.load(SQLCLService.class);
    private final ServiceLoader<MultiCommandSQLCLService> multiloaders = ServiceLoader.load(MultiCommandSQLCLService.class);

    public static synchronized SQLCLServices getInstance() {
        if (service == null) {
            service = new SQLCLServices();
        }
        return service;
    }

    public void registerServices() {
        for (SQLCLService s : this.loader) {
            CommandRegistry.addForAllStmtsListener(s.getCommandListener());
        }
        for (MultiCommandSQLCLService mcs : this.multiloaders) {
            Iterator<Class<? extends CommandListener>> it = mcs.getCommandListeners().iterator();
            while (it.hasNext()) {
                CommandRegistry.addForAllStmtsListener(it.next());
            }
        }
    }

    public Iterator<SQLCLService> getIterator() {
        Iterator<SQLCLService> services = this.loader.iterator();
        return services;
    }

    public Iterator<MultiCommandSQLCLService> getMultiIterator() {
        Iterator<MultiCommandSQLCLService> services = this.multiloaders.iterator();
        return services;
    }
}

