/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class ConnectionDetails {
    private String _identifier = null;
    private String _type = null;
    private String _url = null;
    private String _driver = null;
    private Connection _conn = null;
    private Properties _properties = new Properties();
    private String lastError = null;
    private static final Map<String, String> _typeDriverMap = new HashMap<String, String>();

    public ConnectionDetails(String url) {
        this("\"" + url + "\"", url);
    }

    public ConnectionDetails(String identifier, String url) {
        this.setIdentifier(identifier);
        this.setUrl(url);
        for (String type : _typeDriverMap.keySet()) {
            if (!this.getUrl().startsWith(type)) continue;
            this.setType(type);
            this.setDriver(_typeDriverMap.get(type));
            break;
        }
    }

    public ConnectionDetails(ConnectionDetails orig) {
        this.setIdentifier(orig._identifier);
        this.setUrl(orig._url);
        this.setType(orig._type);
        this.setDriver(this._driver);
        for (String key : orig._properties.stringPropertyNames()) {
            this._properties.setProperty(key, orig._properties.getProperty(key));
        }
    }

    private static void registerDriver(String type, String driver) {
        _typeDriverMap.put(type, driver);
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        this._type = type;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public void setIdentifier(String name) {
        this._identifier = name;
    }

    public String getUrl() {
        return this._url;
    }

    public void setUrl(String url) {
        if (url.startsWith("[")) {
            url = this.processURL(url);
        }
        this._url = url = this.resolveHashAmpersand(url);
    }

    private String processURL(String url) {
        int endIndex = url.indexOf("]");
        String argStr = url.substring(1, endIndex);
        this.processArgs(argStr);
        url = url.substring(endIndex + 1);
        return url;
    }

    private void processArgs(String argStr) {
        String[] args;
        for (String arg : args = argStr.split(",")) {
            String[] argItems = arg.split("=");
            if (argItems.length <= 1) continue;
            this._properties.put(argItems[0], argItems[1]);
        }
    }

    private String resolveHashAmpersand(String url) {
        return url.replace('#', '&');
    }

    public String getDriver() {
        return this._driver;
    }

    public void setDriver(String driver) {
        this._driver = driver;
    }

    public Connection getConn() {
        return this.getConn(true);
    }

    public Connection getConn(boolean force) {
        if (this._conn == null && force) {
            try {
                Driver driver = Class.forName(this.getDriver()).asSubclass(Driver.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                DriverManager.registerDriver(driver);
                this._conn = this._properties.size() == 2 && this._properties.containsKey("USERNAME") && this._properties.containsKey("PASSWORD") ? DriverManager.getConnection(this.getUrl(), this._properties.getProperty("USERNAME"), this._properties.getProperty("PASSWORD")) : (this._properties.size() > 0 ? DriverManager.getConnection(this.getUrl(), this._properties) : DriverManager.getConnection(this.getUrl()));
            }
            catch (Exception e) {
                this.lastError = e.getLocalizedMessage();
            }
        }
        return this._conn;
    }

    public void setConn(Connection conn) {
        this._conn = conn;
    }

    public String getLastError() {
        return this.lastError;
    }

    static {
        ConnectionDetails.registerDriver("jdbc:jtds:sqlserver", "net.sourceforge.jtds.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:jtds:sybase", "net.sourceforge.jtds.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:as400:", "com.ibm.db2.jcc.DB2Driver");
        ConnectionDetails.registerDriver("jdbc:db2:", "com.ibm.db2.jcc.DB2Driver");
        ConnectionDetails.registerDriver("jdbc:informix", "com.ibm.informix.Driver");
        ConnectionDetails.registerDriver("jdbc:mysql:", "com.mysql.cj.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:postgresql:", "org.postgresql.Driver");
        ConnectionDetails.registerDriver("jdbc:teradata:", "com.teradata.jdbc.TeraDriver");
        ConnectionDetails.registerDriver("jdbc:oracle:thin:", "oracle.jdbc.OracleDriver");
        ConnectionDetails.registerDriver("jdbc:oracle:oci:", "oracle.jdbc.OracleDriver");
        ConnectionDetails.registerDriver("jdbc:oracle:oci8:", "oracle.jdbc.OracleDriver");
        ConnectionDetails.registerDriver("jdbc:redshift:", "com.amazon.redshift.jdbc.Driver");
        ConnectionDetails.registerDriver("jdbc:oracle:orest:", "oracle.dbtools.jdbc.orest.Driver");
        ConnectionDetails.registerDriver("jdbc:oracle:rest:", "oracle.dbtools.jdbc.Driver");
        ConnectionDetails.registerDriver("http:", "oracle.dbtools.jdbc.orest.Driver");
        ConnectionDetails.registerDriver("https:", "oracle.dbtools.jdbc.orest.Driver");
        ConnectionDetails.registerDriver("jdbc:oracle:orest", "oracle.dbtools.jdbc.orest.Driver");
        ConnectionDetails.registerDriver("jdbc:oracle:rest", "oracle.dbtools.jdbc.Driver");
    }
}

