/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.db.ConnectionDetails;
import oracle.dbtools.db.DefaultConnectionResolver;

public class AdvancedConnectionResolver
extends DefaultConnectionResolver {
    private static Map<String, String> typeMap = new HashMap<String, String>();
    private ArrayList<ConnectionDetails> _loadedConnections = new ArrayList();

    protected ArrayList<ConnectionDetails> getConnections() {
        return this._loadedConnections;
    }

    @Override
    public String getConnectionTypeImpl(Connection conn) {
        String connType = null;
        for (ConnectionDetails connDetails : this._loadedConnections) {
            if (connDetails.getConn() != conn) continue;
            String detailsType = connDetails.getType();
            if (detailsType == null) break;
            connType = typeMap.get(detailsType);
            break;
        }
        return connType != null ? connType : "Generic";
    }

    @Override
    public Connection getConnectionImpl(String name, boolean force) throws Exception {
        if (name.startsWith("\"")) {
            return this.getConnectionFromURL(this.strip(name, '\"'));
        }
        return super.getConnectionImpl(name, force);
    }

    private Connection getConnectionFromURL(String url) {
        Connection conn = null;
        ConnectionDetails currentConnDetails = new ConnectionDetails(url);
        for (ConnectionDetails connectionDetails : this._loadedConnections) {
            if (!currentConnDetails.getUrl().equals(connectionDetails.getUrl())) continue;
            conn = connectionDetails.getConn();
            break;
        }
        if (conn == null) {
            this._loadedConnections.add(currentConnDetails);
            conn = currentConnDetails.getConn();
        }
        return conn;
    }

    static {
        typeMap.put("jdbc:oracle:thin:", "Oracle");
        typeMap.put("jdbc:oracle:oci:", "Oracle");
        typeMap.put("jdbc:oracle:oci8:", "Oracle");
        typeMap.put("jdbc:oracle:orest:", "Oracle");
        typeMap.put("jdbc:oracle:orest", "Oracle");
        typeMap.put("http:", "Oracle");
        typeMap.put("https:", "Oracle");
    }
}

