/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.common.utils.TriState;
import oracle.dbtools.db.ConnectionIdentifier;
import oracle.dbtools.db.DBUtil;

public final class AccessCache {
    private static final Map<ConnectionIdentifier.Key, AccessCache> caches = new HashMap<ConnectionIdentifier.Key, AccessCache>();
    private Map<String, Boolean> m_accessCache = new HashMap<String, Boolean>();
    private final ConnectionIdentifier conn;

    private static synchronized AccessCache getAccessCache(ConnectionIdentifier id) {
        AccessCache instance = caches.get(id.getIdentifierKey());
        if (instance == null) {
            instance = new AccessCache(id);
            caches.put(id.getIdentifierKey(), instance);
        }
        return instance;
    }

    public static TriState hasAccessCached(ConnectionIdentifier id, String s) {
        return AccessCache.getAccessCache(id).hasAccessCached(s);
    }

    public static boolean hasAccess(ConnectionIdentifier id, String s) {
        return AccessCache.getAccessCache(id).hasAccess(s);
    }

    public static boolean checkAccess(ConnectionIdentifier id, String s) {
        return AccessCache.getAccessCache(id).checkAccess(s);
    }

    private AccessCache(ConnectionIdentifier conn) {
        this.conn = conn;
    }

    private TriState hasAccessCached(String s) {
        String key = s.toLowerCase();
        if (this.m_accessCache.containsKey(key)) {
            if (this.m_accessCache.get(key) == Boolean.TRUE) {
                return TriState.TRUE;
            }
            return TriState.FALSE;
        }
        return TriState.UNDEF;
    }

    private final boolean hasAccess(String s) {
        String key = s.toLowerCase();
        if (this.m_accessCache.containsKey(key)) {
            return this.m_accessCache.get(key);
        }
        boolean hasAccess = false;
        if (this.conn != null) {
            hasAccess = this.checkAccess(key);
            this.m_accessCache.put(key, hasAccess);
        }
        return hasAccess;
    }

    private boolean checkAccess(String s) {
        return DBUtil.getInstance(this.conn).checkAccess(s);
    }
}

