/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.data.loadservice;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.dbtools.data.loadservice.ColumnMetadata;
import oracle.dbtools.data.loadservice.LoadServicesRegistry;

public class LoadParmsAPI {
    public static final int DEFAULT_ERRORS = 50;
    public static final String DEFAULT_ENCODING = "UTF8";
    public static final int UNLIMITED = -1;
    public static int DEFAULT_BATCH_ROWS = 50;
    public static int DEFAULT_BATCHES_PER_COMMIT = 10;
    public static final String LOAD_TIMESTAMP_TZ_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZH:TZM";
    public static final String LOAD_TIMESTAMP_TZR_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF TZR";
    public static final String LOAD_TIMESTAMP_FORMAT = "YYYY-MM-DD HH24:MI:SS.FF";
    public static final String LOAD_DATE_FORMAT = "YYYY-MM-DD";
    public static final int DEFAULT_SCAN_ROWS = 100;
    private SERVICE_METHOD _serviceMethod;
    private CLEAN_NAMES _cleanNames;
    private DELETE_ROWS _deleteRows;
    private boolean _isUnknownColumnsFail;
    private Map<String, String> _aliasToColumnMap;
    private Map<String, ColumnMetadata> _columnMetadataMap;
    private List<String> _selectedColumns;
    private int _errors;
    private int _errorsMax;
    private int _batchRows;
    private int _batchMax;
    private int _batchesPerCommit;
    private int _importRowLimit;
    private boolean _isDoCommit;
    private RESPONSE_FORMAT _responseFormat;
    private Iterable<Locale> _responseLocales;
    private String _responseEncoding;
    private Locale _locale;
    private String _dateFormat;
    private String _timestampFormat;
    private String _timestampTZFormat;
    private int _scanRows;
    private DDL_OPTION _ddlOption;
    private DDL_COL_SIZE _ddlColSize;
    private PROCESS _process;
    private String[] _dateFormats;
    private String[] _timestampFormats;
    private String[] _timestampTZFormats;

    public LoadParmsAPI(Builder builder) {
        this._serviceMethod = builder._serviceMethod;
        if (!LoadServicesRegistry.isServiceRegistered(this._serviceMethod.toString())) {
            throw new IllegalArgumentException();
        }
        this._cleanNames = builder._cleanNames;
        this._deleteRows = builder._deleteRows;
        this._isUnknownColumnsFail = builder._isUnknownColumnsFail;
        this._aliasToColumnMap = builder._aliasToColumnMap;
        this._columnMetadataMap = builder._columnMetadataMap;
        this._selectedColumns = builder._selectedColumns;
        this._errors = builder._errors;
        this._errorsMax = builder._errorsMax;
        this._batchRows = builder._batchMax > 0 && builder._batchRows > builder._batchMax ? builder._batchMax : builder._batchRows;
        this._batchesPerCommit = builder._batchesPerCommit;
        this._importRowLimit = builder._importRowLimit;
        this._isDoCommit = builder._isDoCommit;
        this._responseFormat = builder._responseFormat;
        this._responseEncoding = builder._responseEncoding;
        this._responseLocales = builder._responseLocales;
        this._locale = builder._locale;
        this._dateFormat = this.notNull(builder._dateFormat);
        this._timestampFormat = this.notNull(builder._timestampFormat);
        this._timestampTZFormat = this.notNull(builder._timestampTZFormat);
        this._scanRows = builder._scanRows;
        this._ddlOption = builder._ddlOption;
        this._ddlColSize = builder._ddlColSize;
        this._process = builder._process;
        this._dateFormats = builder._dateFormats;
        this._timestampFormats = builder._timestampFormats;
        this._timestampTZFormats = builder._timestampTZFormats;
        this.validateParm(PARMS.SERVICE_METHOD, (Object)this._serviceMethod);
    }

    private void validateParm(Enum<PARMS> parm, Object parmValue) {
        if (parmValue == null || parmValue instanceof String && ((String)parmValue).length() == 0) {
            throw new IllegalStateException(parm.toString());
        }
    }

    private String notNull(String string) {
        return string != null ? string : "";
    }

    public SERVICE_METHOD getMethod() {
        return this._serviceMethod;
    }

    public CLEAN_NAMES getCleanNames() {
        return this._cleanNames;
    }

    public DELETE_ROWS getDeleteRows() {
        return this._deleteRows;
    }

    public boolean isUnknownColumnsFail() {
        return this._isUnknownColumnsFail;
    }

    public Map<String, String> getAliasToColumnMap() {
        return this._aliasToColumnMap;
    }

    public Map<String, ColumnMetadata> getColumnMetadataMap() {
        return this._columnMetadataMap;
    }

    public List<String> getSelectedColumns() {
        return this._selectedColumns;
    }

    public int getErrors() {
        return this._errors;
    }

    public int getErrorsMax() {
        return this._errorsMax;
    }

    public boolean isErrorsLimited() {
        return this._errors >= 0 || this._errorsMax >= 0;
    }

    public int getErrorsLimit() {
        return this._errors != -1 && this._errors < this._errorsMax || this._errorsMax == -1 ? this._errors : this._errorsMax;
    }

    public final int getBatchRows() {
        return this._batchRows;
    }

    public int getBatchesPerCommit() {
        return this._batchesPerCommit;
    }

    public int getImportRowLimit() {
        return this._importRowLimit;
    }

    public boolean isDoCommit() {
        return this._isDoCommit;
    }

    public RESPONSE_FORMAT getResponseFormat() {
        return this._responseFormat;
    }

    public boolean isResponseFormatRaw() {
        return this._responseFormat == RESPONSE_FORMAT.RESPONSE_RAW;
    }

    public boolean isResponseFormatSql() {
        return this._responseFormat == RESPONSE_FORMAT.RESPONSE_SQL;
    }

    public String getResponseEncoding() {
        return this._responseEncoding;
    }

    public Iterable<Locale> getResponseLocales() {
        return this._responseLocales;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public String getDataFormat() {
        return this._dateFormat;
    }

    public String getTimestampFormat() {
        return this._timestampFormat;
    }

    public String getTimestampTZFormat() {
        return this._timestampTZFormat;
    }

    public String[] getDateFormats() {
        return this._dateFormats;
    }

    public String[] getTimestampFormats() {
        return this._timestampFormats;
    }

    public String[] getTimestampTZFormats() {
        return this._timestampTZFormats;
    }

    public int getScanRows() {
        return this._scanRows;
    }

    public DDL_OPTION getDdlOption() {
        return this._ddlOption;
    }

    public DDL_COL_SIZE getDdlColSize() {
        return this._ddlColSize;
    }

    public PROCESS getProcess() {
        return this._process;
    }

    public static class Builder {
        private SERVICE_METHOD _serviceMethod;
        private boolean _isUnknownColumnsFail = true;
        private Map<String, String> _aliasToColumnMap;
        private Map<String, ColumnMetadata> _columnMetadataMap;
        private List<String> _selectedColumns;
        private CLEAN_NAMES _cleanNames = CLEAN_NAMES.UNIQUE;
        private DELETE_ROWS _deleteRows = DELETE_ROWS.FALSE;
        private int _errors = 50;
        private int _errorsMax = -1;
        private int _batchRows = DEFAULT_BATCH_ROWS;
        private int _batchMax = -1;
        private int _batchesPerCommit = DEFAULT_BATCHES_PER_COMMIT;
        private int _importRowLimit;
        private boolean _isDoCommit = true;
        private RESPONSE_FORMAT _responseFormat = RESPONSE_FORMAT.RESPONSE_RAW;
        private String _responseEncoding = "UTF8";
        private Iterable<Locale> _responseLocales;
        private Locale _locale;
        private String _dateFormat = "";
        private String _timestampFormat = "";
        private String _timestampTZFormat = "";
        private int _scanRows = 100;
        private DDL_COL_SIZE _ddlColSize = DDL_COL_SIZE.ROUNDED;
        private DDL_OPTION _ddlOption = DDL_OPTION.NONE;
        private PROCESS _process = PROCESS.LOAD;
        private String[] _dateFormats;
        private String[] _timestampFormats;
        private String[] _timestampTZFormats;

        public Builder(SERVICE_METHOD serviceMethod) {
            this._serviceMethod = serviceMethod;
        }

        public Builder cleanNames(CLEAN_NAMES cleanNames) {
            this._cleanNames = cleanNames;
            return this;
        }

        public Builder deleteRows(DELETE_ROWS deleteRows) {
            this._deleteRows = deleteRows;
            return this;
        }

        public Builder unknownColumnsFail(boolean isUnknownColumnsFail) {
            this._isUnknownColumnsFail = isUnknownColumnsFail;
            return this;
        }

        public Builder mapColumnNames(Map<String, String> aliasToColumnMap) {
            this._aliasToColumnMap = aliasToColumnMap;
            return this;
        }

        public Builder columnMetadataMap(Map<String, ColumnMetadata> columnMetadataMap) {
            this._columnMetadataMap = columnMetadataMap;
            return this;
        }

        public Builder selectedColumns(List<String> selectedColumns) {
            this._selectedColumns = selectedColumns;
            return this;
        }

        public Builder errors(int errors) {
            this._errors = errors;
            return this;
        }

        public Builder errorsMax(int errorsMax) {
            this._errorsMax = errorsMax;
            return this;
        }

        public Builder batchRows(int batchRows) {
            this._batchRows = batchRows;
            return this;
        }

        public Builder batchMax(int batchMax) {
            this._batchMax = batchMax;
            return this;
        }

        public Builder batchesPerCommit(int batchesPerCommit) {
            this._batchesPerCommit = batchesPerCommit;
            return this;
        }

        public Builder importRowLimit(int importRowLimit) {
            this._importRowLimit = importRowLimit;
            return this;
        }

        public Builder doCommit(boolean isDoCommit) {
            this._isDoCommit = isDoCommit;
            return this;
        }

        public Builder responseFormat(RESPONSE_FORMAT responseFormat) {
            this._responseFormat = responseFormat;
            return this;
        }

        public Builder responseEncoding(String responseEncoding) {
            this._responseEncoding = responseEncoding;
            return this;
        }

        public Builder responseLocales(Iterable<Locale> responseLocales) {
            this._responseLocales = responseLocales;
            return this;
        }

        public Builder locale(Locale locale) {
            this._locale = locale;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this._dateFormat = dateFormat;
            return this;
        }

        public Builder timestampFormat(String timestampFormat) {
            this._timestampFormat = timestampFormat;
            return this;
        }

        public Builder timestampTZFormat(String timestampTZFormat) {
            this._timestampTZFormat = timestampTZFormat;
            return this;
        }

        public Builder dateFormats(String[] dateFormats) {
            this._dateFormats = dateFormats;
            return this;
        }

        public Builder timestampFormats(String[] timestampFormats) {
            this._timestampFormats = timestampFormats;
            return this;
        }

        public Builder timestampTZFormats(String[] timestampTZFormats) {
            this._timestampTZFormats = timestampTZFormats;
            return this;
        }

        public Builder scanRows(int scanRows) {
            this._scanRows = scanRows;
            return this;
        }

        public Builder ddlOption(DDL_OPTION ddlOption) {
            this._ddlOption = ddlOption;
            return this;
        }

        public Builder ddlColSize(DDL_COL_SIZE ddlColSize) {
            this._ddlColSize = ddlColSize;
            return this;
        }

        public Builder process(PROCESS process) {
            this._process = process;
            return this;
        }

        public LoadParmsAPI build() {
            return new LoadParmsAPI(this);
        }
    }

    public static enum SERVICE_METHOD {
        JDBC_BATCH;

    }

    public static enum CLEAN_NAMES {
        OFF,
        TRANSFORM,
        TRANSFORM30,
        TRANSFORM128,
        QUOTE,
        QUOTE30,
        QUOTE128,
        UNIQUE;

    }

    public static enum DELETE_ROWS {
        FALSE,
        TRUE,
        TRUNCATE;

    }

    public static enum RESPONSE_FORMAT {
        RESPONSE_RAW,
        RESPONSE_SQL;

    }

    public static enum DDL_OPTION {
        NONE,
        SHOW,
        CREATE;

    }

    public static enum DDL_COL_SIZE {
        ACTUAL,
        ROUNDED,
        MAX;

    }

    public static enum PROCESS {
        LOAD,
        DDL_ONLY,
        PREVIEW;

    }

    private static enum PARMS {
        SERVICE_METHOD,
        CLEAN_NAMES,
        DELETE_ROWS,
        UNKNOWN_COLUMNS_FAIL,
        MAP_COLUMN_NAMES,
        ERRORS,
        ERRORS_MAX,
        BATCH_ROWS,
        BATCH_MAX,
        BATCHES_PER_COMMIT,
        IMPORT_ROW_LIMIT,
        DO_COMMIT,
        RESPONSE_FORMAT,
        RESPONSE_ENCODING,
        RESPONSE_LOCALES,
        LOCALE,
        DATE_FORMAT,
        TIMESTAMP_FORMAT,
        TIMESTAMPTZ_FORMAT,
        DATE_FORMATS,
        TIMESTAMP_FORMATS,
        SCAN_ROWS,
        PROCESS,
        DDL_OPTION,
        DDL_COL_SIZE;

    }
}

