/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import oracle.dbtools.common.utils.ModelUtil;
import oracle.dbtools.connections.impl.Connection;

public class ConnectionsList {
    public List<Connection> connections = new ArrayList<Connection>();

    public List<Connection> getConnections() {
        return new ArrayList<Connection>(this.connections);
    }

    public void setConnections(List<Connection> connections) {
        this.connections = new ArrayList<Connection>(connections);
    }

    public List<Connection> getConnections(String type) {
        return this.connections.stream().filter(p -> ModelUtil.areEqual(p.getType(), type)).collect(Collectors.toList());
    }

    public Connection getConnection(String type, String name) {
        return this.connections.stream().filter(p -> ModelUtil.areEqual(p.getType(), type) && ModelUtil.areEqual(p.getName(), name)).findFirst().orElse(null);
    }

    public boolean removeConnection(String type, String name) {
        return this.connections.removeIf(p -> ModelUtil.areEqual(p.getType(), type) && ModelUtil.areEqual(p.getName(), name));
    }

    public void addConnection(Connection conn) {
        this.connections.add(conn);
    }
}

