/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.connections.ConnectionFactory;
import oracle.dbtools.connections.ConnectionReference;
import oracle.dbtools.connections.ConnectionReferenceable;
import oracle.dbtools.connections.NameExistsException;
import oracle.dbtools.connections.PathReferencePair;
import oracle.dbtools.connections.ReferencePair;
import oracle.dbtools.connections.StorageException;
import oracle.dbtools.connections.StorageManager;
import oracle.dbtools.connections.StringReferencePair;
import oracle.dbtools.connections.impl.Connection;
import oracle.dbtools.connections.impl.ConnectionsList;
import oracle.dbtools.util.Logger;

public class Storage<T> {
    private static final String SECURE_REF_TYPE = "SecureReference";
    private final String mType;
    private final ConnectionsList mData;
    private final Map<String, Object> mEnv;
    private final StorageManager.ChangeProcessor mChangeProcessor;

    static <T> Storage<T> createStorage(String type, StorageManager storageMgr) {
        return new Storage<T>(type, storageMgr.getStorageData(type), storageMgr.getChangeProcessor(), storageMgr.getEnv());
    }

    Storage(String type, ConnectionsList data, StorageManager.ChangeProcessor cp, Map<String, Object> env) {
        this.mType = type;
        this.mData = data;
        this.mEnv = env;
        this.mChangeProcessor = cp;
    }

    public String getType() {
        return this.mType;
    }

    public String[] listConnections() {
        List<Connection> conns = this.mData.getConnections(this.mType);
        String[] names = new String[conns.size()];
        int count = 0;
        for (Connection conn : conns) {
            String name = conn.getName();
            if (name == null) continue;
            names[count++] = name;
        }
        if (count < names.length) {
            String[] tmp = names;
            names = new String[count];
            System.arraycopy(tmp, 0, names, 0, count);
        }
        return names;
    }

    public T getConnection(String name, ConnectionFactory<T> factory) throws StorageException {
        Connection data = this.findConnectionEntry(name);
        return data != null ? (T)this.createConnection(name, factory, data.getInfo()) : null;
    }

    private T createConnection(String name, ConnectionFactory<T> factory, Map<String, Object> data) {
        T result = null;
        if (data != null) {
            try {
                ConnectionReference ref = this.convertFromJson(factory.getConnectionClass().getName(), name, data);
                result = factory.createObject(name, ref, this.mEnv);
            }
            catch (StorageException e) {
                Logger.severe(Storage.class, e);
            }
        }
        return result;
    }

    private Connection findConnectionEntry(String name) {
        return this.mData.getConnection(this.mType, name);
    }

    public void addConnection(String name, ConnectionReferenceable connectionData) throws StorageException {
        if (this.findConnectionEntry(name) != null) {
            throw new NameExistsException(name, this.mType);
        }
        this.addConnectionImpl(name, connectionData);
    }

    private void addConnectionImpl(String name, ConnectionReferenceable connectionData) throws StorageException {
        Connection conn = new Connection();
        conn.setName(name);
        conn.setType(this.mType);
        Map<String, Object> data = this.convertToJson(name, connectionData);
        conn.setInfo(data);
        this.mData.addConnection(conn);
        this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.ADD);
    }

    public boolean removeConnection(String name) throws StorageException {
        boolean removed = this.mData.removeConnection(this.mType, name);
        if (removed) {
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.REMOVE);
        }
        return removed;
    }

    public void updateConnection(String name, ConnectionReferenceable connectionData) throws StorageException {
        Connection conn = this.findConnectionEntry(name);
        if (conn == null) {
            this.addConnectionImpl(name, connectionData);
        } else {
            Map<String, Object> data = this.convertToJson(name, connectionData);
            conn.setInfo(data);
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.UPDATE);
        }
    }

    public void updateConnection(String oldName, String newName, ConnectionReferenceable connectionData) throws StorageException {
        Connection conn = this.findConnectionEntry(oldName);
        if (conn == null) {
            this.addConnectionImpl(newName, connectionData);
        } else {
            if (this.findConnectionEntry(newName) != null) {
                throw new NameExistsException(newName, this.mType);
            }
            conn.setName(newName);
            Map<String, Object> data = this.convertToJson(newName, connectionData);
            conn.setInfo(data);
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.UPDATE);
        }
    }

    public void renameConnection(String oldName, String newName) throws StorageException {
        Connection conn = this.findConnectionEntry(oldName);
        if (conn != null) {
            if (this.findConnectionEntry(newName) != null) {
                throw new NameExistsException(newName, this.mType);
            }
            conn.setName(newName);
            this.mChangeProcessor.processChange(StorageManager.ChangeProcessor.Change.UPDATE);
        }
    }

    private Map<String, Object> convertToJson(String connName, ConnectionReferenceable connection) throws StorageException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        URI pathRoot = (URI)this.mEnv.get("Location.Root");
        try {
            ConnectionReference ref = connection.getReference();
            if (ref != null) {
                for (ReferencePair rf : ref) {
                    String key = rf.getKey();
                    if (rf instanceof PathReferencePair) {
                        PathReferencePair pathRf = (PathReferencePair)rf;
                        URI path = pathRf.getValue();
                        if (path == null) continue;
                        URI relativePath = pathRoot != null ? pathRoot.relativize(path) : path;
                        data.put(key, relativePath.toString());
                        continue;
                    }
                    Object value = rf.getValue();
                    if (value == null) continue;
                    data.put(key, value.toString());
                }
            }
        }
        catch (StorageException ne) {
            Logger.severe(Storage.class, ne);
            throw new StorageException(ne);
        }
        return data;
    }

    private ConnectionReference convertFromJson(String connCls, String connName, Map<String, Object> info) {
        ConnectionReference.ReferenceBuilder builder = new ConnectionReference.ReferenceBuilder(connCls);
        info.forEach((k, v) -> {
            if (v != null) {
                builder.addValue(new StringReferencePair((String)k, v.toString()));
            } else {
                Logger.warn(Storage.class, "Unsupported JSON node type found for " + k);
            }
        });
        return builder.build();
    }
}

