/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.connections;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import oracle.dbtools.connections.Location;

final class FileLocation
implements Location {
    private final Path mFile;

    static Location createFileLocation(Path f) {
        return new FileLocation(f);
    }

    private FileLocation(Path f) {
        this.mFile = f;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!Files.exists(this.mFile, new LinkOption[0])) {
            Files.createFile(this.mFile, new FileAttribute[0]);
        }
        return Files.newInputStream(this.mFile, new OpenOption[0]);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return Files.newOutputStream(this.mFile, new OpenOption[0]);
    }

    @Override
    public URI getRelativeRoot() {
        Path parent = this.mFile != null ? this.mFile.getParent() : null;
        return parent != null ? parent.toUri() : null;
    }

    @Override
    public boolean exists() {
        return Files.exists(this.mFile, new LinkOption[0]) && Files.isRegularFile(this.mFile, new LinkOption[0]);
    }

    public String toString() {
        return this.mFile.toString();
    }
}

