/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.app.Format;
import oracle.dbtools.app.XML2Table;
import oracle.dbtools.arbori.MaterializedPredicate;
import oracle.dbtools.parser.Lexer;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Service;

public class Persist2XML
extends XML2Table {
    HashMap<String, Object> parameters = new HashMap();

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("A", "a");
        tmp.put("B", 11);
        tmp.put("C", true);
        tmp.put("D", (Object)Format.Case.InitCap);
        tmp.put("E", "C:\\temp\\format.prg");
        tmp.put("F", "/temp/format.prg");
        URL file = Paths.get("/temp", "persist.xml").toUri().toURL();
        Persist2XML.write(file, tmp);
        System.out.println(Persist2XML.read(file));
    }

    public Persist2XML() throws IOException {
        super(Service.readFile(XML2Table.class, (String)(currentDir + "persist2xml.prg")));
    }

    public static void write(URL url, Object what) throws IOException {
        FileOutputStream fos = new FileOutputStream(url.getFile());
        String xml = "<options>" + Persist2XML.dumpXML(what) + "</options>";
        fos.write(xml.getBytes());
        fos.close();
    }

    public static String dumpXML(Object what) {
        if (what instanceof Pair) {
            Pair pair = (Pair)((Object)what);
            return "<" + pair.first().toString() + ">" + pair.second().toString() + "</" + pair.first().toString() + ">\n";
        }
        if (what instanceof Map) {
            Map map = (Map)what;
            StringBuilder ret = new StringBuilder();
            for (Object key : map.keySet()) {
                Object value = map.get(key);
                if (value instanceof Enum) {
                    Class<?> enumClass = value.getClass();
                    value = enumClass.getCanonicalName() + "." + String.valueOf(value);
                }
                ret.append("<" + key.toString() + ">" + value.toString() + "</" + key.toString() + ">\n");
            }
            return ret.toString();
        }
        if (what instanceof Object) {
            StringBuilder ret = new StringBuilder();
            for (Object elem : (Collection)what) {
                ret.append(Persist2XML.dumpXML(elem));
            }
            return ret.toString();
        }
        throw new AssertionError((Object)("what instanceof " + what.getClass().getName()));
    }

    public static Map<String, Object> read(URL url) throws Exception {
        FileInputStream fis = new FileInputStream(url.getFile());
        return Persist2XML.read(fis);
    }

    public static Map<String, Object> read(FileInputStream fis) throws Exception {
        byte[] bytes = new byte[4096];
        StringBuffer tmp = new StringBuffer();
        BufferedInputStream bin = new BufferedInputStream(fis);
        int bytesRead = bin.read(bytes, 0, bytes.length);
        while (bytesRead != -1) {
            tmp.append(new String(bytes).substring(0, bytesRead));
            bytesRead = bin.read(bytes, 0, bytes.length);
        }
        Persist2XML xmlProgram = new Persist2XML();
        String input = tmp.toString();
        xmlProgram.run(input, null, (Object)xmlProgram);
        return xmlProgram.parameters;
    }

    public Map<String, MaterializedPredicate> run(String input, List<LexerToken> src, Object callback) throws Exception {
        if (src == null) {
            src = Lexer.parse((String)input);
        }
        Parsed target = new Parsed(input, src, Persist2XML.xmlParser(), (String)null);
        if (debug) {
            target.getRoot().printTree();
        }
        Map predicateVectors = this.eval(target, callback);
        return predicateVectors;
    }

    void tupleNodes(Parsed target, Map<String, ParseNode> tuple) {
    }

    void values(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("value");
        String value = target.getInput().substring(((LexerToken)target.getSrc().get((int)node.from)).begin, ((LexerToken)target.getSrc().get((int)(node.to - 1))).end);
        Object obj = value;
        if (value.equalsIgnoreCase("false")) {
            obj = false;
        }
        if (value.equalsIgnoreCase("true")) {
            obj = true;
        }
        try {
            obj = Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Object tmp = this.decodeEnum(Format.Case.class, (Object[])Format.Case.values(), value);
        if (tmp != null) {
            obj = tmp;
        }
        if ((tmp = this.decodeEnum(Format.InlineComments.class, (Object[])Format.InlineComments.values(), value)) != null) {
            obj = tmp;
        }
        if ((tmp = this.decodeEnum(Format.Breaks.class, (Object[])Format.Breaks.values(), value)) != null) {
            obj = tmp;
        }
        if ((tmp = this.decodeEnum(Format.BreaksX2.class, (Object[])Format.BreaksX2.values(), value)) != null) {
            obj = tmp;
        }
        if ((tmp = this.decodeEnum(Format.Space.class, (Object[])Format.Space.values(), value)) != null) {
            obj = tmp;
        }
        if ((tmp = this.decodeEnum(Format.FlowControl.class, (Object[])Format.FlowControl.values(), value)) != null) {
            obj = tmp;
        }
        this.parameters.put(((LexerToken)target.getSrc().get((int)tuple.get((Object)"attribute").from)).content, obj);
    }

    private Object decodeEnum(Class c, Object[] values, String cmp) {
        for (Object o : values) {
            if (!cmp.equals((c.getCanonicalName() + "." + String.valueOf(o)).toString())) continue;
            return o;
        }
        for (Object o : values) {
            if (!cmp.equals(o.toString())) continue;
            return o;
        }
        return null;
    }
}

