/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.app;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import oracle.dbtools.app.CodeScan;
import oracle.dbtools.app.Issue;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.ParseNode;
import oracle.dbtools.parser.Parsed;

public class BestPractice
extends CodeScan {
    private static BestPractice scanner = null;
    static String[] rules = new String[]{"../app/trivadis/common.arbori", "../app/trivadis/general.arbori", "../app/trivadis/variables_types.arbori", "../app/trivadis/dml_sql.arbori", "../app/trivadis/control.arbori", "../app/trivadis/exception.arbori", "../app/trivadis/dynamic.arbori", "../app/trivadis/stored.arbori", "../app/trivadis/patterns.arbori", "../app/trivadis/function.arbori"};
    TreeMap<String, Integer> firstOcurrences = new TreeMap();
    private static HashSet<String> oracleSuppledPackages = new HashSet();

    public static BestPractice getInstance() {
        if (scanner == null) {
            scanner = new BestPractice();
        }
        return scanner;
    }

    public BestPractice() {
        super(rules);
    }

    public boolean canEval(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        return false;
    }

    public boolean isTrue(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        return true;
    }

    public boolean evalNullableCondition(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String content = this.getPrefix(attributePositions, t, this.target, args);
        content = content.replaceAll("and", "&&");
        content = content.replaceAll("=", "==");
        return true;
    }

    public boolean isLegitLiteral(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String content = this.getPrefix(attributePositions, t, this.target, args);
        int len = content.length() - 1;
        for (int i = 1; i < len; ++i) {
            char code = content.charAt(i);
            if (code > '/' && code < ':' || code > '@' && code < '[' || code > '^' && code < '{' || code == ' ') continue;
            return false;
        }
        return true;
    }

    public boolean isDQuoted(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        return this.getPrefix(attributePositions, t, this.target, args).charAt(0) == '\"';
    }

    public boolean isShort(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        return this.getPrefix(attributePositions, t, this.target, args).length() < 2;
    }

    public boolean isNotNatural(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String content = this.getPrefix(attributePositions, t, this.target, args);
        return !"NATURAL".equalsIgnoreCase(content);
    }

    public boolean isNotWildcard(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        return !this.getPrefix(attributePositions, t, this.target, args).contains("%");
    }

    public boolean is20000(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String content = this.getPrefix(attributePositions, t, this.target, args);
        int code = Integer.parseInt(content);
        return 20000 <= code && code <= 20999;
    }

    public boolean isNotOut(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String nodeVar = args.get(0);
        int pos = attributePositions.get(nodeVar);
        ParseNode node = t[pos];
        String candidate = ((LexerToken)this.target.getSrc().get((int)(node.from + 1))).content;
        if ("out".equalsIgnoreCase(candidate)) {
            return false;
        }
        candidate = ((LexerToken)this.target.getSrc().get((int)(node.from + 2))).content;
        return !"out".equalsIgnoreCase(candidate);
    }

    public boolean declIdIsRowtype(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String nodeVar = args.get(0);
        int pos = attributePositions.get(nodeVar);
        ParseNode decl = t[pos].parent();
        String candidate = ((LexerToken)this.target.getSrc().get((int)(decl.to - 1))).content;
        return "ROWTYPE".equalsIgnoreCase(candidate);
    }

    public boolean startsWith(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        try {
            String content = this.getPrefix(attributePositions, t, this.target, args);
            return content.equalsIgnoreCase(args.get(1));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean endsWith(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String nodeVar = args.get(0);
        int pos = attributePositions.get(nodeVar);
        ParseNode node = t[pos];
        String content = ((LexerToken)this.target.getSrc().get((int)(node.to - 1))).content;
        return content.equalsIgnoreCase(args.get(1));
    }

    public boolean isSamePrefix(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String content = this.getPrefix(attributePositions, t, this.target, args);
        String nodeVar = args.get(1);
        int pos = attributePositions.get(nodeVar);
        ParseNode node = t[pos];
        String content1 = ((LexerToken)this.target.getSrc().get((int)node.from)).content;
        return content.equalsIgnoreCase(content1);
    }

    public boolean isOracleSuppliedPackage(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        String content = this.getPrefix(attributePositions, t, this.target, args);
        return oracleSuppledPackages.contains(content.toUpperCase());
    }

    private String getPrefix(Map<String, Integer> attributePositions, ParseNode[] t, Parsed target, List<String> args) {
        String nodeVar = args.get(0);
        int pos = attributePositions.get(nodeVar);
        ParseNode node = t[pos];
        return ((LexerToken)target.getSrc().get((int)node.from)).content;
    }

    @Override
    public Set<Issue> report(String input, boolean timing) {
        this.firstOcurrences = new TreeMap();
        return super.report(input, timing);
    }

    void AllLiterals(Parsed target, Map<String, ParseNode> tuple) {
        ParseNode node = tuple.get("literal");
        Integer pos = this.firstOcurrences.get(((LexerToken)target.getSrc().get((int)node.from)).content);
        if (pos == null) {
            this.firstOcurrences.put(((LexerToken)target.getSrc().get((int)node.from)).content, node.from);
        }
    }

    public boolean isDuplicateLiteral(Map<String, Integer> attributePositions, ParseNode[] t, List<String> args) {
        ParseNode node = t[1];
        String literal = ((LexerToken)this.target.getSrc().get((int)node.from)).content;
        return this.firstOcurrences.get(literal) != node.from;
    }

    static {
        oracleSuppledPackages.add("AS_REPLAY");
        oracleSuppledPackages.add("BSLN_INTERNAL");
        oracleSuppledPackages.add("CDBVIEW");
        oracleSuppledPackages.add("CDBVIEW_INTERNAL");
        oracleSuppledPackages.add("CTX_ADM");
        oracleSuppledPackages.add("CTX_ANL");
        oracleSuppledPackages.add("CTX_CATSEARCH");
        oracleSuppledPackages.add("CTX_CLS");
        oracleSuppledPackages.add("CTX_CONTAINS");
        oracleSuppledPackages.add("CTX_DDL");
        oracleSuppledPackages.add("CTX_DOC");
        oracleSuppledPackages.add("CTX_ENTITY");
        oracleSuppledPackages.add("CTX_MATCHES");
        oracleSuppledPackages.add("CTX_OUTPUT");
        oracleSuppledPackages.add("CTX_QUERY");
        oracleSuppledPackages.add("CTX_REPORT");
        oracleSuppledPackages.add("CTX_THES");
        oracleSuppledPackages.add("CTX_ULEXER");
        oracleSuppledPackages.add("CTX_XPCONTAINS");
        oracleSuppledPackages.add("DBFS_OFS_CONVERSION");
        oracleSuppledPackages.add("DBMSHSXP");
        oracleSuppledPackages.add("DBMSZEXP_SYSPKGGRNT");
        oracleSuppledPackages.add("DBMS_ACTIVITY");
        oracleSuppledPackages.add("DBMS_ADAT_REPORT");
        oracleSuppledPackages.add("DBMS_ADBTASK_ADMIN");
        oracleSuppledPackages.add("DBMS_ADDM");
        oracleSuppledPackages.add("DBMS_ADR");
        oracleSuppledPackages.add("DBMS_ADR_APP");
        oracleSuppledPackages.add("DBMS_ADR_INTERNAL");
        oracleSuppledPackages.add("DBMS_ADVANCED_REWRITE");
        oracleSuppledPackages.add("DBMS_ADVISOR");
        oracleSuppledPackages.add("DBMS_ALERT");
        oracleSuppledPackages.add("DBMS_APBACKEND");
        oracleSuppledPackages.add("DBMS_APPLICATION");
        oracleSuppledPackages.add("DBMS_APPLICATION_INFO");
        oracleSuppledPackages.add("DBMS_APPLY_ADM");
        oracleSuppledPackages.add("DBMS_APPLY_ADM_INTERNAL");
        oracleSuppledPackages.add("DBMS_APPLY_ADM_IVK");
        oracleSuppledPackages.add("DBMS_APPLY_ERROR");
        oracleSuppledPackages.add("DBMS_APPLY_POSITION");
        oracleSuppledPackages.add("DBMS_APPLY_PROCESS");
        oracleSuppledPackages.add("DBMS_APP_CONT");
        oracleSuppledPackages.add("DBMS_APP_CONT_ADMIN");
        oracleSuppledPackages.add("DBMS_APP_CONT_PRVT");
        oracleSuppledPackages.add("DBMS_APP_CONT_REPORT");
        oracleSuppledPackages.add("DBMS_AQ");
        oracleSuppledPackages.add("DBMS_AQADM");
        oracleSuppledPackages.add("DBMS_AQADM_INV");
        oracleSuppledPackages.add("DBMS_AQADM_SYS");
        oracleSuppledPackages.add("DBMS_AQADM_SYSCALLS");
        oracleSuppledPackages.add("DBMS_AQADM_VAR");
        oracleSuppledPackages.add("DBMS_AQELM");
        oracleSuppledPackages.add("DBMS_AQIN");
        oracleSuppledPackages.add("DBMS_AQJMS");
        oracleSuppledPackages.add("DBMS_AQJMS_INTERNAL");
        oracleSuppledPackages.add("DBMS_AQMIGTOOL");
        oracleSuppledPackages.add("DBMS_AQMIGTOOL_SYS");
        oracleSuppledPackages.add("DBMS_AQ_BQVIEW");
        oracleSuppledPackages.add("DBMS_AQ_EXP_CMT_TIME_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_DEQUEUELOG_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_HISTORY_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_INDEX_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_QUEUES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_QUEUE_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_SIGNATURE_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_SUBSCRIBER_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_TIMEMGR_TABLES");
        oracleSuppledPackages.add("DBMS_AQ_EXP_ZECURITY");
        oracleSuppledPackages.add("DBMS_AQ_IMPORT_INTERNAL");
        oracleSuppledPackages.add("DBMS_AQ_IMPORT_INTERNAL_DR");
        oracleSuppledPackages.add("DBMS_AQ_IMP_INTERNAL");
        oracleSuppledPackages.add("DBMS_AQ_IMP_ZECURITY");
        oracleSuppledPackages.add("DBMS_AQ_IND_MON");
        oracleSuppledPackages.add("DBMS_AQ_INV");
        oracleSuppledPackages.add("DBMS_AQ_SUB");
        oracleSuppledPackages.add("DBMS_AQ_SYS_EXP_ACTIONS");
        oracleSuppledPackages.add("DBMS_AQ_SYS_EXP_INTERNAL");
        oracleSuppledPackages.add("DBMS_AQ_SYS_IMP_INTERNAL");
        oracleSuppledPackages.add("DBMS_ARCH_PROVIDER_INTL");
        oracleSuppledPackages.add("DBMS_ASH");
        oracleSuppledPackages.add("DBMS_ASH_INTERNAL");
        oracleSuppledPackages.add("DBMS_ASSERT");
        oracleSuppledPackages.add("DBMS_AUDIT_MGMT_SUPPORT");
        oracleSuppledPackages.add("DBMS_AUDIT_UTIL");
        oracleSuppledPackages.add("DBMS_AUTOIM");
        oracleSuppledPackages.add("DBMS_AUTOIM_INTERNAL");
        oracleSuppledPackages.add("DBMS_AUTOTASK_PRVT");
        oracleSuppledPackages.add("DBMS_AUTO_CLUSTERING");
        oracleSuppledPackages.add("DBMS_AUTO_CLUSTERING_INTERNAL");
        oracleSuppledPackages.add("DBMS_AUTO_INDEX");
        oracleSuppledPackages.add("DBMS_AUTO_INDEX_INTERNAL");
        oracleSuppledPackages.add("DBMS_AUTO_REPORT");
        oracleSuppledPackages.add("DBMS_AUTO_REPORT_INTERNAL");
        oracleSuppledPackages.add("DBMS_AUTO_SQLSET");
        oracleSuppledPackages.add("DBMS_AUTO_SQLTUNE");
        oracleSuppledPackages.add("DBMS_AUTO_TASK");
        oracleSuppledPackages.add("DBMS_AUTO_TASK_ADMIN");
        oracleSuppledPackages.add("DBMS_AUTO_TASK_EXPORT");
        oracleSuppledPackages.add("DBMS_AUTO_TASK_IMMEDIATE");
        oracleSuppledPackages.add("DBMS_AUTO_ZONEMAP");
        oracleSuppledPackages.add("DBMS_AUTO_ZONEMAP_INTERNAL");
        oracleSuppledPackages.add("DBMS_AVTUNE");
        oracleSuppledPackages.add("DBMS_AVTUNE_UTIL");
        oracleSuppledPackages.add("DBMS_AW");
        oracleSuppledPackages.add("DBMS_AWRHUB");
        oracleSuppledPackages.add("DBMS_AWRHUB_SERVER");
        oracleSuppledPackages.add("DBMS_AWRHUB_SOURCE");
        oracleSuppledPackages.add("DBMS_AWR_ANALYTICS");
        oracleSuppledPackages.add("DBMS_AWR_PROTECTED");
        oracleSuppledPackages.add("DBMS_AWR_REPORT_LAYOUT");
        oracleSuppledPackages.add("DBMS_AWR_WAREHOUSE_SERVER");
        oracleSuppledPackages.add("DBMS_AWR_WAREHOUSE_SOURCE");
        oracleSuppledPackages.add("DBMS_AW_EXP");
        oracleSuppledPackages.add("DBMS_AW_INTERNAL");
        oracleSuppledPackages.add("DBMS_AW_STATS");
        oracleSuppledPackages.add("DBMS_AW_XML");
        oracleSuppledPackages.add("DBMS_BACKUP_RESTORE");
        oracleSuppledPackages.add("DBMS_BDSQL");
        oracleSuppledPackages.add("DBMS_BLOCKCHAIN_TABLE");
        oracleSuppledPackages.add("DBMS_BLOCKCHAIN_UTL");
        oracleSuppledPackages.add("DBMS_CACHEUTIL");
        oracleSuppledPackages.add("DBMS_CAPTURE_ADM");
        oracleSuppledPackages.add("DBMS_CAPTURE_ADM_INTERNAL");
        oracleSuppledPackages.add("DBMS_CAPTURE_ADM_IVK");
        oracleSuppledPackages.add("DBMS_CAPTURE_PROCESS");
        oracleSuppledPackages.add("DBMS_CAPTURE_SWITCH_ADM");
        oracleSuppledPackages.add("DBMS_CAPTURE_SWITCH_INTERNAL");
        oracleSuppledPackages.add("DBMS_CHAIN_INVOKER");
        oracleSuppledPackages.add("DBMS_CHANGE_NOTIFICATION");
        oracleSuppledPackages.add("DBMS_CLIENT_RESULT_CACHE");
        oracleSuppledPackages.add("DBMS_CLOBUTIL");
        oracleSuppledPackages.add("DBMS_CLUSTDB");
        oracleSuppledPackages.add("DBMS_CMP_INT");
        oracleSuppledPackages.add("DBMS_COMPARISON");
        oracleSuppledPackages.add("DBMS_COMPRESSION");
        oracleSuppledPackages.add("DBMS_CONNECTION_POOL");
        oracleSuppledPackages.add("DBMS_CREDENTIAL");
        oracleSuppledPackages.add("DBMS_CRYPTO");
        oracleSuppledPackages.add("DBMS_CRYPTO_FFI");
        oracleSuppledPackages.add("DBMS_CRYPTO_INTERNAL");
        oracleSuppledPackages.add("DBMS_CSX_ADMIN");
        oracleSuppledPackages.add("DBMS_CSX_INT");
        oracleSuppledPackages.add("DBMS_CSX_INT2");
        oracleSuppledPackages.add("DBMS_CUBE");
        oracleSuppledPackages.add("DBMS_CUBE_ADVISE");
        oracleSuppledPackages.add("DBMS_CUBE_ADVISE_SEC");
        oracleSuppledPackages.add("DBMS_CUBE_EXP");
        oracleSuppledPackages.add("DBMS_CUBE_LOG");
        oracleSuppledPackages.add("DBMS_CUBE_PRVTEXP");
        oracleSuppledPackages.add("DBMS_CUBE_UTIL");
        oracleSuppledPackages.add("DBMS_DATAPUMP");
        oracleSuppledPackages.add("DBMS_DATAPUMP_INT");
        oracleSuppledPackages.add("DBMS_DATAPUMP_UTL");
        oracleSuppledPackages.add("DBMS_DATA_GUARD");
        oracleSuppledPackages.add("DBMS_DATA_GUARD_INTERNAL");
        oracleSuppledPackages.add("DBMS_DATA_MINING");
        oracleSuppledPackages.add("DBMS_DATA_MINING_INTERNAL");
        oracleSuppledPackages.add("DBMS_DATA_MINING_TRANSFORM");
        oracleSuppledPackages.add("DBMS_DBCOMP");
        oracleSuppledPackages.add("DBMS_DBFS_CONTENT");
        oracleSuppledPackages.add("DBMS_DBFS_CONTENT_ADMIN");
        oracleSuppledPackages.add("DBMS_DBFS_CONTENT_SPI");
        oracleSuppledPackages.add("DBMS_DBFS_HS");
        oracleSuppledPackages.add("DBMS_DBFS_SFS");
        oracleSuppledPackages.add("DBMS_DBFS_SFS_ADMIN");
        oracleSuppledPackages.add("DBMS_DBVERIFY");
        oracleSuppledPackages.add("DBMS_DB_VERSION");
        oracleSuppledPackages.add("DBMS_DDL");
        oracleSuppledPackages.add("DBMS_DDL_INTERNAL");
        oracleSuppledPackages.add("DBMS_DEBUG");
        oracleSuppledPackages.add("DBMS_DEBUG_JDWP");
        oracleSuppledPackages.add("DBMS_DEBUG_JDWP_CUSTOM");
        oracleSuppledPackages.add("DBMS_DEFER_IMPORT_INTERNAL");
        oracleSuppledPackages.add("DBMS_DESCRIBE");
        oracleSuppledPackages.add("DBMS_DG");
        oracleSuppledPackages.add("DBMS_DGPDB");
        oracleSuppledPackages.add("DBMS_DIMENSION");
        oracleSuppledPackages.add("DBMS_DISRUPT");
        oracleSuppledPackages.add("DBMS_DISTRIBUTED_TRUST_ADMIN");
        oracleSuppledPackages.add("DBMS_DLM");
        oracleSuppledPackages.add("DBMS_DM_EXP_INTERNAL");
        oracleSuppledPackages.add("DBMS_DM_MODEL_EXP");
        oracleSuppledPackages.add("DBMS_DM_MODEL_IMP");
        oracleSuppledPackages.add("DBMS_DM_UTIL");
        oracleSuppledPackages.add("DBMS_DNFS");
        oracleSuppledPackages.add("DBMS_DRS");
        oracleSuppledPackages.add("DBMS_DST");
        oracleSuppledPackages.add("DBMS_EDITIONS_UTILITIES");
        oracleSuppledPackages.add("DBMS_EPG");
        oracleSuppledPackages.add("DBMS_ERRLOG");
        oracleSuppledPackages.add("DBMS_EXPORT_EXTENSION");
        oracleSuppledPackages.add("DBMS_EXPORT_EXTENSION_I");
        oracleSuppledPackages.add("DBMS_EXTENDED_TTS_CHECKS");
        oracleSuppledPackages.add("DBMS_FBT");
        oracleSuppledPackages.add("DBMS_FEATURE_USAGE");
        oracleSuppledPackages.add("DBMS_FEATURE_USAGE_CLIENT");
        oracleSuppledPackages.add("DBMS_FEATURE_USAGE_INTERNAL");
        oracleSuppledPackages.add("DBMS_FEATURE_USAGE_REPORT");
        oracleSuppledPackages.add("DBMS_FGA");
        oracleSuppledPackages.add("DBMS_FILE_GROUP");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_DECL");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_EXP");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_EXP_INTERNAL");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_IMP");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_IMP_INTERNAL");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_INTERNAL_INVOK");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_UTL");
        oracleSuppledPackages.add("DBMS_FILE_GROUP_UTL_INVOK");
        oracleSuppledPackages.add("DBMS_FILE_TRANSFER");
        oracleSuppledPackages.add("DBMS_FLASHBACK");
        oracleSuppledPackages.add("DBMS_FLASHBACK_ARCHIVE");
        oracleSuppledPackages.add("DBMS_FREQUENT_ITEMSET");
        oracleSuppledPackages.add("DBMS_FS");
        oracleSuppledPackages.add("DBMS_FUSE");
        oracleSuppledPackages.add("DBMS_FUSE_PUBLIC");
        oracleSuppledPackages.add("DBMS_GOLDENGATE_ADM");
        oracleSuppledPackages.add("DBMS_GOLDENGATE_ADM_INTERNAL");
        oracleSuppledPackages.add("DBMS_GOLDENGATE_ADM_INT_INVOK");
        oracleSuppledPackages.add("DBMS_GOLDENGATE_AUTH");
        oracleSuppledPackages.add("DBMS_GOLDENGATE_EXP");
        oracleSuppledPackages.add("DBMS_GOLDENGATE_IMP");
        oracleSuppledPackages.add("DBMS_GSM_CURUSER");
        oracleSuppledPackages.add("DBMS_GSM_DDL");
        oracleSuppledPackages.add("DBMS_GSM_FIX");
        oracleSuppledPackages.add("DBMS_GSM_FIXED");
        oracleSuppledPackages.add("DBMS_GSM_GSMUSER");
        oracleSuppledPackages.add("DBMS_GSM_SEC");
        oracleSuppledPackages.add("DBMS_HADOOP");
        oracleSuppledPackages.add("DBMS_HADOOP_INTERNAL");
        oracleSuppledPackages.add("DBMS_HANG_MANAGER");
        oracleSuppledPackages.add("DBMS_HA_ALERTS");
        oracleSuppledPackages.add("DBMS_HA_ALERTS_PRVT");
        oracleSuppledPackages.add("DBMS_HCHECK");
        oracleSuppledPackages.add("DBMS_HCS_LOG");
        oracleSuppledPackages.add("DBMS_HEAT_MAP");
        oracleSuppledPackages.add("DBMS_HEAT_MAP_INTERNAL");
        oracleSuppledPackages.add("DBMS_HIERARCHY");
        oracleSuppledPackages.add("DBMS_HM");
        oracleSuppledPackages.add("DBMS_HPROF");
        oracleSuppledPackages.add("DBMS_HS");
        oracleSuppledPackages.add("DBMS_HS_ALT");
        oracleSuppledPackages.add("DBMS_HS_CHK");
        oracleSuppledPackages.add("DBMS_HS_UTL");
        oracleSuppledPackages.add("DBMS_IJOB");
        oracleSuppledPackages.add("DBMS_ILM");
        oracleSuppledPackages.add("DBMS_ILM_ADMIN");
        oracleSuppledPackages.add("DBMS_IMMUTABLE_TABLE");
        oracleSuppledPackages.add("DBMS_INDEX_UTL");
        oracleSuppledPackages.add("DBMS_INMEMORY");
        oracleSuppledPackages.add("DBMS_INMEMORY_ADMIN");
        oracleSuppledPackages.add("DBMS_INTERNAL_LOGSTDBY");
        oracleSuppledPackages.add("DBMS_INTERNAL_ROLLING");
        oracleSuppledPackages.add("DBMS_INTERNAL_SAFE_SCN");
        oracleSuppledPackages.add("DBMS_INTERNAL_TRIGGER");
        oracleSuppledPackages.add("DBMS_IR");
        oracleSuppledPackages.add("DBMS_IREFRESH");
        oracleSuppledPackages.add("DBMS_IREFSTATS");
        oracleSuppledPackages.add("DBMS_ISCHED");
        oracleSuppledPackages.add("DBMS_ISCHEDFW");
        oracleSuppledPackages.add("DBMS_ISCHED_AGENT");
        oracleSuppledPackages.add("DBMS_ISCHED_CHAIN_CONDITION");
        oracleSuppledPackages.add("DBMS_ISCHED_REMDB_JOB");
        oracleSuppledPackages.add("DBMS_ISCHED_REMOTE_ACCESS");
        oracleSuppledPackages.add("DBMS_ISCHED_UTL");
        oracleSuppledPackages.add("DBMS_ISNAPSHOT");
        oracleSuppledPackages.add("DBMS_ISYNCREF");
        oracleSuppledPackages.add("DBMS_ITRIGGER_UTL");
        oracleSuppledPackages.add("DBMS_I_INDEX_UTL");
        oracleSuppledPackages.add("DBMS_JAVA");
        oracleSuppledPackages.add("DBMS_JAVASCRIPT");
        oracleSuppledPackages.add("DBMS_JAVA_DEFINERS");
        oracleSuppledPackages.add("DBMS_JAVA_DUMP");
        oracleSuppledPackages.add("DBMS_JAVA_MISC");
        oracleSuppledPackages.add("DBMS_JAVA_TEST");
        oracleSuppledPackages.add("DBMS_JMS_PLSQL");
        oracleSuppledPackages.add("DBMS_JOB");
        oracleSuppledPackages.add("DBMS_JSON");
        oracleSuppledPackages.add("DBMS_JSON0");
        oracleSuppledPackages.add("DBMS_JSON_DUALITY");
        oracleSuppledPackages.add("DBMS_JSON_INT");
        oracleSuppledPackages.add("DBMS_JSON_SCHEMA");
        oracleSuppledPackages.add("DBMS_JVM_EXP_PERMS");
        oracleSuppledPackages.add("DBMS_KAFKA");
        oracleSuppledPackages.add("DBMS_KAFKA_ADM");
        oracleSuppledPackages.add("DBMS_KAFKA_INT");
        oracleSuppledPackages.add("DBMS_KAFKA_MD");
        oracleSuppledPackages.add("DBMS_KAFKA_UTL");
        oracleSuppledPackages.add("DBMS_LCR");
        oracleSuppledPackages.add("DBMS_LDAP");
        oracleSuppledPackages.add("DBMS_LDAP_API_FFI");
        oracleSuppledPackages.add("DBMS_LDAP_UTL");
        oracleSuppledPackages.add("DBMS_LOB");
        oracleSuppledPackages.add("DBMS_LOBUTIL");
        oracleSuppledPackages.add("DBMS_LOB_AM_PRIVATE");
        oracleSuppledPackages.add("DBMS_LOCK");
        oracleSuppledPackages.add("DBMS_LOG");
        oracleSuppledPackages.add("DBMS_LOGMNR");
        oracleSuppledPackages.add("DBMS_LOGMNR_D");
        oracleSuppledPackages.add("DBMS_LOGMNR_INTERNAL");
        oracleSuppledPackages.add("DBMS_LOGMNR_LOGREP_DICT");
        oracleSuppledPackages.add("DBMS_LOGMNR_SESSION_INT");
        oracleSuppledPackages.add("DBMS_LOGREP_DEF_PROC_UTL");
        oracleSuppledPackages.add("DBMS_LOGREP_EXP");
        oracleSuppledPackages.add("DBMS_LOGREP_IMP");
        oracleSuppledPackages.add("DBMS_LOGREP_IMP_INTERNAL");
        oracleSuppledPackages.add("DBMS_LOGREP_UTIL");
        oracleSuppledPackages.add("DBMS_LOGREP_UTIL_INVOK");
        oracleSuppledPackages.add("DBMS_LOGSTDBY");
        oracleSuppledPackages.add("DBMS_LOGSTDBY_CONTEXT");
        oracleSuppledPackages.add("DBMS_MAINTPLAN");
        oracleSuppledPackages.add("DBMS_MANAGEMENT_BOOTSTRAP");
        oracleSuppledPackages.add("DBMS_MANAGEMENT_DIAGNOSTICS");
        oracleSuppledPackages.add("DBMS_MANAGEMENT_PACKS");
        oracleSuppledPackages.add("DBMS_MASTER_TABLE");
        oracleSuppledPackages.add("DBMS_MAX_STRING_SIZE");
        oracleSuppledPackages.add("DBMS_MDX_ODBO");
        oracleSuppledPackages.add("DBMS_MDX_UTIL");
        oracleSuppledPackages.add("DBMS_MEMOPTIMIZE");
        oracleSuppledPackages.add("DBMS_MEMOPTIMIZE_ADMIN");
        oracleSuppledPackages.add("DBMS_METADATA");
        oracleSuppledPackages.add("DBMS_METADATA_BUILD");
        oracleSuppledPackages.add("DBMS_METADATA_DIFF");
        oracleSuppledPackages.add("DBMS_METADATA_DPBUILD");
        oracleSuppledPackages.add("DBMS_METADATA_INT");
        oracleSuppledPackages.add("DBMS_METADATA_UTIL");
        oracleSuppledPackages.add("DBMS_MLE");
        oracleSuppledPackages.add("DBMS_MONITOR");
        oracleSuppledPackages.add("DBMS_MVIEW_STATS");
        oracleSuppledPackages.add("DBMS_MVIEW_STATS_INTERNAL");
        oracleSuppledPackages.add("DBMS_NETWORK_ACL_ADMIN");
        oracleSuppledPackages.add("DBMS_NETWORK_ACL_UTILITY");
        oracleSuppledPackages.add("DBMS_NOTIFICATIONS");
        oracleSuppledPackages.add("DBMS_OBJECTS_APPS_UTILS");
        oracleSuppledPackages.add("DBMS_OBJECTS_UTILS");
        oracleSuppledPackages.add("DBMS_ODCI");
        oracleSuppledPackages.add("DBMS_OPTIM_BUNDLE");
        oracleSuppledPackages.add("DBMS_OUTPUT");
        oracleSuppledPackages.add("DBMS_PARALLEL_EXECUTE");
        oracleSuppledPackages.add("DBMS_PARALLEL_EXECUTE_INTERNAL");
        oracleSuppledPackages.add("DBMS_PART");
        oracleSuppledPackages.add("DBMS_PART_INTERNAL");
        oracleSuppledPackages.add("DBMS_PCLXUTIL");
        oracleSuppledPackages.add("DBMS_PCLXUTIL_INTERNAL");
        oracleSuppledPackages.add("DBMS_PDB");
        oracleSuppledPackages.add("DBMS_PDB_ALTER_SHARING");
        oracleSuppledPackages.add("DBMS_PDB_APP_CON");
        oracleSuppledPackages.add("DBMS_PERF");
        oracleSuppledPackages.add("DBMS_PICKLER");
        oracleSuppledPackages.add("DBMS_PIPE");
        oracleSuppledPackages.add("DBMS_PITR");
        oracleSuppledPackages.add("DBMS_PLSQL_CODE_COVERAGE");
        oracleSuppledPackages.add("DBMS_PLUGTS");
        oracleSuppledPackages.add("DBMS_PLUGTSP");
        oracleSuppledPackages.add("DBMS_PQDIAG");
        oracleSuppledPackages.add("DBMS_PQ_INTERNAL");
        oracleSuppledPackages.add("DBMS_PREDICTIVE_ANALYTICS");
        oracleSuppledPackages.add("DBMS_PREPLUGIN_BACKUP");
        oracleSuppledPackages.add("DBMS_PREPROCESSOR");
        oracleSuppledPackages.add("DBMS_PRIVILEGE_CAPTURE");
        oracleSuppledPackages.add("DBMS_PRIV_CAPTURE");
        oracleSuppledPackages.add("DBMS_PROCESS");
        oracleSuppledPackages.add("DBMS_PROFILER");
        oracleSuppledPackages.add("DBMS_PROPAGATION_ADM");
        oracleSuppledPackages.add("DBMS_PROPAGATION_INTERNAL");
        oracleSuppledPackages.add("DBMS_PRVTAQIM");
        oracleSuppledPackages.add("DBMS_PRVTAQIP");
        oracleSuppledPackages.add("DBMS_PRVTAQIS");
        oracleSuppledPackages.add("DBMS_PRVTRMIE");
        oracleSuppledPackages.add("DBMS_PRVTSQDS");
        oracleSuppledPackages.add("DBMS_PRVTSQIS");
        oracleSuppledPackages.add("DBMS_PRVT_TRACE");
        oracleSuppledPackages.add("DBMS_PSP");
        oracleSuppledPackages.add("DBMS_PSWMG_IMPORT");
        oracleSuppledPackages.add("DBMS_QOPATCH");
        oracleSuppledPackages.add("DBMS_RANDOM");
        oracleSuppledPackages.add("DBMS_RAT_MASK");
        oracleSuppledPackages.add("DBMS_RAT_MASK_INTERNAL");
        oracleSuppledPackages.add("DBMS_RCVMAN");
        oracleSuppledPackages.add("DBMS_RECOVERABLE_SCRIPT");
        oracleSuppledPackages.add("DBMS_RECO_SCRIPT_INT");
        oracleSuppledPackages.add("DBMS_RECO_SCRIPT_INVOK");
        oracleSuppledPackages.add("DBMS_REDACT");
        oracleSuppledPackages.add("DBMS_REDACTOR");
        oracleSuppledPackages.add("DBMS_REDACT_INT");
        oracleSuppledPackages.add("DBMS_REDEFINITION");
        oracleSuppledPackages.add("DBMS_REDEFINITION_INTERNAL");
        oracleSuppledPackages.add("DBMS_REFRESH");
        oracleSuppledPackages.add("DBMS_REGISTRY");
        oracleSuppledPackages.add("DBMS_REGISTRY_EXTENDED");
        oracleSuppledPackages.add("DBMS_REGISTRY_SERVER");
        oracleSuppledPackages.add("DBMS_REGISTRY_SIMPLE");
        oracleSuppledPackages.add("DBMS_REGISTRY_SYS");
        oracleSuppledPackages.add("DBMS_REGXDB");
        oracleSuppledPackages.add("DBMS_REPAIR");
        oracleSuppledPackages.add("DBMS_REPCAT");
        oracleSuppledPackages.add("DBMS_REPCAT_MIG");
        oracleSuppledPackages.add("DBMS_REPLAYHUB");
        oracleSuppledPackages.add("DBMS_REPORT");
        oracleSuppledPackages.add("DBMS_REPUTIL");
        oracleSuppledPackages.add("DBMS_RESCONFIG");
        oracleSuppledPackages.add("DBMS_RESOURCE_MANAGER");
        oracleSuppledPackages.add("DBMS_RESOURCE_MANAGER_PRIVS");
        oracleSuppledPackages.add("DBMS_RESULT_CACHE");
        oracleSuppledPackages.add("DBMS_RESULT_CACHE_API");
        oracleSuppledPackages.add("DBMS_RESULT_CACHE_INTERNAL");
        oracleSuppledPackages.add("DBMS_RESUMABLE");
        oracleSuppledPackages.add("DBMS_RLS");
        oracleSuppledPackages.add("DBMS_RLS_INT");
        oracleSuppledPackages.add("DBMS_RMGR_GROUP_EXPORT");
        oracleSuppledPackages.add("DBMS_RMGR_PACT_EXPORT");
        oracleSuppledPackages.add("DBMS_RMGR_PLAN_EXPORT");
        oracleSuppledPackages.add("DBMS_RMIN");
        oracleSuppledPackages.add("DBMS_RMIN_SYS");
        oracleSuppledPackages.add("DBMS_ROLLING");
        oracleSuppledPackages.add("DBMS_ROUTER_ADMIN");
        oracleSuppledPackages.add("DBMS_ROWID");
        oracleSuppledPackages.add("DBMS_ROW_CHANGE_TRACKING");
        oracleSuppledPackages.add("DBMS_ROW_CHANGE_TRACKING_INT");
        oracleSuppledPackages.add("DBMS_RULE");
        oracleSuppledPackages.add("DBMS_RULEADM_INTERNAL");
        oracleSuppledPackages.add("DBMS_RULE_ADM");
        oracleSuppledPackages.add("DBMS_RULE_EXIMP");
        oracleSuppledPackages.add("DBMS_RULE_EXP_EC_INTERNAL");
        oracleSuppledPackages.add("DBMS_RULE_EXP_EV_CTXS");
        oracleSuppledPackages.add("DBMS_RULE_EXP_RL_INTERNAL");
        oracleSuppledPackages.add("DBMS_RULE_EXP_RS_INTERNAL");
        oracleSuppledPackages.add("DBMS_RULE_EXP_RULES");
        oracleSuppledPackages.add("DBMS_RULE_EXP_RULE_SETS");
        oracleSuppledPackages.add("DBMS_RULE_EXP_UTL");
        oracleSuppledPackages.add("DBMS_RULE_EXP_UTLI");
        oracleSuppledPackages.add("DBMS_RULE_IMP_OBJ");
        oracleSuppledPackages.add("DBMS_RULE_INTERNAL");
        oracleSuppledPackages.add("DBMS_SAGA");
        oracleSuppledPackages.add("DBMS_SAGA_ADM");
        oracleSuppledPackages.add("DBMS_SAGA_ADM_SYS");
        oracleSuppledPackages.add("DBMS_SAGA_CONNECT_INT");
        oracleSuppledPackages.add("DBMS_SAGA_SYS");
        oracleSuppledPackages.add("DBMS_SCHEDULER");
        oracleSuppledPackages.add("DBMS_SCHED_ARGUMENT_IMPORT");
        oracleSuppledPackages.add("DBMS_SCHED_ATTRIBUTE_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_CHAIN_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_CLASS_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_CONSTRAINT_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_CREDENTIAL_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_EXPORT_CALLOUTS");
        oracleSuppledPackages.add("DBMS_SCHED_FILE_WATCHER_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_JOB_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_MAIN_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_PROGRAM_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_SCHEDULE_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_WINDOW_EXPORT");
        oracleSuppledPackages.add("DBMS_SCHED_WINGRP_EXPORT");
        oracleSuppledPackages.add("DBMS_SCN");
        oracleSuppledPackages.add("DBMS_SEARCH");
        oracleSuppledPackages.add("DBMS_SEARCH_DEF");
        oracleSuppledPackages.add("DBMS_SECUREFILE_LOG_ADMIN");
        oracleSuppledPackages.add("DBMS_SENSITIVE_DATA");
        oracleSuppledPackages.add("DBMS_SERVER_ALERT");
        oracleSuppledPackages.add("DBMS_SERVER_ALERT_EXPORT");
        oracleSuppledPackages.add("DBMS_SERVER_ALERT_PRVT");
        oracleSuppledPackages.add("DBMS_SERVICE");
        oracleSuppledPackages.add("DBMS_SERVICE_CONST");
        oracleSuppledPackages.add("DBMS_SERVICE_ERR");
        oracleSuppledPackages.add("DBMS_SERVICE_PRVT");
        oracleSuppledPackages.add("DBMS_SESSION");
        oracleSuppledPackages.add("DBMS_SESSION_STATE");
        oracleSuppledPackages.add("DBMS_SHARED_CAPTURE_ADM");
        oracleSuppledPackages.add("DBMS_SHARED_CAPTURE_INTERNAL");
        oracleSuppledPackages.add("DBMS_SHARED_CAPTURE_IVK");
        oracleSuppledPackages.add("DBMS_SHARED_POOL");
        oracleSuppledPackages.add("DBMS_SMB");
        oracleSuppledPackages.add("DBMS_SMB_INTERNAL");
        oracleSuppledPackages.add("DBMS_SNAPSHOT");
        oracleSuppledPackages.add("DBMS_SNAPSHOT_COMMON");
        oracleSuppledPackages.add("DBMS_SNAPSHOT_KKXRCA");
        oracleSuppledPackages.add("DBMS_SNAPSHOT_UTL");
        oracleSuppledPackages.add("DBMS_SNAP_INTERNAL");
        oracleSuppledPackages.add("DBMS_SNAP_REPAPI");
        oracleSuppledPackages.add("DBMS_SODA");
        oracleSuppledPackages.add("DBMS_SODA_ADMIN");
        oracleSuppledPackages.add("DBMS_SODA_DML");
        oracleSuppledPackages.add("DBMS_SODA_DOM");
        oracleSuppledPackages.add("DBMS_SODA_USER_ADMIN");
        oracleSuppledPackages.add("DBMS_SODA_USER_DML");
        oracleSuppledPackages.add("DBMS_SODA_UTIL");
        oracleSuppledPackages.add("DBMS_SPACE");
        oracleSuppledPackages.add("DBMS_SPACE_ADMIN");
        oracleSuppledPackages.add("DBMS_SPACE_ALERT");
        oracleSuppledPackages.add("DBMS_SPD");
        oracleSuppledPackages.add("DBMS_SPD_INTERNAL");
        oracleSuppledPackages.add("DBMS_SPM");
        oracleSuppledPackages.add("DBMS_SPM_INTERNAL");
        oracleSuppledPackages.add("DBMS_SQADM_SYSCALLS");
        oracleSuppledPackages.add("DBMS_SQL");
        oracleSuppledPackages.add("DBMS_SQLCONTROL_INTERNAL");
        oracleSuppledPackages.add("DBMS_SQLDIAG");
        oracleSuppledPackages.add("DBMS_SQLDIAG_INTERNAL");
        oracleSuppledPackages.add("DBMS_SQLHASH");
        oracleSuppledPackages.add("DBMS_SQLHIST");
        oracleSuppledPackages.add("DBMS_SQLJTYPE");
        oracleSuppledPackages.add("DBMS_SQLPA");
        oracleSuppledPackages.add("DBMS_SQLPATCH");
        oracleSuppledPackages.add("DBMS_SQLQ");
        oracleSuppledPackages.add("DBMS_SQLQ_INTERNAL");
        oracleSuppledPackages.add("DBMS_SQLSET");
        oracleSuppledPackages.add("DBMS_SQLTCB_INTERNAL");
        oracleSuppledPackages.add("DBMS_SQLTUNE");
        oracleSuppledPackages.add("DBMS_SQLTUNE_INTERNAL");
        oracleSuppledPackages.add("DBMS_SQLTUNE_UTIL0");
        oracleSuppledPackages.add("DBMS_SQLTUNE_UTIL1");
        oracleSuppledPackages.add("DBMS_SQLTUNE_UTIL2");
        oracleSuppledPackages.add("DBMS_SQL_FIREWALL");
        oracleSuppledPackages.add("DBMS_SQL_MONITOR");
        oracleSuppledPackages.add("DBMS_SQL_TRANSLATOR");
        oracleSuppledPackages.add("DBMS_SQL_TRANSLATOR_EXPORT");
        oracleSuppledPackages.add("DBMS_STANDARD");
        oracleSuppledPackages.add("DBMS_STATS");
        oracleSuppledPackages.add("DBMS_STATS_ADVISOR");
        oracleSuppledPackages.add("DBMS_STATS_INTERNAL");
        oracleSuppledPackages.add("DBMS_STATS_INTERNAL_AGG");
        oracleSuppledPackages.add("DBMS_STAT_FUNCS");
        oracleSuppledPackages.add("DBMS_STAT_FUNCS_AUX");
        oracleSuppledPackages.add("DBMS_STORAGE_MAP");
        oracleSuppledPackages.add("DBMS_STREAMS");
        oracleSuppledPackages.add("DBMS_STREAMS_ADM");
        oracleSuppledPackages.add("DBMS_STREAMS_ADM_IVK");
        oracleSuppledPackages.add("DBMS_STREAMS_ADM_UTL");
        oracleSuppledPackages.add("DBMS_STREAMS_ADM_UTL_INT");
        oracleSuppledPackages.add("DBMS_STREAMS_ADM_UTL_INVOK");
        oracleSuppledPackages.add("DBMS_STREAMS_AUTH");
        oracleSuppledPackages.add("DBMS_STREAMS_AUTO_INT");
        oracleSuppledPackages.add("DBMS_STREAMS_CONTROL_ADM");
        oracleSuppledPackages.add("DBMS_STREAMS_DATAPUMP");
        oracleSuppledPackages.add("DBMS_STREAMS_DATAPUMP_UTIL");
        oracleSuppledPackages.add("DBMS_STREAMS_DECL");
        oracleSuppledPackages.add("DBMS_STREAMS_LCR_INT");
        oracleSuppledPackages.add("DBMS_STREAMS_MT");
        oracleSuppledPackages.add("DBMS_STREAMS_PUB_RPC");
        oracleSuppledPackages.add("DBMS_STREAMS_RPC");
        oracleSuppledPackages.add("DBMS_STREAMS_RPC_INTERNAL");
        oracleSuppledPackages.add("DBMS_STREAMS_SM");
        oracleSuppledPackages.add("DBMS_STREAMS_TABLESPACE_ADM");
        oracleSuppledPackages.add("DBMS_STREAMS_TBS_INT");
        oracleSuppledPackages.add("DBMS_STREAMS_TBS_INT_INVOK");
        oracleSuppledPackages.add("DBMS_SUMMARY");
        oracleSuppledPackages.add("DBMS_SUMVDM");
        oracleSuppledPackages.add("DBMS_SUM_RWEQ_EXPORT");
        oracleSuppledPackages.add("DBMS_SUM_RWEQ_EXPORT_INTERNAL");
        oracleSuppledPackages.add("DBMS_SWAT");
        oracleSuppledPackages.add("DBMS_SWAT_ARM_INTERNAL");
        oracleSuppledPackages.add("DBMS_SWAT_INTERNAL");
        oracleSuppledPackages.add("DBMS_SWAT_MM_INTERNAL");
        oracleSuppledPackages.add("DBMS_SWAT_MM_UTILS");
        oracleSuppledPackages.add("DBMS_SWAT_VER_INTERNAL");
        oracleSuppledPackages.add("DBMS_SWAT_XML");
        oracleSuppledPackages.add("DBMS_SWRF_INTERNAL");
        oracleSuppledPackages.add("DBMS_SWRF_REPORT_INTERNAL");
        oracleSuppledPackages.add("DBMS_SYNC_REFRESH");
        oracleSuppledPackages.add("DBMS_SYNC_REFRESH_INTERNAL");
        oracleSuppledPackages.add("DBMS_SYSTEM");
        oracleSuppledPackages.add("DBMS_SYS_ERROR");
        oracleSuppledPackages.add("DBMS_SYS_MLE");
        oracleSuppledPackages.add("DBMS_SYS_SQL");
        oracleSuppledPackages.add("DBMS_TABLE_DATA");
        oracleSuppledPackages.add("DBMS_TABLE_FUNC");
        oracleSuppledPackages.add("DBMS_TDB");
        oracleSuppledPackages.add("DBMS_TDE_TOOLKIT");
        oracleSuppledPackages.add("DBMS_TDE_TOOLKIT_FFI");
        oracleSuppledPackages.add("DBMS_TEQK");
        oracleSuppledPackages.add("DBMS_TF");
        oracleSuppledPackages.add("DBMS_TG_DBG");
        oracleSuppledPackages.add("DBMS_TNS");
        oracleSuppledPackages.add("DBMS_TRACE");
        oracleSuppledPackages.add("DBMS_TRANSACTION");
        oracleSuppledPackages.add("DBMS_TRANSACTION_INTERNAL_SYS");
        oracleSuppledPackages.add("DBMS_TRANSFORM");
        oracleSuppledPackages.add("DBMS_TRANSFORM_EXIMP");
        oracleSuppledPackages.add("DBMS_TRANSFORM_EXIMP_INTERNAL");
        oracleSuppledPackages.add("DBMS_TRANSFORM_INTERNAL");
        oracleSuppledPackages.add("DBMS_TSDP_MANAGE");
        oracleSuppledPackages.add("DBMS_TSDP_PROTECT");
        oracleSuppledPackages.add("DBMS_TSDP_PROTECT_INT");
        oracleSuppledPackages.add("DBMS_TTS");
        oracleSuppledPackages.add("DBMS_TYPES");
        oracleSuppledPackages.add("DBMS_TYPE_UTILITY");
        oracleSuppledPackages.add("DBMS_UMF");
        oracleSuppledPackages.add("DBMS_UMF_INTERNAL");
        oracleSuppledPackages.add("DBMS_UMF_PROTECTED");
        oracleSuppledPackages.add("DBMS_UNDO_ADV");
        oracleSuppledPackages.add("DBMS_UPG_JSON");
        oracleSuppledPackages.add("DBMS_UPG_JSON0");
        oracleSuppledPackages.add("DBMS_UPG_JSON_INT");
        oracleSuppledPackages.add("DBMS_USERDIAG");
        oracleSuppledPackages.add("DBMS_USER_CERTS");
        oracleSuppledPackages.add("DBMS_UTILITY");
        oracleSuppledPackages.add("DBMS_WARNING");
        oracleSuppledPackages.add("DBMS_WARNING_INTERNAL");
        oracleSuppledPackages.add("DBMS_WLM");
        oracleSuppledPackages.add("DBMS_WORKLOAD_CAPTURE");
        oracleSuppledPackages.add("DBMS_WORKLOAD_CAPTURE_I");
        oracleSuppledPackages.add("DBMS_WORKLOAD_REPLAY");
        oracleSuppledPackages.add("DBMS_WORKLOAD_REPLAY_I");
        oracleSuppledPackages.add("DBMS_WORKLOAD_REPOSITORY");
        oracleSuppledPackages.add("DBMS_WRR_INTERNAL");
        oracleSuppledPackages.add("DBMS_WRR_PROTECTED");
        oracleSuppledPackages.add("DBMS_WRR_REPORT");
        oracleSuppledPackages.add("DBMS_WRR_STATE");
        oracleSuppledPackages.add("DBMS_XA");
        oracleSuppledPackages.add("DBMS_XDB");
        oracleSuppledPackages.add("DBMS_XDBNFS");
        oracleSuppledPackages.add("DBMS_XDBREPOS");
        oracleSuppledPackages.add("DBMS_XDBRESOURCE");
        oracleSuppledPackages.add("DBMS_XDBT");
        oracleSuppledPackages.add("DBMS_XDBUTIL_INT");
        oracleSuppledPackages.add("DBMS_XDBZ");
        oracleSuppledPackages.add("DBMS_XDBZ0");
        oracleSuppledPackages.add("DBMS_XDB_ADMIN");
        oracleSuppledPackages.add("DBMS_XDB_CONFIG");
        oracleSuppledPackages.add("DBMS_XDB_CONSTANTS");
        oracleSuppledPackages.add("DBMS_XDB_CONTENT");
        oracleSuppledPackages.add("DBMS_XDB_PRINT");
        oracleSuppledPackages.add("DBMS_XDB_REPOS");
        oracleSuppledPackages.add("DBMS_XDB_UTIL");
        oracleSuppledPackages.add("DBMS_XDB_VERSION");
        oracleSuppledPackages.add("DBMS_XDS");
        oracleSuppledPackages.add("DBMS_XDS_INT");
        oracleSuppledPackages.add("DBMS_XEVENT");
        oracleSuppledPackages.add("DBMS_XLSB");
        oracleSuppledPackages.add("DBMS_XMLDOM");
        oracleSuppledPackages.add("DBMS_XMLDOM_ICD");
        oracleSuppledPackages.add("DBMS_XMLGEN");
        oracleSuppledPackages.add("DBMS_XMLINDEX");
        oracleSuppledPackages.add("DBMS_XMLINDEX0");
        oracleSuppledPackages.add("DBMS_XMLPARSER");
        oracleSuppledPackages.add("DBMS_XMLQUERY");
        oracleSuppledPackages.add("DBMS_XMLSAVE");
        oracleSuppledPackages.add("DBMS_XMLSCHEMA");
        oracleSuppledPackages.add("DBMS_XMLSCHEMA_ANNOTATE");
        oracleSuppledPackages.add("DBMS_XMLSCHEMA_INT");
        oracleSuppledPackages.add("DBMS_XMLSCHEMA_LSB");
        oracleSuppledPackages.add("DBMS_XMLSCHEMA_UTIL");
        oracleSuppledPackages.add("DBMS_XMLSTORAGE_MANAGE");
        oracleSuppledPackages.add("DBMS_XMLSTORE");
        oracleSuppledPackages.add("DBMS_XMLTRANSLATIONS");
        oracleSuppledPackages.add("DBMS_XPLAN");
        oracleSuppledPackages.add("DBMS_XPLAN_INTERNAL");
        oracleSuppledPackages.add("DBMS_XQUERY");
        oracleSuppledPackages.add("DBMS_XQUERYINT");
        oracleSuppledPackages.add("DBMS_XRWMV");
        oracleSuppledPackages.add("DBMS_XSLPROCESSOR");
        oracleSuppledPackages.add("DBMS_XSTREAM_ADM");
        oracleSuppledPackages.add("DBMS_XSTREAM_ADM_INTERNAL");
        oracleSuppledPackages.add("DBMS_XSTREAM_ADM_UTL");
        oracleSuppledPackages.add("DBMS_XSTREAM_AUTH");
        oracleSuppledPackages.add("DBMS_XSTREAM_AUTH_IVK");
        oracleSuppledPackages.add("DBMS_XSTREAM_GG");
        oracleSuppledPackages.add("DBMS_XSTREAM_GG_ADM");
        oracleSuppledPackages.add("DBMS_XSTREAM_GG_INTERNAL");
        oracleSuppledPackages.add("DBMS_XSTREAM_UTL_IVK");
        oracleSuppledPackages.add("DBMS_XS_FIDM");
        oracleSuppledPackages.add("DBMS_XS_MTCACHE");
        oracleSuppledPackages.add("DBMS_XS_PRINCIPALS");
        oracleSuppledPackages.add("DBMS_XS_SESSIONS");
        oracleSuppledPackages.add("DBMS_XS_SESSIONS_FFI");
        oracleSuppledPackages.add("DBMS_XS_SIDP");
        oracleSuppledPackages.add("DBMS_XS_SYSTEM");
        oracleSuppledPackages.add("DBMS_XS_SYSTEM_FFI");
        oracleSuppledPackages.add("DBMS_ZHELP");
        oracleSuppledPackages.add("DBMS_ZHELP_IR");
        oracleSuppledPackages.add("DIANA");
        oracleSuppledPackages.add("DIUTIL");
        oracleSuppledPackages.add("DMP_SEC");
        oracleSuppledPackages.add("DMP_SYS");
        oracleSuppledPackages.add("DM_QGEN");
        oracleSuppledPackages.add("DM_XFORM");
        oracleSuppledPackages.add("DRIACC");
        oracleSuppledPackages.add("DRIACCHELP");
        oracleSuppledPackages.add("DRICON");
        oracleSuppledPackages.add("DRIDISP");
        oracleSuppledPackages.add("DRIDML");
        oracleSuppledPackages.add("DRIDOC");
        oracleSuppledPackages.add("DRIENT");
        oracleSuppledPackages.add("DRIENTL");
        oracleSuppledPackages.add("DRIERR");
        oracleSuppledPackages.add("DRIEXP");
        oracleSuppledPackages.add("DRIFEAT");
        oracleSuppledPackages.add("DRIG");
        oracleSuppledPackages.add("DRIIMP");
        oracleSuppledPackages.add("DRIIXS");
        oracleSuppledPackages.add("DRILIST");
        oracleSuppledPackages.add("DRILOAD");
        oracleSuppledPackages.add("DRIMLX");
        oracleSuppledPackages.add("DRIOBJ");
        oracleSuppledPackages.add("DRIOPT");
        oracleSuppledPackages.add("DRIPARSE");
        oracleSuppledPackages.add("DRIPARX");
        oracleSuppledPackages.add("DRIPREF");
        oracleSuppledPackages.add("DRIREC");
        oracleSuppledPackages.add("DRIREP");
        oracleSuppledPackages.add("DRIREPM");
        oracleSuppledPackages.add("DRIREPZ");
        oracleSuppledPackages.add("DRIRIO");
        oracleSuppledPackages.add("DRISCORE");
        oracleSuppledPackages.add("DRISCORR");
        oracleSuppledPackages.add("DRISGP");
        oracleSuppledPackages.add("DRISPL");
        oracleSuppledPackages.add("DRITHS");
        oracleSuppledPackages.add("DRITHSC");
        oracleSuppledPackages.add("DRITHSD");
        oracleSuppledPackages.add("DRITHSL");
        oracleSuppledPackages.add("DRITHSX");
        oracleSuppledPackages.add("DRIUTL");
        oracleSuppledPackages.add("DRIVAL");
        oracleSuppledPackages.add("DRIXMD");
        oracleSuppledPackages.add("DRUE");
        oracleSuppledPackages.add("DRV0DDL");
        oracleSuppledPackages.add("DRVANL");
        oracleSuppledPackages.add("DRVDDL");
        oracleSuppledPackages.add("DRVDDLC");
        oracleSuppledPackages.add("DRVDDLR");
        oracleSuppledPackages.add("DRVDDLX");
        oracleSuppledPackages.add("DRVDISP");
        oracleSuppledPackages.add("DRVDML");
        oracleSuppledPackages.add("DRVDOC");
        oracleSuppledPackages.add("DRVEXT");
        oracleSuppledPackages.add("DRVIMR");
        oracleSuppledPackages.add("DRVLSB");
        oracleSuppledPackages.add("DRVODM");
        oracleSuppledPackages.add("DRVPARX");
        oracleSuppledPackages.add("DRVRIO");
        oracleSuppledPackages.add("DRVTMT");
        oracleSuppledPackages.add("DRVUTL");
        oracleSuppledPackages.add("DRVXMD");
        oracleSuppledPackages.add("DRVXTAB");
        oracleSuppledPackages.add("DRVXTABC");
        oracleSuppledPackages.add("DRVXTABR");
        oracleSuppledPackages.add("DRVXTABX");
        oracleSuppledPackages.add("DR_DEF");
        oracleSuppledPackages.add("GENCONNECTIONINTERFACE");
        oracleSuppledPackages.add("GENCURSORMANAGERINTERFACE");
        oracleSuppledPackages.add("GENDATABASEINTERFACE");
        oracleSuppledPackages.add("GENDATAPROVIDERINTERFACE");
        oracleSuppledPackages.add("GENDATATYPEIDCONSTANTS");
        oracleSuppledPackages.add("GENDEFINITIONMANAGERINTERFACE");
        oracleSuppledPackages.add("GENMDMCLASSCONSTANTS");
        oracleSuppledPackages.add("GENMDMOBJECTIDCONSTANTS");
        oracleSuppledPackages.add("GENMDMPROPERTYIDCONSTANTS");
        oracleSuppledPackages.add("GENMETADATAPROVIDERINTERFACE");
        oracleSuppledPackages.add("GENSERVERINTERFACE");
        oracleSuppledPackages.add("HM_SQLTK_INTERNAL");
        oracleSuppledPackages.add("HTF");
        oracleSuppledPackages.add("HTP");
        oracleSuppledPackages.add("INITJVMAUX");
        oracleSuppledPackages.add("JAVAVM_SYS");
        oracleSuppledPackages.add("JAVA_XA");
        oracleSuppledPackages.add("JVMFCB");
        oracleSuppledPackages.add("JVMRJBC");
        oracleSuppledPackages.add("JVMRJBCINV");
        oracleSuppledPackages.add("KUBSAGT");
        oracleSuppledPackages.add("KUPCC");
        oracleSuppledPackages.add("LBAC_CACHE");
        oracleSuppledPackages.add("LBAC_ERROR");
        oracleSuppledPackages.add("LBAC_ERRORS");
        oracleSuppledPackages.add("LBAC_EVENTS");
        oracleSuppledPackages.add("LBAC_EXP");
        oracleSuppledPackages.add("LBAC_LGSTNDBY_UTIL");
        oracleSuppledPackages.add("LBAC_POLICY_ADMIN");
        oracleSuppledPackages.add("LBAC_POLICY_ADMIN_INT");
        oracleSuppledPackages.add("LBAC_RLS");
        oracleSuppledPackages.add("LBAC_SERVICES");
        oracleSuppledPackages.add("LBAC_SESSION");
        oracleSuppledPackages.add("LBAC_STANDARD");
        oracleSuppledPackages.add("LBAC_SYSDBA");
        oracleSuppledPackages.add("LBAC_UTL");
        oracleSuppledPackages.add("LOGMNR_DICT_CACHE");
        oracleSuppledPackages.add("LOGMNR_EM_SUPPORT");
        oracleSuppledPackages.add("LOGSTDBY_INTERNAL");
        oracleSuppledPackages.add("LT");
        oracleSuppledPackages.add("LTADM");
        oracleSuppledPackages.add("LTAQ");
        oracleSuppledPackages.add("LTDDL");
        oracleSuppledPackages.add("LTDEFINER");
        oracleSuppledPackages.add("LTDTRG");
        oracleSuppledPackages.add("LTI");
        oracleSuppledPackages.add("LTPRIV");
        oracleSuppledPackages.add("LTRIC");
        oracleSuppledPackages.add("LTUTIL");
        oracleSuppledPackages.add("LT_CTX_PKG");
        oracleSuppledPackages.add("LT_EXPORT_PKG");
        oracleSuppledPackages.add("MD");
        oracleSuppledPackages.add("MD1");
        oracleSuppledPackages.add("MD2");
        oracleSuppledPackages.add("MDERR");
        oracleSuppledPackages.add("MDPRVT_FEATURE");
        oracleSuppledPackages.add("MDPRVT_GMD");
        oracleSuppledPackages.add("MDPRVT_IDX");
        oracleSuppledPackages.add("MDPRVT_SRID");
        oracleSuppledPackages.add("MD_LRS");
        oracleSuppledPackages.add("MD_NET");
        oracleSuppledPackages.add("MD_NFE");
        oracleSuppledPackages.add("ODCICONST");
        oracleSuppledPackages.add("ODM_MODEL_UTIL");
        oracleSuppledPackages.add("ODM_UTIL");
        oracleSuppledPackages.add("OJDS_CONTEXT");
        oracleSuppledPackages.add("OJDS_NAMESPACE");
        oracleSuppledPackages.add("OLS_ENFORCEMENT");
        oracleSuppledPackages.add("OLS_UTIL_WRAPPER");
        oracleSuppledPackages.add("OPG_APIS");
        oracleSuppledPackages.add("OPG_CTX");
        oracleSuppledPackages.add("OPG_CTX_SESSION");
        oracleSuppledPackages.add("OPG_GRAPHOP");
        oracleSuppledPackages.add("OPG_LOG");
        oracleSuppledPackages.add("OPG_METRICS");
        oracleSuppledPackages.add("OPG_PATH");
        oracleSuppledPackages.add("OPG_RANK");
        oracleSuppledPackages.add("OPG_UTL");
        oracleSuppledPackages.add("ORA_DM_REFCUR_PKG");
        oracleSuppledPackages.add("OUTLN_PKG");
        oracleSuppledPackages.add("OUTLN_PKG_INTERNAL");
        oracleSuppledPackages.add("OWA");
        oracleSuppledPackages.add("OWA_CACHE");
        oracleSuppledPackages.add("OWA_COOKIE");
        oracleSuppledPackages.add("OWA_CUSTOM");
        oracleSuppledPackages.add("OWA_CX");
        oracleSuppledPackages.add("OWA_IMAGE");
        oracleSuppledPackages.add("OWA_MATCH");
        oracleSuppledPackages.add("OWA_OPT_LOCK");
        oracleSuppledPackages.add("OWA_PATTERN");
        oracleSuppledPackages.add("OWA_SEC");
        oracleSuppledPackages.add("OWA_TEXT");
        oracleSuppledPackages.add("OWA_UTIL");
        oracleSuppledPackages.add("OWM_ASSERT_PKG");
        oracleSuppledPackages.add("OWM_BULK_LOAD_PKG");
        oracleSuppledPackages.add("OWM_CPKG_PKG");
        oracleSuppledPackages.add("OWM_DDL_PKG");
        oracleSuppledPackages.add("OWM_DML_PKG");
        oracleSuppledPackages.add("OWM_DYNSQL_ACCESS");
        oracleSuppledPackages.add("OWM_IEXP_PKG");
        oracleSuppledPackages.add("OWM_MIG_PKG");
        oracleSuppledPackages.add("OWM_MP_PKG");
        oracleSuppledPackages.add("OWM_VSCRIPT_PKG");
        oracleSuppledPackages.add("OWM_VT_PKG");
        oracleSuppledPackages.add("PBREAK");
        oracleSuppledPackages.add("PBRPH");
        oracleSuppledPackages.add("PBSDE");
        oracleSuppledPackages.add("PBUTL");
        oracleSuppledPackages.add("PIDL");
        oracleSuppledPackages.add("PLITBLM");
        oracleSuppledPackages.add("PRIVATE_JDBC");
        oracleSuppledPackages.add("PRIVATE_JDBC_DR");
        oracleSuppledPackages.add("PRVTEMX_ADMIN");
        oracleSuppledPackages.add("PRVTEMX_CELL");
        oracleSuppledPackages.add("PRVTEMX_DBHOME");
        oracleSuppledPackages.add("PRVTEMX_MEMORY");
        oracleSuppledPackages.add("PRVTEMX_PERF");
        oracleSuppledPackages.add("PRVTEMX_RSRCMGR");
        oracleSuppledPackages.add("PRVTEMX_SQL");
        oracleSuppledPackages.add("PRVTPARENTCHILD");
        oracleSuppledPackages.add("PRVTPC");
        oracleSuppledPackages.add("PRVTTNPC");
        oracleSuppledPackages.add("PRVT_ACCESS_ADVISOR");
        oracleSuppledPackages.add("PRVT_ADVISOR");
        oracleSuppledPackages.add("PRVT_ASH_OMX");
        oracleSuppledPackages.add("PRVT_AWR_DATA");
        oracleSuppledPackages.add("PRVT_AWR_DATA_CP");
        oracleSuppledPackages.add("PRVT_AWR_VIEWER");
        oracleSuppledPackages.add("PRVT_COMPRESS");
        oracleSuppledPackages.add("PRVT_COMPRESSION");
        oracleSuppledPackages.add("PRVT_CPADDM");
        oracleSuppledPackages.add("PRVT_DBMS_INMEMORY_ADMIN");
        oracleSuppledPackages.add("PRVT_DBMS_MANAGE_XMLSTORAGE");
        oracleSuppledPackages.add("PRVT_DIMENSION_SYS_UTIL");
        oracleSuppledPackages.add("PRVT_EMX");
        oracleSuppledPackages.add("PRVT_HDM");
        oracleSuppledPackages.add("PRVT_IDX");
        oracleSuppledPackages.add("PRVT_ILM");
        oracleSuppledPackages.add("PRVT_ILM_INVOKERS_RIGHTS");
        oracleSuppledPackages.add("PRVT_PARTREC_NOPRIV");
        oracleSuppledPackages.add("PRVT_PC");
        oracleSuppledPackages.add("PRVT_REPORT_REGISTRY");
        oracleSuppledPackages.add("PRVT_REPORT_TAGS");
        oracleSuppledPackages.add("PRVT_RTADDM");
        oracleSuppledPackages.add("PRVT_SAM");
        oracleSuppledPackages.add("PRVT_SMGUTIL");
        oracleSuppledPackages.add("PRVT_SQLADV_INFRA");
        oracleSuppledPackages.add("PRVT_SQLPA");
        oracleSuppledPackages.add("PRVT_SQLPROF_INFRA");
        oracleSuppledPackages.add("PRVT_SQLSET_INFRA");
        oracleSuppledPackages.add("PRVT_SYS_TUNE_MVIEW");
        oracleSuppledPackages.add("PRVT_TIN");
        oracleSuppledPackages.add("PRVT_TUNE_MVIEW");
        oracleSuppledPackages.add("PRVT_UADV");
        oracleSuppledPackages.add("PRVT_UTILITY");
        oracleSuppledPackages.add("PRVT_WORKLOAD");
        oracleSuppledPackages.add("PRVT_WORKLOAD_NOPRIV");
        oracleSuppledPackages.add("PSTDY_DATAPUMP_SUPPORT");
        oracleSuppledPackages.add("RDF_APIS");
        oracleSuppledPackages.add("RDF_APIS_INTERNAL");
        oracleSuppledPackages.add("RDF_APIS_OPER_INTERNAL");
        oracleSuppledPackages.add("RDF_APIS_USER");
        oracleSuppledPackages.add("RMJVM");
        oracleSuppledPackages.add("RTREE_IDX");
        oracleSuppledPackages.add("SA_AUDIT_ADMIN");
        oracleSuppledPackages.add("SA_COMPONENTS");
        oracleSuppledPackages.add("SA_LABEL_ADMIN");
        oracleSuppledPackages.add("SA_SESSION");
        oracleSuppledPackages.add("SA_SYSDBA");
        oracleSuppledPackages.add("SA_USER_ADMIN");
        oracleSuppledPackages.add("SA_USER_ADMIN_INT");
        oracleSuppledPackages.add("SA_UTL");
        oracleSuppledPackages.add("SDO");
        oracleSuppledPackages.add("SDOCURPKG");
        oracleSuppledPackages.add("SDOTNPC");
        oracleSuppledPackages.add("SDO_3GL");
        oracleSuppledPackages.add("SDO_ADMIN");
        oracleSuppledPackages.add("SDO_AGGR");
        oracleSuppledPackages.add("SDO_CATALOG");
        oracleSuppledPackages.add("SDO_CS");
        oracleSuppledPackages.add("SDO_CSW");
        oracleSuppledPackages.add("SDO_CSWADM");
        oracleSuppledPackages.add("SDO_CSW_INT");
        oracleSuppledPackages.add("SDO_CSW_SQ");
        oracleSuppledPackages.add("SDO_GCDR");
        oracleSuppledPackages.add("SDO_GEOM");
        oracleSuppledPackages.add("SDO_GEOR");
        oracleSuppledPackages.add("SDO_GEORX");
        oracleSuppledPackages.add("SDO_GEOR_ADMIN");
        oracleSuppledPackages.add("SDO_GEOR_AGGR");
        oracleSuppledPackages.add("SDO_GEOR_AUX");
        oracleSuppledPackages.add("SDO_GEOR_DEF");
        oracleSuppledPackages.add("SDO_GEOR_GDAL");
        oracleSuppledPackages.add("SDO_GEOR_INT");
        oracleSuppledPackages.add("SDO_GEOR_IP");
        oracleSuppledPackages.add("SDO_GEOR_RA");
        oracleSuppledPackages.add("SDO_GEOR_UTL");
        oracleSuppledPackages.add("SDO_IDX");
        oracleSuppledPackages.add("SDO_JAVA_STP");
        oracleSuppledPackages.add("SDO_LRS");
        oracleSuppledPackages.add("SDO_MEMORY");
        oracleSuppledPackages.add("SDO_META");
        oracleSuppledPackages.add("SDO_META_USER");
        oracleSuppledPackages.add("SDO_MIGRATE");
        oracleSuppledPackages.add("SDO_NDM_TRAFFIC");
        oracleSuppledPackages.add("SDO_NET");
        oracleSuppledPackages.add("SDO_NET_MEM");
        oracleSuppledPackages.add("SDO_NET_PARTITION");
        oracleSuppledPackages.add("SDO_NFE");
        oracleSuppledPackages.add("SDO_OBJ_TRACING");
        oracleSuppledPackages.add("SDO_OLS");
        oracleSuppledPackages.add("SDO_OLS_DIRECTORY");
        oracleSuppledPackages.add("SDO_OLS_LOCUTL");
        oracleSuppledPackages.add("SDO_OLS_PRESENTATION");
        oracleSuppledPackages.add("SDO_OLS_ROUTE");
        oracleSuppledPackages.add("SDO_PC_PKG");
        oracleSuppledPackages.add("SDO_PRIDX");
        oracleSuppledPackages.add("SDO_RDF");
        oracleSuppledPackages.add("SDO_RDFTC");
        oracleSuppledPackages.add("SDO_RDF_EXP_IMP");
        oracleSuppledPackages.add("SDO_RDF_INTERNAL");
        oracleSuppledPackages.add("SDO_RDF_JAVA_STP");
        oracleSuppledPackages.add("SDO_RDF_MIG");
        oracleSuppledPackages.add("SDO_RDF_REL2RDF_INTERNAL");
        oracleSuppledPackages.add("SDO_RDF_SYS");
        oracleSuppledPackages.add("SDO_ROUTER_PARTITION");
        oracleSuppledPackages.add("SDO_ROUTER_TIMEZONE");
        oracleSuppledPackages.add("SDO_RTREE_ADMIN");
        oracleSuppledPackages.add("SDO_SAM");
        oracleSuppledPackages.add("SDO_SEM_CLI");
        oracleSuppledPackages.add("SDO_SEM_CONST");
        oracleSuppledPackages.add("SDO_SEM_CTX");
        oracleSuppledPackages.add("SDO_SEM_CTX_SESSION");
        oracleSuppledPackages.add("SDO_SEM_DOWNGRADE");
        oracleSuppledPackages.add("SDO_SEM_DOWNGRADE_UTL");
        oracleSuppledPackages.add("SDO_SEM_HTTP_CTX");
        oracleSuppledPackages.add("SDO_SEM_INFERENCE");
        oracleSuppledPackages.add("SDO_SEM_INFH");
        oracleSuppledPackages.add("SDO_SEM_INFI");
        oracleSuppledPackages.add("SDO_SEM_INF_INTERNAL");
        oracleSuppledPackages.add("SDO_SEM_LOG");
        oracleSuppledPackages.add("SDO_SEM_OPERATOR");
        oracleSuppledPackages.add("SDO_SEM_PERF");
        oracleSuppledPackages.add("SDO_SEM_UPDATE_CTX");
        oracleSuppledPackages.add("SDO_SEM_UTL");
        oracleSuppledPackages.add("SDO_SEM_VALIDATE");
        oracleSuppledPackages.add("SDO_TIN_PKG");
        oracleSuppledPackages.add("SDO_TOPO");
        oracleSuppledPackages.add("SDO_TOPO_MAP");
        oracleSuppledPackages.add("SDO_TOPO_METADATA");
        oracleSuppledPackages.add("SDO_TOPO_METADATA_INT");
        oracleSuppledPackages.add("SDO_TPFNS");
        oracleSuppledPackages.add("SDO_TPIDX");
        oracleSuppledPackages.add("SDO_TRKR");
        oracleSuppledPackages.add("SDO_TUNE");
        oracleSuppledPackages.add("SDO_UTIL");
        oracleSuppledPackages.add("SDO_WCS");
        oracleSuppledPackages.add("SDO_WFS_LOCK");
        oracleSuppledPackages.add("SDO_WFS_LOCK_GEN");
        oracleSuppledPackages.add("SDO_WFS_LOCK_UTIL");
        oracleSuppledPackages.add("SDO_WFS_PROCESS");
        oracleSuppledPackages.add("SDO_WFS_PROCESS_UTIL");
        oracleSuppledPackages.add("SDO_WS_PROCESS");
        oracleSuppledPackages.add("SEM_OLS");
        oracleSuppledPackages.add("SEM_OLS_DR");
        oracleSuppledPackages.add("SEM_RDFCTX");
        oracleSuppledPackages.add("SEM_RDFCTX_DR");
        oracleSuppledPackages.add("SEM_RDFCTX_IR");
        oracleSuppledPackages.add("SEM_RDFCTX_OPER");
        oracleSuppledPackages.add("SEM_RDFSA");
        oracleSuppledPackages.add("SEM_RDFSA_CONST");
        oracleSuppledPackages.add("SEM_RDFSA_CONST_INTERNAL");
        oracleSuppledPackages.add("SEM_RDFSA_DR");
        oracleSuppledPackages.add("SEM_RDFSA_IR");
        oracleSuppledPackages.add("SEM_RDFSA_PRIV");
        oracleSuppledPackages.add("SEM_UPGRADE_TO_11");
        oracleSuppledPackages.add("SQLJUTL");
        oracleSuppledPackages.add("STANDARD");
        oracleSuppledPackages.add("SYS_STUB_FOR_PURITY_ANALYSIS");
        oracleSuppledPackages.add("S_SDO_RDF_INFO");
        oracleSuppledPackages.add("S_SDO_RDF_INTERNAL");
        oracleSuppledPackages.add("S_SDO_RDF_QUERY");
        oracleSuppledPackages.add("S_SEM_OLS_DR");
        oracleSuppledPackages.add("S_SEM_RDFCTX_DR");
        oracleSuppledPackages.add("S_SEM_RDFSA_DR");
        oracleSuppledPackages.add("S_SEM_RDFSA_PRIV");
        oracleSuppledPackages.add("TO_LABEL_LIST");
        oracleSuppledPackages.add("TRANSFORM_MAP");
        oracleSuppledPackages.add("UD_TRIGS");
        oracleSuppledPackages.add("URIFACTORY");
        oracleSuppledPackages.add("UTL_CALL_STACK");
        oracleSuppledPackages.add("UTL_COLL");
        oracleSuppledPackages.add("UTL_COMPRESS");
        oracleSuppledPackages.add("UTL_ENCODE");
        oracleSuppledPackages.add("UTL_FILE");
        oracleSuppledPackages.add("UTL_GDK");
        oracleSuppledPackages.add("UTL_HTTP");
        oracleSuppledPackages.add("UTL_I18N");
        oracleSuppledPackages.add("UTL_IDENT");
        oracleSuppledPackages.add("UTL_INADDR");
        oracleSuppledPackages.add("UTL_LMS");
        oracleSuppledPackages.add("UTL_MATCH");
        oracleSuppledPackages.add("UTL_NLA");
        oracleSuppledPackages.add("UTL_RAW");
        oracleSuppledPackages.add("UTL_RECOMP");
        oracleSuppledPackages.add("UTL_REF");
        oracleSuppledPackages.add("UTL_SMTP");
        oracleSuppledPackages.add("UTL_SYS_COMPRESS");
        oracleSuppledPackages.add("UTL_TCP");
        oracleSuppledPackages.add("UTL_URL");
        oracleSuppledPackages.add("UTL_XML");
        oracleSuppledPackages.add("WM_DDL_UTIL");
        oracleSuppledPackages.add("WM_ERROR");
        oracleSuppledPackages.add("WPG_DOCLOAD");
        oracleSuppledPackages.add("WPIUTL");
        oracleSuppledPackages.add("WWV_DBMS_SQL_APEX_230100");
        oracleSuppledPackages.add("WWV_FLOW_KEY");
        oracleSuppledPackages.add("WWV_FLOW_VAL");
        oracleSuppledPackages.add("WWV_UTIL_APEX_230100");
        oracleSuppledPackages.add("W_SDO_RDF_ALL");
        oracleSuppledPackages.add("W_SEM_RDFCTX_ALL");
        oracleSuppledPackages.add("W_SEM_RDFSA_ALL");
        oracleSuppledPackages.add("XDBPI_FUNCIMPL");
        oracleSuppledPackages.add("XDB_ANCOP");
        oracleSuppledPackages.add("XDB_DLTRIG_PKG");
        oracleSuppledPackages.add("XDB_FUNCIMPL");
        oracleSuppledPackages.add("XDB_PITRIG_PKG");
        oracleSuppledPackages.add("XDB_PITRIG_PKG_01");
        oracleSuppledPackages.add("XDB_PVTRIG_PKG");
        oracleSuppledPackages.add("XDB_RVTRIG_PKG");
        oracleSuppledPackages.add("XIMETADATA_PKG");
        oracleSuppledPackages.add("XMLINDEX_FUNCIMPL");
        oracleSuppledPackages.add("XML_SCHEMA_NAME_PRESENT");
        oracleSuppledPackages.add("XS_ACL");
        oracleSuppledPackages.add("XS_ACL_INT");
        oracleSuppledPackages.add("XS_ADMIN_INT");
        oracleSuppledPackages.add("XS_ADMIN_UTIL");
        oracleSuppledPackages.add("XS_ADMIN_UTIL_INT");
        oracleSuppledPackages.add("XS_DATA_SECURITY");
        oracleSuppledPackages.add("XS_DATA_SECURITY_INT");
        oracleSuppledPackages.add("XS_DATA_SECURITY_UTIL");
        oracleSuppledPackages.add("XS_DATA_SECURITY_UTIL_INT");
        oracleSuppledPackages.add("XS_DIAG");
        oracleSuppledPackages.add("XS_DIAG_INT");
        oracleSuppledPackages.add("XS_MTCACHE_INT");
        oracleSuppledPackages.add("XS_NAMESPACE");
        oracleSuppledPackages.add("XS_NAMESPACE_INT");
        oracleSuppledPackages.add("XS_PRINCIPAL");
        oracleSuppledPackages.add("XS_PRINCIPAL_INT");
        oracleSuppledPackages.add("XS_ROLESET");
        oracleSuppledPackages.add("XS_ROLESET_INT");
        oracleSuppledPackages.add("XS_SECURITY_CLASS");
        oracleSuppledPackages.add("XS_SECURITY_CLASS_INT");
    }
}

