/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.sqlcl.commands.dg;

import java.util.Hashtable;
import oracle.dbtools.sqlcl.commands.dg.DgConfigInst;
import oracle.dbtools.sqlcl.commands.dg.DgUtils;

public class DgConfigMember {
    public int memberID;
    public String name;
    public String istate;
    public String connStr;
    public boolean clsr;
    public boolean enabled;
    public int fsfoValidity;
    public int role;
    public String displayName;
    public String receiveFrom;
    public String shipTo;
    public String dgbcid;
    public String sci;
    public String severity;
    public String status_message;
    public String status;
    public int errnum;
    public int errtime;
    public Hashtable<Integer, DgConfigInst> instMap = new Hashtable();

    public void addInst(DgConfigInst inst) {
        assert (inst.instID > 0);
        this.instMap.put(inst.instID, inst);
    }

    public DgConfigInst getInst(int instID) {
        return this.instMap.get(instID);
    }

    public void addAttribute(int ojbid, String attr, String value, String status, int errnum, int errtime) {
        if (attr.equalsIgnoreCase("SITE")) {
            this.name = value;
        } else if (attr.equalsIgnoreCase("DATABASE")) {
            this.name = value;
            this.status = status;
            this.errnum = errnum;
            this.errtime = errtime;
        } else if (attr.equalsIgnoreCase("INTENDED_STATE")) {
            this.istate = value;
        } else if (attr.equalsIgnoreCase("connect_string")) {
            this.connStr = value;
        } else if (attr.equalsIgnoreCase("RAC")) {
            this.clsr = DgUtils.parseYes(value);
        } else if (attr.equalsIgnoreCase("CLSR")) {
            this.clsr = DgUtils.parseYes(value);
        } else if (attr.equalsIgnoreCase("ENABLED")) {
            this.enabled = DgUtils.parseYes(value);
        } else if (attr.equalsIgnoreCase("ROLE")) {
            if ("PRIMARY".equalsIgnoreCase(value)) {
                this.role = 1;
            } else if ("PHYSICAL".equalsIgnoreCase(value)) {
                this.role = 2;
            } else if ("LOGICAL".equalsIgnoreCase(value)) {
                this.role = 3;
            } else if ("SNAPSHOT".equalsIgnoreCase(value)) {
                this.role = 4;
            } else if ("FAR_SYNC_INSTANCE".equalsIgnoreCase(value)) {
                this.role = 5;
            } else if ("RECOVERY_APPLIANCE".equalsIgnoreCase(value)) {
                this.role = 6;
            } else if ("REMOTE_CONFIGURATION".equalsIgnoreCase(value)) {
                this.role = 7;
            } else if ("PLUGGABLE_DATABASE".equalsIgnoreCase(value)) {
                this.role = 8;
            }
        } else if (attr.equalsIgnoreCase("DBDISPLAYNAME")) {
            this.displayName = value;
        } else if (attr.equalsIgnoreCase("ReceiveFrom")) {
            this.receiveFrom = value;
        } else if (attr.equalsIgnoreCase("ship_to")) {
            this.shipTo = value;
        } else if (attr.equalsIgnoreCase("dgb_connect")) {
            this.dgbcid = value;
        } else if (attr.equalsIgnoreCase("static_connect_identifier")) {
            this.sci = value;
        } else if (attr.equalsIgnoreCase("FSFOTargetValidity")) {
            this.fsfoValidity = Integer.valueOf(value);
        }
    }
}

