/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangManifest;
import oracle.apexlang.core.Component;

public class Transpiler {
    public static final String PLSQL_PLACEHOLDER_PARAMETERS = "%parameters%";
    public static final String PLSQL_PLACEHOLDER_VALUE = ":value";
    public static final String PLSQL_PLACEHOLDER_PARENT_EXTERNAL_IDENTIFICATION = ":parent_identifier";
    public static final String PLSQL_PLACEHOLDER_GRAND_PARENT_EXTERNAL_IDENTIFICATION = ":grandparent_identifier";
    public static final String PLSQL_PLACEHOLDER_GREAT_GRAND_PARENT_EXTERNAL_IDENTIFICATION = ":great_grandparent_identifier";
    public static final String PLSQL_PLACEHOLDER_GREAT_GREAT_GRAND_PARENT_EXTERNAL_IDENTIFICATION = ":great_great_grandparent_identifier";
    public static final String PLSQL_PLACEHOLDER_IS_CENTRAL = ":is_central";
    public static final String PLSQL_PLACEHOLDER_REF_APP_ID = ":ref_app_id";
    public static final String PLSQL_PLACEHOLDER_IS_NOT = ":is_not";
    public static final String PLSQL_PLACEHOLDER_EXTERNAL_IDENTIFIER = ":external_identifier";
    public static final String PLSQL_PLACEHOLDER_API_VERSION = ":api_version";
    public static final String PLSQL_PLACEHOLDER_APEX_VERSION = ":apex_version";
    public static final String PLSQL_PLACEHOLDER_WORKSPACE_ID = ":workspace_id";
    public static final String PLSQL_PLACEHOLDER_APP_ID = ":app_id";
    public static final String PLSQL_PLACEHOLDER_DEFAULT_ID_OFFSET = ":default_id_offset";
    public static final String PLSQL_PLACEHOLDER_DEFAULT_OWNER = ":default_owner";
    public static final String PLSQL_PLACEHOLDER_CENTRAL_THEME_APP_ID = ":central_theme_app_id";
    public static final String PLSQL_PLACEHOLDER_CURRENT_THEME_ID = ":current_theme_id";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_ATTR_EXPRESSION = ":plugin_attribute_expression";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_ATTR_STATIC_ID = ":plugin_attribute_static_id";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE = "wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table; \n";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE_HEX_VALUE = ":hexValue";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE_INDEX_VALUE = ":index";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_VARIABLE_VALUE = "wwv_flow_imp.g_varchar2_table(:index) := ':hexValue';\n";
    public static final String PLSQL_PLACEHOLDER_EXT_FILE_PARAM_VALUE = "wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)";
    public static final String PLSQL_PLACEHOLDER_PLUGIN_EXT_IDENTIFIER = ":plugin_external_identifier";
    public static final String PLSQL_PLACEHOLDER_TODATE_DATE_VALUE = ":dateValue";
    public static final String PLSQL_PLACEHOLDER_TODATE_FORMAT = "to_date(':dateValue', 'YYYY-MM-DD\"T\"HH24:MI:SS')";
    static final String COMPONENT_ID_APPLICATION = "1000";
    static final String PARAMETER_ATTRIBUTE_THEME = "263";

    public static String replaceAllSafely(String template, String bindVariable, String replacement) {
        String result = String.join((CharSequence)replacement, (template + " ").split(bindVariable));
        return result.substring(0, result.length() - 1);
    }

    public static String transpile(List<Component> componentsParsed, APEXLangManifest manifest, APEXLangCompilerContext appCtx) {
        Object result = "set define off verify off feedback off\nwhenever sqlerror exit sql.sqlcode rollback\n\n";
        String centralThemeAppId = appCtx.getCentralThemeAppId() != null && !appCtx.getCentralThemeAppId().equals("") ? appCtx.getCentralThemeAppId() : "null";
        String currentThemeId = appCtx.getCurrentTheme();
        result = (String)result + "\nbegin\n" + manifest.getImportPlSQL(centralThemeAppId) + "end;\n/\n";
        for (Component currentComponent : Transpiler.sortedComponents(componentsParsed)) {
            result = (String)result + "\nbegin\n" + currentComponent.generatePlSQLCode() + "end;\n/\n";
        }
        result = (String)result + "\nbegin\n" + manifest.getEndPlSQL() + "end;\n/\n";
        result = Transpiler.replaceAllSafely((String)result, PLSQL_PLACEHOLDER_CURRENT_THEME_ID, "'" + currentThemeId + "'");
        result = (String)result + "\nset verify on feedback on define on\n";
        return result;
    }

    public static Collection<Component> sortedComponents(Collection<Component> components) {
        HashMap<Component, List<Component>> nodeComponentMap = new HashMap<Component, List<Component>>();
        for (Component component : components) {
            Component parent = component.getParent();
            if (nodeComponentMap.get(parent) == null) {
                nodeComponentMap.put(parent, new ArrayList());
            }
            ((List)nodeComponentMap.get(parent)).add(component);
        }
        ArrayList<Component> sortedComponents = new ArrayList<Component>();
        Component cursor = null;
        Transpiler.traverseComponents(cursor, nodeComponentMap, sortedComponents);
        return sortedComponents;
    }

    public static void traverseComponents(Component cursor, Map<Component, List<Component>> nodeComponentMap, List<Component> sortedComponents) {
        List<Component> levelComponents = nodeComponentMap.get(cursor);
        if (levelComponents == null) {
            return;
        }
        Collections.sort(levelComponents);
        for (Component component : levelComponents) {
            sortedComponents.add(component);
            Transpiler.traverseComponents(component, nodeComponentMap, sortedComponents);
        }
    }
}

