/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import oracle.apexlang.core.APEXLangArrayDataType;
import oracle.apexlang.core.APEXLangBooleanDataType;
import oracle.apexlang.core.APEXLangCompilerUtils;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Group;
import oracle.apexlang.metametadata.LOV;
import oracle.apexlang.metametadata.LOVValue;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.Plugins;
import oracle.apexlang.metametadata.Property;

public class ComponentPlugin {
    private static final Logger LOGGER = Logger.getLogger(ComponentPlugin.class.getName());
    private List<CustomAttribute> customAttributes;
    private String internalName;
    private boolean nativePlugin;
    private boolean templatePlugin;
    private String pluginType;
    private Component plugin;
    private Set<String> features;
    private ComponentType.Feature[] conditionalFeatures;
    private Map<String, Component> actionTemplates;
    private Map<String, Component> actionPositions;
    private boolean isCentral;
    private Map<Component, List<Component>> allPluginsTreeGenealogy;
    private Set<String> allFeatures;

    public ComponentPlugin(Component plugin, ComponentType.Plugin.APIExpression apiExpression, Map<Component, List<Component>> allPluginsTreeGenealogy, Metametadata metametadata, boolean nativePlugin, String pluginType, String[] customAttributeScopes, boolean isCentral) {
        this.plugin = plugin;
        this.conditionalFeatures = metametadata.getComponentTypes().get(plugin.getTypeId()).getFeatures();
        this.features = this.getFeatures(plugin, metametadata);
        this.isCentral = isCentral;
        Plugins plugins = metametadata.getPlugins();
        this.internalName = this.getInternalName(plugin, metametadata);
        this.nativePlugin = nativePlugin;
        if (!plugin.getTypeId().equals(plugins.getComponentTypeId())) {
            return;
        }
        this.pluginType = pluginType;
        this.allPluginsTreeGenealogy = allPluginsTreeGenealogy;
        this.templatePlugin = this.pluginType.equals("TEMPLATE COMPONENT");
        List<Component> pluginComponentFirstGenChildren = allPluginsTreeGenealogy.get(plugin);
        if (pluginComponentFirstGenChildren == null) {
            pluginComponentFirstGenChildren = List.of();
        }
        this.actionTemplates = this.getActionTemplates(pluginComponentFirstGenChildren, metametadata);
        this.actionPositions = this.getActionPositions(pluginComponentFirstGenChildren, metametadata);
        List<String> customAttributesScopesList = Arrays.asList(customAttributeScopes != null ? customAttributeScopes : new String[]{});
        this.customAttributes = pluginComponentFirstGenChildren.stream().filter(component -> component.getTypeId().equals(plugins.getCustomAttributes().getComponentTypeId())).filter(component -> customAttributesScopesList.contains(ComponentPlugin.getScope(component, plugins))).map(customAttributeComponent -> this.createCustomAttributeFromComponent(plugins, metametadata, apiExpression, (Component)customAttributeComponent, allPluginsTreeGenealogy)).toList();
        this.allFeatures = new HashSet<String>();
        this.allFeatures.addAll(this.features);
        if (this.conditionalFeatures != null) {
            for (ComponentType.Feature conditional : this.conditionalFeatures) {
                if (!APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(plugin, conditional.getCondition(), metametadata)) continue;
                this.allFeatures.add(conditional.getName());
            }
        }
    }

    private Map<String, Component> getActionPositions(List<Component> pluginChildren, Metametadata metametadata) {
        HashMap<String, Component> actionPositions = new HashMap<String, Component>();
        String actionPositionComponentTypeId = metametadata.getPlugins().getActionPositions().getComponentTypeId();
        String actionPositionsNamePropertyId = metametadata.getPlugins().getActionPositions().getApexLangNamePropertyId();
        for (Component children : pluginChildren) {
            ComponentParameter actionPositionIdentifier;
            if (!children.getTypeId().equals(actionPositionComponentTypeId) || (actionPositionIdentifier = children.getParameters().get(actionPositionsNamePropertyId)) == null) continue;
            actionPositions.put(actionPositionIdentifier.getValue(), children);
        }
        return actionPositions;
    }

    public boolean isCentral() {
        return this.isCentral;
    }

    public Map<Component, List<Component>> getAllPluginsTreeGenealogy() {
        return this.allPluginsTreeGenealogy;
    }

    public Set<String> getFeaturesActionPosition(String actionPosition, Metametadata metametadata) {
        Component actionPositionComponent = this.actionPositions.get(actionPosition);
        if (actionPositionComponent != null) {
            return actionPositionComponent.getFeatures(metametadata);
        }
        return Set.of();
    }

    public Set<String> getFeaturesActionTemplates(String actionTemplate, Metametadata metametadata) {
        Component actionTemplateComponent = this.actionTemplates.get(actionTemplate);
        if (actionTemplateComponent != null) {
            return actionTemplateComponent.getFeatures(metametadata);
        }
        return Set.of();
    }

    private Map<String, Component> getActionTemplates(List<Component> pluginChildren, Metametadata metametadata) {
        HashMap<String, Component> actionTemplates = new HashMap<String, Component>();
        String actionTemplateComponentTypeId = metametadata.getPlugins().getActionTemplates().getComponentTypeId();
        String actionTemplatesNamePropertyId = metametadata.getPlugins().getActionTemplates().getApexLangNamePropertyId();
        for (Component children : pluginChildren) {
            ComponentParameter actionTemplateIdentifier;
            if (!children.getTypeId().equals(actionTemplateComponentTypeId) || (actionTemplateIdentifier = children.getParameters().get(actionTemplatesNamePropertyId)) == null) continue;
            actionTemplates.put(actionTemplateIdentifier.getValue(), children);
        }
        return actionTemplates;
    }

    public Component getPlugin() {
        return this.plugin;
    }

    public String getName() {
        if (this.nativePlugin) {
            return "NATIVE_" + this.internalName;
        }
        if (this.isTemplatePlugin()) {
            return "TMPL_" + this.internalName;
        }
        return "PLUGIN_" + this.internalName;
    }

    private String getInternalName(Component plugin, Metametadata metametadata) {
        ComponentParameter internalNameParameter = plugin.getParameters().get(metametadata.getPlugins().getInternalNamePropertyId());
        return internalNameParameter != null ? internalNameParameter.getValue() : "";
    }

    public Set<String> getActionTemplates() {
        return this.actionTemplates.keySet();
    }

    public Set<String> getActionPositions() {
        return this.actionPositions.keySet();
    }

    private Set<String> getFeatures(Component plugin, Metametadata metametadata) {
        Plugins plugins = metametadata.getPlugins();
        String[] stdAttributesPropertyIds = plugins.getStdAttributesPropertyIds();
        HashSet<String> featuresList = new HashSet<String>();
        for (String stdAttributePropertyId : stdAttributesPropertyIds) {
            ComponentParameter attributeParameter = plugin.getParameters().get(stdAttributePropertyId);
            if (attributeParameter == null) continue;
            if (attributeParameter.getData() instanceof APEXLangArrayDataType) {
                APEXLangDataType[] list;
                APEXLangArrayDataType dataArray = (APEXLangArrayDataType)attributeParameter.getData();
                for (APEXLangDataType data : list = dataArray.getData()) {
                    String value = data.toString();
                    featuresList.add(value);
                }
                continue;
            }
            String value = attributeParameter.getData().toString();
            featuresList.add(value);
        }
        return featuresList;
    }

    public String getPluginType() {
        return this.pluginType;
    }

    public Set<String> getFeatures(Metametadata metametadata) {
        return this.allFeatures;
    }

    private CustomAttribute createCustomAttributeFromComponent(Plugins plugins, Metametadata metametadata, ComponentType.Plugin.APIExpression apiExpression, Component customAttributeComponent, Map<Component, List<Component>> pluginsChildren) {
        String propertyTypePropertyId = plugins.getCustomAttributes().getTypePropertyId();
        ComponentParameter propertyTypeParameter = customAttributeComponent.getParameters().get(propertyTypePropertyId);
        String propertyId = propertyTypeParameter != null ? propertyTypeParameter.getValue() : "TEXT";
        Plugins.Template propertyTemplate = plugins.getCustomAttributes().getTemplates().get(propertyId);
        Integer attribute = this.getAttributeValueFromComponent(customAttributeComponent, plugins);
        String name = this.getNameValueFromComponent(customAttributeComponent, propertyTemplate);
        String helpText = "";
        String groupName = this.getGroupNameValueFromComponent(customAttributeComponent, propertyTemplate, metametadata);
        Property property = this.getPropertyValueFromComponent(customAttributeComponent, propertyTemplate, plugins, pluginsChildren);
        String staticId = this.getStaticIdValueFromComponent(customAttributeComponent, plugins);
        String attributeNo = "" + attribute;
        if (attributeNo.length() == 1) {
            attributeNo = "0" + attributeNo;
        }
        ComponentType.ApiParameter apiParameter = this.getApiParameter(staticId, attributeNo, propertyTemplate, apiExpression);
        ComponentType.ComponentProperty componentProperty = this.getComponentProperty(customAttributeComponent, propertyTemplate, groupName, apiParameter);
        String scope = ComponentPlugin.getScope(customAttributeComponent, plugins);
        return new CustomAttribute(attribute, name, "", groupName, property.getName(), staticId, property, componentProperty, scope);
    }

    private static String getScope(Component customAttributeComponent, Plugins plugins) {
        ComponentParameter scopeParameter = customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getScopePropertyId());
        String scope = scopeParameter != null ? scopeParameter.getValue() : "";
        return scope;
    }

    private ComponentType.ComponentProperty getComponentProperty(Component customAttributeComponent, Plugins.Template propertyTemplate, String groupName, ComponentType.ApiParameter apiParameter) {
        ComponentType.ComponentProperty componentProperty = new ComponentType.ComponentProperty();
        componentProperty.setIsRequired(this.isRequiredValueFromComponent(customAttributeComponent, propertyTemplate));
        componentProperty.setDefaultValue(this.getDefaultValueFromComponent(customAttributeComponent, propertyTemplate));
        componentProperty.setDependingOn(this.getDependingOnValueFromComponent(customAttributeComponent, propertyTemplate, groupName));
        componentProperty.setApiParameter(apiParameter);
        return componentProperty;
    }

    private ComponentType.DependingOn getDependingOnValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate, String groupName) {
        ArrayList<ComponentType.DependingOn> dependingOnList = new ArrayList<ComponentType.DependingOn>();
        for (Plugins.Template.ComponentProperty.ComponentPropertyDependingOn componentPropertyDependingOn : propertyTemplate.getComponentProperty().getDependingOn()) {
            ComponentParameter dependingOnPropertyId = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getId().getPropertyId());
            ComponentParameter dependingOnType = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getType().getPropertyId());
            ComponentParameter dependingOnValue = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getValue().getPropertyId());
            ComponentParameter dependingOnValues = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getValues().getPropertyId());
            ComponentParameter dependingOnHasToExist = customAttributeComponent.getParameters().get(componentPropertyDependingOn.getHasToExist().getPropertyId());
            if (dependingOnPropertyId == null) continue;
            ComponentType.DependingOn dependingOn = new ComponentType.DependingOn();
            dependingOn.setPropertyId(groupName + "#" + dependingOnPropertyId.getValue());
            if (dependingOnValue != null) {
                dependingOn.setValue(dependingOnValue.getValue());
            }
            if (dependingOnType != null) {
                ComponentType.ConditionType conditionType = ComponentType.ConditionType.valueOf(dependingOnType.getValue());
                dependingOn.setType(conditionType);
            }
            if (dependingOnValues != null) {
                String[] values = dependingOnValues.getValue().split(":");
                dependingOn.setValues(values);
            }
            if (dependingOnHasToExist != null) {
                dependingOn.setHasToExist(dependingOnHasToExist.getValue().equals("Y"));
            }
            dependingOnList.add(dependingOn);
        }
        ComponentType.DependingOn returnDependingOn = new ComponentType.DependingOn();
        returnDependingOn.setOperator("AND");
        returnDependingOn.setConditions(dependingOnList.toArray(new ComponentType.DependingOn[dependingOnList.size()]));
        return returnDependingOn;
    }

    private String getDefaultValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        String valueFromParameter = null;
        for (String defaultValuePropertyId : propertyTemplate.getComponentProperty().getDefaultValue().getPropertyIds()) {
            ComponentParameter defaultValueComponentParameter = customAttributeComponent.getParameters().get(defaultValuePropertyId);
            if (defaultValueComponentParameter == null) continue;
            valueFromParameter = defaultValueComponentParameter.getValue();
            break;
        }
        String defaultValue = propertyTemplate.getComponentProperty().getDefaultValue().getDefaultValue();
        return valueFromParameter != null ? valueFromParameter : defaultValue;
    }

    private Boolean isRequiredValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        Boolean isRequiredValue = propertyTemplate.getComponentProperty().getIsRequired().getValue();
        if (isRequiredValue != null) {
            return isRequiredValue;
        }
        ComponentParameter isRequiredComponentParameter = customAttributeComponent.getParameters().get(propertyTemplate.getComponentProperty().getIsRequired().getPropertyId());
        try {
            APEXLangBooleanDataType isRequiredBooleanData = (APEXLangBooleanDataType)isRequiredComponentParameter.getData();
            return isRequiredBooleanData.booleanValue();
        }
        catch (ClassCastException e) {
            LOGGER.warning("Metametadata error with casting boolean data type for custom attribute required property.");
            return false;
        }
    }

    private ComponentType.ApiParameter getApiParameter(String staticId, String attributeNo, Plugins.Template propertyTemplate, ComponentType.Plugin.APIExpression apiExpression) {
        String expression = apiExpression.getProperty();
        expression = expression.replace(":plugin_attribute_static_id", "'" + staticId + "'");
        expression = expression.replace(":plugin_attribute_no", attributeNo);
        ComponentType.ApiParameter apiParameter = new ComponentType.ApiParameter();
        apiParameter.setExpression(expression);
        apiParameter.setDataType(propertyTemplate.getComponentProperty().getApiParameter().getDataType());
        return apiParameter;
    }

    private Integer getAttributeValueFromComponent(Component customAttributeComponent, Plugins plugins) {
        return Integer.parseInt(customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getAttributeNoPropertyId()).getValue());
    }

    private String getNameValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate) {
        return customAttributeComponent.getParameters().get(propertyTemplate.getProperty().getName().getPropertyId()).getValue();
    }

    private Property getPropertyValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate, Plugins plugins, Map<Component, List<Component>> pluginsChildren) {
        String propertyName = customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getApexLangNamePropertyId()).getValue();
        Property property = new Property();
        property.setType(propertyTemplate.getProperty().getType().getValue());
        property.setDeprecatedValues(new String[0]);
        property.setName(propertyName);
        property.setInternal(false);
        property.setYesValue("Y");
        property.setNoValue("N");
        List<Component> childrenComponents = pluginsChildren.get(customAttributeComponent);
        Plugins.Template.Property.LOV lovDefinition = propertyTemplate.getProperty().getLov();
        LOV lov = new LOV();
        lov.setValues(new ArrayList<LOVValue>());
        lov.setType(LOV.LOVType.STATIC);
        if (childrenComponents != null && lovDefinition != null && lovDefinition.getValues() != null) {
            for (Plugins.Template.Property.LOV.LOVValue lovValue : lovDefinition.getValues()) {
                String entryComponentTypeId = lovValue.getName().getComponentTypeId();
                String entryNamePropertyId = lovValue.getName().getPropertyId();
                String entryRPropertyId = lovValue.getR().getPropertyId();
                String entryIsDeprecatedPropertyId = lovValue.getIsDeprecated().getPropertyId();
                for (Component children : childrenComponents) {
                    if (!children.getTypeId().equals(entryComponentTypeId)) continue;
                    ComponentParameter entryNameProperty = children.getParameters().get(entryNamePropertyId);
                    ComponentParameter entryRProperty = children.getParameters().get(entryRPropertyId);
                    ComponentParameter entryIsDeprecatedProperty = children.getParameters().get(entryIsDeprecatedPropertyId);
                    LOVValue lovVal = new LOVValue();
                    if (entryNameProperty == null) continue;
                    lovVal.setName(entryNameProperty.getValue());
                    if (entryRProperty == null) continue;
                    lovVal.setR(entryRProperty.getValue());
                    lovVal.setD(new HashMap<String, String>());
                    for (String langKey : lovValue.getD().keySet()) {
                        String entryDPropertyId = lovValue.getD().get(langKey).getPropertyId();
                        ComponentParameter entryDProperty = children.getParameters().get(entryDPropertyId);
                        if (entryDProperty == null) continue;
                        lovVal.getD().put(langKey, entryDProperty.getValue());
                    }
                    if (entryIsDeprecatedProperty != null && entryIsDeprecatedProperty.getData() instanceof APEXLangBooleanDataType) {
                        lovVal.setDeprecated(((APEXLangBooleanDataType)entryIsDeprecatedProperty.getData()).booleanValue());
                    }
                    lov.getValues().add(lovVal);
                }
            }
        }
        if (lov.getValues().size() > 0) {
            property.setLov(lov);
        }
        return property;
    }

    private String getStaticIdValueFromComponent(Component customAttributeComponent, Plugins plugins) {
        ComponentParameter staticIdParameter = customAttributeComponent.getParameters().get(plugins.getCustomAttributes().getAttributeStaticIdPropertyId());
        String staticId = "";
        if (staticIdParameter != null) {
            staticId = staticIdParameter.getValue();
        }
        return staticId;
    }

    private String getGroupNameValueFromComponent(Component customAttributeComponent, Plugins.Template propertyTemplate, Metametadata metametadata) {
        ComponentParameter groupIdParameter = customAttributeComponent.getParameters().get(propertyTemplate.getProperty().getGroupId().getPropertyId());
        if (groupIdParameter != null) {
            if (this.nativePlugin) {
                return groupIdParameter.getValue();
            }
            return "plugin-" + groupIdParameter.getValue();
        }
        String groupId = propertyTemplate.getProperty().getGroupId().getDefaultValue();
        Group group = metametadata.getGroups().get(groupId);
        if (group == null) {
            return "";
        }
        return group.getName();
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public boolean isNativePlugin() {
        return this.nativePlugin;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public boolean isTemplatePlugin() {
        return this.templatePlugin;
    }

    public class CustomAttribute {
        private Integer attribute;
        private String name;
        private String helpText;
        private String groupName;
        private String propertyName;
        private Property property;
        private ComponentType.ComponentProperty componentProperty;
        private String staticId;
        private String scope;

        public CustomAttribute(Integer attribute, String name, String helpText, String groupName, String propertyName, String staticId, Property property, ComponentType.ComponentProperty componentProperty, String scope) {
            this.attribute = attribute;
            this.name = name;
            this.helpText = helpText;
            this.groupName = groupName;
            this.propertyName = propertyName;
            this.property = property;
            this.componentProperty = componentProperty;
            this.staticId = staticId;
            this.scope = scope;
        }

        public String getScope() {
            return this.scope;
        }

        public String getStaticId() {
            return this.staticId;
        }

        public ComponentType.ComponentProperty getComponentProperty() {
            return this.componentProperty;
        }

        public Integer getAttribute() {
            return this.attribute;
        }

        public String getGroupName() {
            return this.groupName;
        }

        public String getHelpText() {
            return this.helpText;
        }

        public String getName() {
            return this.name;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

