/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang.core;

import java.math.BigInteger;
import oracle.apexlang.core.APEXLangException;
import oracle.apexlang.core.APEXLangNumericDataType;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;

public class APEXLangIntegerDataType
implements APEXLangNumericDataType {
    private BigInteger number;
    private String outputType;

    public APEXLangIntegerDataType(String data, String outputType) throws APEXLangException {
        try {
            this.number = new BigInteger(data);
            this.outputType = outputType;
        }
        catch (NumberFormatException e) {
            throw new APEXLangException("Invalid integer: " + data);
        }
    }

    @Override
    public String toPlSql(String template, String bindVariable) {
        if (this.outputType == null || this.outputType.equals("string")) {
            return Transpiler.replaceAllSafely(template, bindVariable, "'" + String.valueOf(this.number) + "'");
        }
        return Transpiler.replaceAllSafely(template, bindVariable, String.valueOf(this.number));
    }

    public String toString() {
        return String.valueOf(this.number);
    }

    @Override
    public void validate(Property property, PropertyType propertyType) throws APEXLangException {
        if (property.getMinValue() != null && BigInteger.valueOf(property.getMinValue().intValue()).compareTo(this.number) > 0) {
            throw new APEXLangException("Integer out of range: " + String.valueOf(this.number) + ". Valid integer between (" + property.getMinValue() + " - " + property.getMaxValue() + ")");
        }
        if (property.getMaxValue() != null && BigInteger.valueOf(property.getMaxValue().intValue()).compareTo(this.number) < 0) {
            throw new APEXLangException("Integer out of range: " + String.valueOf(this.number) + ". Valid integer between (" + property.getMinValue() + " - " + property.getMaxValue() + ")");
        }
        if (property.getMaxLen() != null && property.getMaxLen() < String.valueOf(this.number).length()) {
            throw new APEXLangException("Integer max digit length exceeded : " + String.valueOf(this.number).length() + ". Max digit length is " + property.getMaxLen());
        }
    }

    @Override
    public Number getNumber() {
        return this.number;
    }
}

