/*
 * Decompiled with CFR 0.152.
 */
package oracle.apexlang;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import oracle.apexlang.APEXAppFile;
import oracle.apexlang.APEXLangListener;
import oracle.apexlang.FileLoader;
import oracle.apexlang.antlr.APEXLangLexer;
import oracle.apexlang.antlr.APEXLangParser;
import oracle.apexlang.core.APEXLangArrayDataType;
import oracle.apexlang.core.APEXLangCentralThemeLoader;
import oracle.apexlang.core.APEXLangCompilationResult;
import oracle.apexlang.core.APEXLangCompilerContext;
import oracle.apexlang.core.APEXLangCompilerUtils;
import oracle.apexlang.core.APEXLangDataType;
import oracle.apexlang.core.APEXLangDataTypeFactory;
import oracle.apexlang.core.APEXLangErrorListener;
import oracle.apexlang.core.APEXLangException;
import oracle.apexlang.core.APEXLangIntegerDataType;
import oracle.apexlang.core.APEXLangManifest;
import oracle.apexlang.core.APEXLangManifestObject;
import oracle.apexlang.core.APEXLangMissingRequiredPropertyError;
import oracle.apexlang.core.APEXLangNativePluginsLoader;
import oracle.apexlang.core.APEXLangNumericDataType;
import oracle.apexlang.core.APEXLangStringDataType;
import oracle.apexlang.core.APEXLangSuggestion;
import oracle.apexlang.core.APEXLangSuggestionProvider;
import oracle.apexlang.core.APEXLangSyntaxError;
import oracle.apexlang.core.APEXLangWarning;
import oracle.apexlang.core.Component;
import oracle.apexlang.core.ComponentGroup;
import oracle.apexlang.core.ComponentParameter;
import oracle.apexlang.core.ComponentPlugin;
import oracle.apexlang.core.ComponentRelation;
import oracle.apexlang.core.FilePathComponentType;
import oracle.apexlang.core.Location;
import oracle.apexlang.core.PluginType;
import oracle.apexlang.core.Position;
import oracle.apexlang.core.Range;
import oracle.apexlang.core.RawComponent;
import oracle.apexlang.core.RawParameter;
import oracle.apexlang.core.SortedFilePaths;
import oracle.apexlang.core.Transpiler;
import oracle.apexlang.metametadata.ComponentType;
import oracle.apexlang.metametadata.Group;
import oracle.apexlang.metametadata.LOV;
import oracle.apexlang.metametadata.LOVValue;
import oracle.apexlang.metametadata.Mapping;
import oracle.apexlang.metametadata.Metametadata;
import oracle.apexlang.metametadata.MetametadataParser;
import oracle.apexlang.metametadata.Property;
import oracle.apexlang.metametadata.PropertyType;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class APEXLangCompiler {
    private static final Logger LOGGER = Logger.getLogger(APEXLangCompiler.class.getName());
    public static final Set<String> componentTypesIgnoreErrors = Set.of();
    public static final Set<String> componentTypesPLSQLWrong = Set.of();
    private Metametadata metametadata;
    private APEXLangNativePluginsLoader pluginsLoader;
    private Map<String, APEXLangCompilerContext> centralThemes;
    private Map<String, Map<String, ComponentRelation>> componentTypeOneToOneRelationship;
    private Map<String, FilePathComponentType> filenameComponentTypeMap;
    private static final String LOV_SCOPE_WORKSPACE = "WORKSPACE";
    private static final String LOV_SCOPE_REGION = "REGION";
    private static final String LOV_SCOPE_PAGE = "PAGE";
    private static final String LOV_SCOPE_PAGE_AND_GLOBAL = "PAGE_AND_GLOBAL";
    private static final String LOV_SCOPE_APPLICATION = "APPLICATION";
    private static final String LOV_SCOPE_COMPONENT = "COMPONENT";
    private static final String LOV_SCOPE_PARENT = "PARENT";
    private static final String LOV_SCOPE_THEME = "THEME";
    private static final String LOV_SCOPE_WF_VERSION = "WF_VERSION";
    private static final String LOV_SCOPE_INSTANCE = "INSTANCE";
    private static final String THEME_TEMPLATE_COMPONENT = "themeTemplateComponent/";
    private static final String CUSTOM_PLUGIN_PREFIX = "plugin/";
    public static final String APEX_VERSION = "apex_version";
    public static final String API_VERSION = "api_version";
    public static final String APP_ID = "app_id";
    public static final String DEFAULT_ID_OFFSET = "default_id_offset";
    public static final String DEFAULT_OWNER = "default_owner";
    public static final String WORKSPACE_ID = "workspace_id";
    public static final String MANIFEST_FILENAME = "config.json";
    public static final String APEX_EXTENSION = ".apex";
    public static final String metaMetaDataFilePath = "apexlangmeta/apexlang_meta_data.json";
    public static final String pluginsPath = "^apexlangmeta/native-plugins/.*/[^/.]*[.]apex$";
    public static final String pluginsAppPath = "^apexlangmeta/native-plugins/[^/.]*[.]apex$";
    public static final String centralThemesPath = "^apexlangmeta/central-themes/.*/[^/.]*[.]apex$";
    public static Pattern MLT_REGEX = Pattern.compile("^```([a-zA-Z][a-zA-Z\\-]*)?(.*)```$", 40);
    private final Pattern KEY_VALUE_REGEX = Pattern.compile("^([^\\s:]+)\\s*:\\s*(.*)$", 40);
    private static Map<String, APEXLangCompiler> instanceMap = new ConcurrentHashMap<String, APEXLangCompiler>();
    private static Map<String, String> supportedVersions = new HashMap<String, String>(){
        {
            this.put("default", "apexlang.zip");
            this.put("test", "apexlang-test.zip");
            this.put("25.1.0-31+1770", "apexlang-25.1.0-31+1770.zip");
            this.put("25.1.0-31+1790", "apexlang-25.1.0-31+1790.zip");
            this.put("25.1.0-31+1794", "apexlang-25.1.0-31+1794.zip");
        }
    };
    private String version;

    private APEXLangCompiler() {
    }

    public static APEXLangCompiler getInstance() {
        return APEXLangCompiler.getInstance("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static APEXLangCompiler getInstance(String version) {
        if (!supportedVersions.containsKey(version)) {
            LOGGER.log(Level.SEVERE, "Unsupported Compiler Version " + version);
            return null;
        }
        APEXLangCompiler instance = instanceMap.get(version);
        if (instance != null) return instance;
        Class<APEXLangCompiler> clazz = APEXLangCompiler.class;
        synchronized (APEXLangCompiler.class) {
            return instanceMap.computeIfAbsent(version, k -> {
                String resourceFileName = supportedVersions.get(version);
                Map<String, Map<String, APEXAppFile>> centralThemesApxFiles = APEXLangCompiler.getCentralThemeApps(resourceFileName);
                Map<String, APEXAppFile> nativePluginsApxFiles = APEXLangCompiler.getNativePluginsSourceCode(resourceFileName);
                APEXLangCompiler newInstance = new APEXLangCompiler();
                newInstance.setVersion(version);
                newInstance.setMetametadata(new MetametadataParser(resourceFileName).getMetametadata());
                newInstance.setFilenameComponentTypeMap(FilePathComponentType.loadFilenameComponentTypeMap(newInstance.getMetametadata()));
                newInstance.setComponentTypeOneToOneRelationship(APEXLangCompiler.getRelationComponents(newInstance.getMetametadata()));
                newInstance.setPluginsLoader(new APEXLangNativePluginsLoader(newInstance, nativePluginsApxFiles, centralThemesApxFiles));
                newInstance.setCentralThemes(new APEXLangCentralThemeLoader(newInstance, centralThemesApxFiles).getCentralThemes());
                return newInstance;
            });
        }
    }

    public void setFilenameComponentTypeMap(Map<String, FilePathComponentType> filenameComponentTypeMap) {
        this.filenameComponentTypeMap = filenameComponentTypeMap;
    }

    private static Map<String, APEXAppFile> getNativePluginsSourceCode(String resourceFileName) {
        HashMap<String, APEXAppFile> source = new HashMap<String, APEXAppFile>();
        try (InputStream input = APEXLangCompiler.class.getClassLoader().getResourceAsStream(resourceFileName);){
            List<String> filters = List.of(pluginsPath, pluginsAppPath);
            Map<String, APEXAppFile> pluginsInZip = new FileLoader().getFilesFromZipInputStream(input, filters);
            HashSet<String> paths = new HashSet<String>(pluginsInZip.keySet());
            for (String path : paths) {
                String[] chunks = path.split("/");
                CharSequence[] subChunks = Arrays.copyOfRange(chunks, 2, chunks.length);
                String filename = String.join((CharSequence)"/", subChunks);
                APEXAppFile content = pluginsInZip.get(path);
                source.put(filename, content);
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
        return source;
    }

    private static Map<String, Map<String, APEXAppFile>> getCentralThemeApps(String resourceFileName) {
        HashMap<String, Map<String, APEXAppFile>> deliveredApps = new HashMap<String, Map<String, APEXAppFile>>();
        try (InputStream input = APEXLangCompiler.class.getClassLoader().getResourceAsStream(resourceFileName);){
            List<String> filters = Collections.singletonList(centralThemesPath);
            Map<String, APEXAppFile> allApxFilesInZip = new FileLoader().getFilesFromZipInputStream(input, filters);
            HashSet<String> paths = new HashSet<String>(allApxFilesInZip.keySet());
            for (String path : paths) {
                String[] chunks = path.split("/");
                HashMap<String, APEXAppFile> appMap = (HashMap<String, APEXAppFile>)deliveredApps.get(chunks[2]);
                if (appMap == null) {
                    appMap = new HashMap<String, APEXAppFile>();
                    deliveredApps.put(chunks[2], appMap);
                }
                String filename = String.join((CharSequence)"/", Arrays.copyOfRange(chunks, 3, chunks.length));
                appMap.put(filename, allApxFilesInZip.remove(path));
            }
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
        }
        return deliveredApps;
    }

    public String getVersion() {
        return this.version;
    }

    private void setVersion(String version) {
        this.version = version;
    }

    private void setMetametadata(Metametadata metametadata) {
        this.metametadata = metametadata;
    }

    public Metametadata getMetametadata() {
        return this.metametadata;
    }

    public String getBuildID() {
        return this.metametadata.getBuildID();
    }

    private void setPluginsLoader(APEXLangNativePluginsLoader pluginsLoader) {
        this.pluginsLoader = pluginsLoader;
    }

    public APEXLangNativePluginsLoader getPluginsLoader() {
        return this.pluginsLoader;
    }

    public Map<String, Map<String, ComponentRelation>> getComponentTypeOneToOneRelationship() {
        return this.componentTypeOneToOneRelationship;
    }

    public void setComponentTypeOneToOneRelationship(Map<String, Map<String, ComponentRelation>> componentTypeOneToOneRelationship) {
        this.componentTypeOneToOneRelationship = componentTypeOneToOneRelationship;
    }

    public Map<String, APEXLangCompilerContext> getCentralThemes() {
        return this.centralThemes;
    }

    public void setCentralThemes(Map<String, APEXLangCompilerContext> centralThemes) {
        this.centralThemes = centralThemes;
    }

    private static Map<String, Map<String, ComponentRelation>> getRelationComponents(Metametadata metametadata) {
        HashMap<String, Map<String, ComponentRelation>> componentTypeOneToOneRelationship = new HashMap<String, Map<String, ComponentRelation>>();
        for (String componentTypeId : metametadata.getComponentTypes().keySet()) {
            Map<String, ComponentRelation> oneToOneRelationship = APEXLangCompiler.getRelationComponent(componentTypeId, metametadata);
            if (oneToOneRelationship.size() <= 0) continue;
            componentTypeOneToOneRelationship.put(componentTypeId, oneToOneRelationship);
        }
        return componentTypeOneToOneRelationship;
    }

    private static Map<String, ComponentRelation> getRelationComponent(String componentTypeId, Metametadata metametadata) {
        HashMap<String, ComponentRelation> oneToComponents = new HashMap<String, ComponentRelation>();
        for (Map.Entry<String, ComponentType> componentEntry : metametadata.getComponentTypes().entrySet()) {
            ComponentType component = componentEntry.getValue();
            if (component.getParent() == null || !component.getParent().isOneToOneRelation() || !component.getParent().getComponentTypeId().equals(componentTypeId)) continue;
            oneToComponents.put(componentEntry.getKey(), new ComponentRelation(component, component.getParent().getDependingOn()));
        }
        return oneToComponents;
    }

    List<Component> readParameters(String source, String filename) {
        return this.readParameters(source, filename, new ArrayList<APEXLangSyntaxError>(), List.of(), new APEXLangCompilerContext(), Map.of(), null, new SortedFilePaths());
    }

    List<Component> readParameters(String source, String filename, List<APEXLangSyntaxError> errors) {
        return this.readParameters(source, filename, errors, List.of(), new APEXLangCompilerContext(), Map.of(), null, new SortedFilePaths());
    }

    List<Component> readParameters(String source, String filename, List<APEXLangSyntaxError> errors, List<Component> previouslyParsedComponents, APEXLangCompilerContext compilerContext, Map<String, APEXAppFile> fileMap, Component parentComponent, SortedFilePaths sortedFilePaths) {
        compilerContext.getReferencablesMap().remove(filename);
        APEXLangErrorListener errorListener = new APEXLangErrorListener(filename);
        CodePointCharStream input = CharStreams.fromString((String)source);
        APEXLangLexer lexer = new APEXLangLexer((CharStream)input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        APEXLangParser parser = new APEXLangParser((TokenStream)tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        APEXLangParser.ProgramContext tree = parser.program();
        errors.addAll(errorListener.getErrors());
        APEXLangListener listener = new APEXLangListener(filename);
        ParseTreeWalker walker = new ParseTreeWalker();
        walker.walk((ParseTreeListener)listener, (ParseTree)tree);
        if (listener.getErrors().size() > 0) {
            errors.addAll(listener.getErrors());
        }
        List<RawComponent> rawComponents = listener.getRawComponents();
        List<Component> parsedComponents = this.convertRawComponentsToComponents(rawComponents, errors, filename, previouslyParsedComponents, compilerContext, parentComponent);
        if (sortedFilePaths.getChildrenFiles().size() > 0) {
            Component parent = null;
            for (Component currComponent : parsedComponents) {
                if (!currComponent.getTypeId().equals(sortedFilePaths.getComponentTypeId())) continue;
                parent = currComponent;
                break;
            }
            for (SortedFilePaths childrenFilePath : sortedFilePaths.getChildrenFiles()) {
                String childrenFilename = childrenFilePath.getFilePath();
                List<Component> childrenComponents = this.readParameters(fileMap.get(childrenFilename).getContentString(), childrenFilename, errors, parsedComponents, compilerContext, fileMap, parent, childrenFilePath);
                parsedComponents.addAll(childrenComponents);
            }
        }
        parsedComponents = parsedComponents.stream().sorted(Comparator.comparing(Component::getInsertOrder)).toList();
        HashMap referencables = new HashMap();
        for (Component component : parsedComponents) {
            String componentExternalIdentifierPropertyId = component.getExternalIdentifierPropertyId();
            ComponentParameter externalIdentifierParameter = component.getParameters().get(componentExternalIdentifierPropertyId);
            HashMap<String, ComponentParameter> componentTypeDependencies = (HashMap<String, ComponentParameter>)referencables.get(component.getTypeId());
            if (componentTypeDependencies == null) {
                componentTypeDependencies = new HashMap<String, ComponentParameter>();
                referencables.put(component.getTypeId(), componentTypeDependencies);
            }
            if (externalIdentifierParameter == null) continue;
            String externalIdentifier = externalIdentifierParameter.getData().toString();
            componentTypeDependencies.put(externalIdentifier, externalIdentifierParameter);
        }
        if (!referencables.isEmpty()) {
            compilerContext.getReferencablesMap().put(filename, referencables);
        }
        return parsedComponents;
    }

    private ComponentFoundResult findComponentForName(RawComponent rawComponent, Component parentComponent) {
        Collection<String> candidates = this.findComponentsWithName(rawComponent.getComponentTypeName());
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1 && parentComponent == null) {
            return new ComponentFoundResult(candidates.iterator().next(), null);
        }
        for (String componentTypeId : candidates) {
            ComponentType componentType = this.getMetametadata().getComponentTypes().get(componentTypeId);
            if (this.matchCandidateWithComponentType(componentTypeId, rawComponent.getFilename(), parentComponent, componentType)) {
                return new ComponentFoundResult(componentTypeId, parentComponent);
            }
            ArrayList relatedComponents = parentComponent != null ? parentComponent.getRelatedComponentsFound() : new ArrayList();
            for (Component relatedComponent : relatedComponents) {
                if (!this.matchCandidateWithComponentType(componentTypeId, rawComponent.getFilename(), relatedComponent, componentType)) continue;
                return new ComponentFoundResult(componentTypeId, relatedComponent);
            }
        }
        return null;
    }

    private boolean matchCandidateWithComponentType(String componentTypeId, String filename, Component parentComponent, ComponentType componentType) {
        boolean match;
        return parentComponent == null ? this.matchCandidateWithFilename(filename, componentType.getFilePath()) : componentType.getParent() != null && (match = this.isValidParent(parentComponent, componentType));
    }

    private boolean matchCandidateWithFilename(String filename, String componentFilepath) {
        String filepathDotApx = componentFilepath.replace("#ext#", APEX_EXTENSION);
        return filename.equals(filepathDotApx);
    }

    private Collection<String> findComponentsWithName(String componentTypeName) {
        ArrayList<String> candidates = new ArrayList<String>();
        for (Map.Entry<String, ComponentType> componentTypeEntry : this.metametadata.getComponentTypes().entrySet()) {
            ComponentType componentType = componentTypeEntry.getValue();
            if (!componentType.getName().getSingular().equals(componentTypeName)) continue;
            candidates.add(componentTypeEntry.getKey());
        }
        return candidates;
    }

    private boolean isValidParent(Component parentComponent, ComponentType componentType) {
        boolean isValid = componentType.getParent().getComponentTypeId().equals(parentComponent.getTypeId());
        if (!isValid) {
            return isValid;
        }
        if (componentType.getParent().getDependingOn() != null) {
            isValid = APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(parentComponent, componentType.getParent().getDependingOn(), this.metametadata);
        }
        return isValid;
    }

    private List<Component> convertRawComponentsToComponents(Collection<RawComponent> rawComponents, List<APEXLangSyntaxError> errors, String filename, List<Component> previouslyParsedComponents, APEXLangCompilerContext appCtx, Component parentFromDifferenteSourceFile) {
        ArrayList<Component> parsedComponents = new ArrayList<Component>();
        HashMap<RawComponent, Component> componentLookUpMap = new HashMap<RawComponent, Component>();
        for (RawComponent rawComponent : rawComponents) {
            try {
                RawComponent rawParent = rawComponent.getParent();
                Component parentComponent = parentFromDifferenteSourceFile;
                String parentExternalIdentifier = "";
                if (rawParent != null) {
                    parentExternalIdentifier = rawParent.getExternalIdentifierValue();
                    parentComponent = (Component)componentLookUpMap.get(rawParent);
                } else if (parentComponent != null) {
                    parentExternalIdentifier = parentComponent.getExternalIdentifier();
                }
                ComponentFoundResult componentFound = this.findComponentForName(rawComponent, parentComponent);
                if (componentFound == null) {
                    if (parentComponent != null && componentTypesIgnoreErrors.contains(parentComponent.getTypeId())) {
                        LOGGER.warning("Error on: " + filename + " for component " + rawComponent.getComponentTypeName() + " (soft error): Not found children for " + parentComponent.getName() + " L" + rawComponent.getLine());
                        continue;
                    }
                    throw new Exception("Component: " + rawComponent.getComponentTypeName() + " not found");
                }
                Boolean ignoreErrors = componentTypesIgnoreErrors.contains(componentFound.getComponentTypeId());
                ComponentType compType = this.metametadata.getComponentTypes().get(componentFound.getComponentTypeId());
                Component parsedComponent = this.createComponentFromRawComponent(rawComponent, componentFound.getComponentTypeId(), compType, parentExternalIdentifier, appCtx, previouslyParsedComponents);
                parsedComponent.setParent(componentFound.getParent());
                parsedComponents.add(parsedComponent);
                componentLookUpMap.put(rawComponent, parsedComponent);
                this.addComponentParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, parsedComponents, previouslyParsedComponents);
            }
            catch (Exception e) {
                Range externalIdentifierRange = rawComponent.getExternalIdentifierRange();
                if (externalIdentifierRange == null) {
                    externalIdentifierRange = new Range(rawComponent.getRangeStart(), rawComponent.getRangeEnd());
                }
                errors.add(new APEXLangSyntaxError(rawComponent.getLine(), rawComponent.getColumn(), "Invalid property: " + rawComponent.getExternalIdentifierValue() + "\n" + e.getMessage(), externalIdentifierRange.getStart(), rawComponent.getExternalIdentifierValue(), externalIdentifierRange.getStart(), externalIdentifierRange.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY, null));
            }
        }
        return parsedComponents;
    }

    private void addDefaultValuesForPlugin(Component parsedComponent) {
        try {
            ComponentPlugin plugin = parsedComponent.getComponentPlugin();
            if (plugin != null) {
                for (ComponentPlugin.CustomAttribute customAttribute : plugin.getCustomAttributes()) {
                    String propertyId = customAttribute.getGroupName() + "#" + customAttribute.getPropertyName();
                    ComponentParameter parameterCustomAttribute = parsedComponent.getParameters().get(propertyId);
                    if (parameterCustomAttribute != null || !customAttribute.getComponentProperty().getIsRequired().booleanValue() || customAttribute.getComponentProperty().getDefaultValue() == null || !APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(parsedComponent, customAttribute.getComponentProperty().getDependingOn(), this.metametadata)) continue;
                    ComponentType.ComponentProperty componentProperty = customAttribute.getComponentProperty();
                    ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
                    String dataType = apiParameter == null ? null : apiParameter.getDataType();
                    String expression = apiParameter == null ? "" : apiParameter.getExpression();
                    String value = componentProperty.getDefaultValue();
                    String yesValue = customAttribute.getProperty().getYesValue();
                    String noValue = customAttribute.getProperty().getNoValue();
                    PropertyType propertyType = this.metametadata.getPropertyTypes().get(customAttribute.getProperty().getType());
                    String propertyDataType = "string";
                    if (propertyType != null) {
                        propertyDataType = propertyType.getDataType();
                    }
                    if ("boolean".equals(propertyType.getDataType()) && componentProperty.getDefaultValue() != null) {
                        value = componentProperty.getDefaultValue().equals(yesValue) ? "true" : "false";
                    }
                    parsedComponent.addParameter(propertyId, new ComponentParameter(parsedComponent, APEXLangDataTypeFactory.createDataType(value, propertyDataType, yesValue, noValue, dataType, false, ""), expression, parsedComponent.getRange().getStart(), parsedComponent.getRange().getEnd(), parsedComponent.getRange().getStart(), parsedComponent.getRange().getEnd(), parsedComponent.getLine(), parsedComponent.getColumn(), false, true, customAttribute.getProperty(), true, false, null));
                }
            }
        }
        catch (APEXLangException x) {
            LOGGER.warning("There is a issue with APEXlang metametadata");
        }
    }

    private void addExternalIdentifier(Component parsedComponent, RawComponent rawComponent, ComponentType compType) throws APEXLangException {
        String externalIdentifierPropertyId;
        if (rawComponent.getExternalIdentifierRange() != null && (externalIdentifierPropertyId = compType.getExternalIdentifierPropertyId()) != null) {
            String expression;
            Property property = this.metametadata.getProperties().get(externalIdentifierPropertyId);
            PropertyType propertyType = this.metametadata.getPropertyTypes().get(property.getType());
            ComponentType.ComponentProperty componentProperty = compType.getProperties().get(externalIdentifierPropertyId);
            ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
            String dataType = apiParameter == null ? null : apiParameter.getDataType();
            String string = expression = apiParameter == null ? null : apiParameter.getExpression();
            if (dataType == null) {
                dataType = "string";
            }
            APEXLangDataType data = APEXLangDataTypeFactory.createDataType(rawComponent.getExternalIdentifierValue(), propertyType.getDataType(), "", "", dataType, false, "");
            ComponentParameter externalIdentifierParameter = new ComponentParameter(parsedComponent, data, expression, rawComponent.getExternalIdentifierKeyRange().getStart(), rawComponent.getExternalIdentifierKeyRange().getEnd(), rawComponent.getExternalIdentifierValueRange().getStart(), rawComponent.getExternalIdentifierValueRange().getEnd(), rawComponent.getLine(), rawComponent.getColumn(), true, false, property, false, true, null);
            parsedComponent.getParameters().put(compType.getExternalIdentifierPropertyId(), externalIdentifierParameter);
        }
    }

    private void addRelatedComponents(Component parsedComponent, ComponentType compType) {
        if (parsedComponent.getPossibleComponentRelations() != null && parsedComponent.getPossibleComponentRelations().size() > 0) {
            for (Map.Entry<String, ComponentRelation> componentOneToOneEntry : parsedComponent.getPossibleComponentRelations().entrySet()) {
                String componentOneToOneId = componentOneToOneEntry.getKey();
                ComponentRelation componentOneToOne = componentOneToOneEntry.getValue();
                boolean match = true;
                if (componentOneToOne.getDependingOn() != null && componentOneToOne.getDependingOn().getConditions().length > 0) {
                    match &= APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(parsedComponent, componentOneToOne.getDependingOn(), this.metametadata);
                }
                if (!match) continue;
                ComponentType componentType = componentOneToOne.getComponentType();
                Component component = new Component(componentOneToOneId, componentType, componentType.getParent().getComponentTypeId(), parsedComponent, new ArrayList<ComponentGroup>(), this.componentTypeOneToOneRelationship.get(componentOneToOneId));
                component.setParent(parsedComponent);
                if (parsedComponent.getComponentPlugin() != null && componentType.getPlugin() != null) {
                    ComponentPlugin parentPlugin = parsedComponent.getComponentPlugin();
                    String[] attributesScopes = componentType.getPlugin().getAttributeScopes();
                    if (attributesScopes == null) {
                        attributesScopes = new String[]{};
                    }
                    component.setPluginType(parsedComponent.getPluginType());
                    component.setComponentPlugin(new ComponentPlugin(parentPlugin.getPlugin(), compType.getPlugin().getApi().getExpression(), parentPlugin.getAllPluginsTreeGenealogy(), this.metametadata, parentPlugin.isNativePlugin(), parentPlugin.getPluginType(), attributesScopes, parentPlugin.isCentral()));
                }
                parsedComponent.getRelatedComponentsFound().add(component);
            }
        }
    }

    private Collection<RawParameter> addParametersFromRawComponent(Component parsedComponent, ComponentType compType, RawComponent rawComponent, boolean ignoreErrors, List<APEXLangSyntaxError> errors, List<Component> previouslyParsedComponents, boolean finalPass) {
        ArrayList<RawParameter> rawParametersForNextPass = new ArrayList<RawParameter>();
        for (RawParameter rawParameter : rawComponent.getRawParameters()) {
            if (this.addParameterIntoComponent(parsedComponent, rawParameter, errors, rawComponent.getFilename(), finalPass, ignoreErrors, previouslyParsedComponents)) continue;
            rawParametersForNextPass.add(rawParameter);
        }
        rawComponent.getRawParameters().clear();
        rawComponent.getRawParameters().addAll(rawParametersForNextPass);
        return rawParametersForNextPass;
    }

    private Collection<RawParameter> addAndExhaustParametersFromRawComponent(Component parsedComponent, ComponentType compType, RawComponent rawComponent, boolean ignoreErrors, List<APEXLangSyntaxError> errors, List<Component> previouslyParsedComponents) {
        Collection<RawParameter> rawParametersForNextPass = new ArrayList<RawParameter>();
        int previousRawParametersSize = -1;
        while (rawParametersForNextPass.size() != previousRawParametersSize) {
            previousRawParametersSize = rawParametersForNextPass.size();
            rawParametersForNextPass = this.addParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, previouslyParsedComponents, false);
        }
        return rawParametersForNextPass;
    }

    private Collection<RawParameter> addAndExhaustParametersFromRawComponentAndAddDefaults(Component parsedComponent, ComponentType compType, RawComponent rawComponent, boolean ignoreErrors, List<APEXLangSyntaxError> errors, List<Component> parsedComponents, List<Component> previouslyParsedComponents) {
        this.addDefaltToCurrentComponent(parsedComponent, compType, previouslyParsedComponents, previouslyParsedComponents);
        for (Component oneToOneComponent : parsedComponent.getRelatedComponentsFound()) {
            ComponentType oneToComponentType = this.metametadata.getComponentTypes().get(oneToOneComponent.getTypeId());
            Set<String> componentPropertyIds = oneToComponentType.getProperties().keySet();
            this.addDefaultValuesForPlugin(oneToOneComponent);
            for (String componentPropertyId : componentPropertyIds) {
                this.addDefaultValueRecursiveForDependsOn(parsedComponents, oneToOneComponent, componentPropertyId, oneToOneComponent.getTypeId(), previouslyParsedComponents);
            }
        }
        for (Component oneToOneComponent : parsedComponent.getRelatedComponentsFound()) {
            for (Component oneToOneToOneComponent : oneToOneComponent.getRelatedComponentsFound()) {
                ComponentType oneToOneToOneComponentType = this.metametadata.getComponentTypes().get(oneToOneToOneComponent.getTypeId());
                Set<String> componentPropertyIds = oneToOneToOneComponentType.getProperties().keySet();
                this.addDefaultValuesForPlugin(oneToOneToOneComponent);
                for (String componentPropertyId : componentPropertyIds) {
                    this.addDefaultValueRecursiveForDependsOn(parsedComponents, oneToOneToOneComponent, componentPropertyId, oneToOneToOneComponent.getTypeId(), previouslyParsedComponents);
                }
            }
        }
        return this.addAndExhaustParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, previouslyParsedComponents);
    }

    private void addRelatedToRelatedComponents(Component parsedComponent, ComponentType compType) {
        for (Component relatedComponent : parsedComponent.getRelatedComponentsFound()) {
            if (relatedComponent.getPossibleComponentRelations() == null) continue;
            for (Map.Entry<String, ComponentRelation> componentOneToOneEntry : relatedComponent.getPossibleComponentRelations().entrySet()) {
                String componentOneToOneId = componentOneToOneEntry.getKey();
                ComponentRelation componentOneToOne = componentOneToOneEntry.getValue();
                boolean match = true;
                if (componentOneToOne.getDependingOn() != null && componentOneToOne.getDependingOn().getConditions().length > 0) {
                    match &= APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(relatedComponent, componentOneToOne.getDependingOn(), this.metametadata);
                }
                if (!match) continue;
                ComponentType componentType = componentOneToOne.getComponentType();
                Component component = new Component(componentOneToOneId, componentType, componentType.getParent().getComponentTypeId(), relatedComponent, new ArrayList<ComponentGroup>(), this.componentTypeOneToOneRelationship.get(componentOneToOneId));
                component.setParent(relatedComponent);
                if (parsedComponent.getComponentPlugin() != null && componentType.getPlugin() != null) {
                    ComponentPlugin parentPlugin = parsedComponent.getComponentPlugin();
                    String[] attributesScopes = componentType.getPlugin().getAttributeScopes();
                    if (attributesScopes == null) {
                        attributesScopes = new String[]{};
                    }
                    component.setPluginType(parsedComponent.getPluginType());
                    component.setComponentPlugin(new ComponentPlugin(parentPlugin.getPlugin(), compType.getPlugin().getApi().getExpression(), this.pluginsLoader.getPluginsChildren(), this.metametadata, parentPlugin.isNativePlugin(), parentPlugin.getPluginType(), attributesScopes, parentPlugin.isCentral()));
                }
                relatedComponent.getRelatedComponentsFound().add(component);
            }
        }
    }

    private void addDefaltToCurrentComponent(Component parsedComponent, ComponentType compType, List<Component> parsedComponents, List<Component> previouslyParsedComponents) {
        Set<String> componentPropertyIds = compType.getProperties().keySet();
        for (String componentPropertyId : componentPropertyIds) {
            this.addDefaultValueRecursiveForDependsOn(parsedComponents, parsedComponent, componentPropertyId, parsedComponent.getTypeId(), previouslyParsedComponents);
        }
    }

    private void addComponentParametersFromRawComponent(Component parsedComponent, ComponentType compType, RawComponent rawComponent, boolean ignoreErrors, List<APEXLangSyntaxError> errors, List<Component> parsedComponents, List<Component> previouslyParsedComponents) throws APEXLangException {
        Collection<RawParameter> rawParametersToReview = this.addAndExhaustParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, previouslyParsedComponents);
        this.addExternalIdentifier(parsedComponent, rawComponent, compType);
        this.addDefaltToCurrentComponent(parsedComponent, compType, parsedComponents, previouslyParsedComponents);
        this.addDefaultValuesForPlugin(parsedComponent);
        this.addRelatedComponents(parsedComponent, compType);
        rawParametersToReview = this.addAndExhaustParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, previouslyParsedComponents);
        for (Component oneToOneComponent : parsedComponent.getRelatedComponentsFound()) {
            parsedComponents.add(oneToOneComponent);
            ComponentType oneToComponentType = this.metametadata.getComponentTypes().get(oneToOneComponent.getTypeId());
            Set<String> componentPropertyIds = oneToComponentType.getProperties().keySet();
            this.addDefaultValuesForPlugin(oneToOneComponent);
            for (String componentPropertyId : componentPropertyIds) {
                this.addDefaultValueRecursiveForDependsOn(parsedComponents, oneToOneComponent, componentPropertyId, oneToOneComponent.getTypeId(), previouslyParsedComponents);
            }
        }
        this.addRelatedToRelatedComponents(parsedComponent, compType);
        for (Component oneToOneComponent : parsedComponent.getRelatedComponentsFound()) {
            for (Component oneToOneToOneComponent : oneToOneComponent.getRelatedComponentsFound()) {
                parsedComponents.add(oneToOneToOneComponent);
                ComponentType oneToOneToOneComponentType = this.metametadata.getComponentTypes().get(oneToOneToOneComponent.getTypeId());
                Set<String> componentPropertyIds = oneToOneToOneComponentType.getProperties().keySet();
                this.addDefaultValuesForPlugin(oneToOneToOneComponent);
                for (String componentPropertyId : componentPropertyIds) {
                    this.addDefaultValueRecursiveForDependsOn(parsedComponents, oneToOneToOneComponent, componentPropertyId, oneToOneToOneComponent.getTypeId(), previouslyParsedComponents);
                }
            }
        }
        rawParametersToReview = this.addAndExhaustParametersFromRawComponent(parsedComponent, compType, rawComponent, ignoreErrors, errors, previouslyParsedComponents);
        if (rawParametersToReview.size() == 0) {
            return;
        }
        rawParametersToReview = this.addAndExhaustParametersFromRawComponentAndAddDefaults(parsedComponent, compType, rawComponent, ignoreErrors, errors, parsedComponents, previouslyParsedComponents);
        if (rawParametersToReview.size() > 0) {
            for (RawParameter rawParameter : rawParametersToReview) {
                if (this.addParameterIntoComponent(parsedComponent, rawParameter, errors, rawComponent.getFilename(), true, ignoreErrors, previouslyParsedComponents) || ignoreErrors) continue;
                throw new APEXLangException(" Ambiguous property error: " + rawParameter.getGroupName() + "{ " + rawParameter.getKey() + ": " + rawParameter.getValue() + " }");
            }
        }
    }

    private Component createComponentFromRawComponent(RawComponent rawComponent, String componentTypeId, ComponentType compType, String parentExternalIdentifier, APEXLangCompilerContext appCtx, List<Component> parsedComponents) {
        String parentTypeId = compType.getParent() != null ? compType.getParent().getComponentTypeId() : "";
        Component parsedComponent = new Component(componentTypeId, compType, parentTypeId, rawComponent.getRangeStart(), rawComponent.getRangeEnd(), rawComponent.getLine(), rawComponent.getColumn(), rawComponent.getFilename(), parentExternalIdentifier, rawComponent.getComponentGroups(), this.componentTypeOneToOneRelationship.get(componentTypeId));
        if (compType.getPlugin() != null && compType.getPlugin().getTypes() != null) {
            for (String pluginType : compType.getPlugin().getTypes()) {
                Component pluginFound;
                Property pluginPropertyType = this.metametadata.getProperties().get(compType.getPlugin().getPropertyId());
                ComponentType.ComponentProperty pluginComponentProperty = compType.getProperties().get(compType.getPlugin().getPropertyId());
                if (pluginPropertyType == null) continue;
                Group pluginGroup = this.metametadata.getGroups().get(pluginPropertyType.getGroupId());
                String pluginName = null;
                for (RawParameter rawParameter : rawComponent.getRawParameters()) {
                    String groupName = rawParameter.getGroupName();
                    if (groupName == null) {
                        Group defaultGroup = this.metametadata.getGroups().get(compType.getDefaultGroupId());
                        String string = groupName = defaultGroup != null ? defaultGroup.getName() : "";
                    }
                    if (!pluginGroup.getName().equals(groupName) || !pluginPropertyType.getName().equals(rawParameter.getKey())) continue;
                    pluginName = rawParameter.getValue();
                    break;
                }
                if (pluginName == null) {
                    return parsedComponent;
                }
                if (pluginName.startsWith(THEME_TEMPLATE_COMPONENT)) {
                    Component pluginFound2;
                    String pluginNameWithoutPrefix = pluginName.substring(THEME_TEMPLATE_COMPONENT.length());
                    Iterator<Component> appId = appCtx.getCentralThemeAppId();
                    Map<Object, Object> pluginsFound = Map.of();
                    if (appId != null) {
                        pluginsFound = this.pluginsLoader.getCentralThemePluginTypesMapPerAppId().get(appId).get(pluginType);
                    }
                    Component component = pluginFound2 = pluginsFound == null ? null : (Component)pluginsFound.get(pluginNameWithoutPrefix);
                    if (pluginFound2 == null) continue;
                    parsedComponent.setPluginType(new PluginType(pluginType, compType.getPlugin().getPropertyId(), compType.getPlugin().getApi()));
                    parsedComponent.setComponentPlugin(new ComponentPlugin(pluginFound2, compType.getPlugin().getApi().getExpression(), this.pluginsLoader.getPluginsChildren(), this.metametadata, false, pluginType, compType.getPlugin().getAttributeScopes(), true));
                    continue;
                }
                if (pluginName.startsWith(CUSTOM_PLUGIN_PREFIX)) {
                    HashMap<Component, List<Component>> componentChildrenMap = new HashMap<Component, List<Component>>();
                    for (Component currComponent : parsedComponents) {
                        if (componentChildrenMap.get(currComponent.getParent()) == null) {
                            componentChildrenMap.put(currComponent.getParent(), new ArrayList());
                        }
                        ((List)componentChildrenMap.get(currComponent.getParent())).add(currComponent);
                    }
                    for (Component currComponent : parsedComponents) {
                        ComponentParameter typePropertyId;
                        if (!currComponent.getTypeId().equals(this.metametadata.getPlugins().getComponentTypeId()) || (typePropertyId = currComponent.getParameters().get(this.metametadata.getPlugins().getTypePropertyId())) == null) continue;
                        String pluginTypeFound = typePropertyId.getValue();
                        if (!pluginName.equals(CUSTOM_PLUGIN_PREFIX + currComponent.getExternalIdentifier()) || !pluginType.equals(pluginTypeFound)) continue;
                        parsedComponent.setPluginType(new PluginType(pluginType, compType.getPlugin().getPropertyId(), compType.getPlugin().getApi()));
                        parsedComponent.setComponentPlugin(new ComponentPlugin(currComponent, compType.getPlugin().getApi().getExpression(), componentChildrenMap, this.metametadata, false, pluginType, compType.getPlugin().getAttributeScopes(), false));
                    }
                    continue;
                }
                Map<String, Component> pluginsFound = this.pluginsLoader.getPluginTypesMap().get(pluginType);
                Component component = pluginFound = pluginsFound == null ? null : pluginsFound.get(pluginName);
                if (pluginFound == null) continue;
                parsedComponent.setPluginType(new PluginType(pluginType, compType.getPlugin().getPropertyId(), compType.getPlugin().getApi()));
                parsedComponent.setComponentPlugin(new ComponentPlugin(pluginFound, compType.getPlugin().getApi().getExpression(), this.pluginsLoader.getPluginsChildren(), this.metametadata, true, pluginType, compType.getPlugin().getAttributeScopes(), false));
            }
        }
        return parsedComponent;
    }

    /*
     * WARNING - void declaration
     */
    private boolean addParameterIntoComponent(Component component, RawParameter rawParameter, List<APEXLangSyntaxError> errors, String filename, boolean finalPass, boolean ignoreErrors, List<Component> previoslyParsedComponents) {
        void var14_21;
        ArrayList<PropertyCandidate> candidates = new ArrayList<PropertyCandidate>();
        String componentTypeId = component.getTypeId();
        ComponentType componentType = this.metametadata.getComponentTypes().get(componentTypeId);
        if (componentType == null) {
            LOGGER.warning("Something is wrong with metametadata!");
            return false;
        }
        boolean implicitGroup = false;
        String groupName = rawParameter.getGroupName();
        if (groupName == null) {
            Group defaultGroup = this.metametadata.getGroups().get(componentType.getDefaultGroupId());
            groupName = defaultGroup != null ? defaultGroup.getName() : "";
            implicitGroup = defaultGroup != null;
        }
        for (String string : componentType.getProperties().keySet()) {
            Property property = this.metametadata.getProperties().get(string);
            if (property == null) {
                LOGGER.warning("Something is wrong with metametadata!");
                continue;
            }
            PropertyType propertyType = this.metametadata.getPropertyTypes().get(property.getType());
            if (propertyType == null) {
                LOGGER.warning("Something is wrong with metametadata!");
                continue;
            }
            Group propertyGroup = this.metametadata.getGroups().get(property.getGroupId());
            if (property.getName().equals(rawParameter.getKey()) && propertyGroup != null && propertyGroup.getName().equals(groupName)) {
                candidates.add(new PropertyCandidate(property, string, componentType.getProperties().get(string), false, component));
                continue;
            }
            if (!(property.getName() + "File").equals(rawParameter.getKey()) || propertyGroup == null || !propertyGroup.getName().equals(groupName) || !propertyType.isMultiLine()) continue;
            candidates.add(new PropertyCandidate(property, string, componentType.getProperties().get(string), false, component, true));
        }
        ComponentPlugin componentPlugin = component.getComponentPlugin();
        if (componentPlugin != null) {
            for (ComponentPlugin.CustomAttribute customAttribute : componentPlugin.getCustomAttributes()) {
                if (!customAttribute.getGroupName().equals(groupName) || !customAttribute.getPropertyName().equals(rawParameter.getKey())) continue;
                ComponentType.ComponentProperty customProperty = new ComponentType.ComponentProperty();
                customProperty.setApiParameter(customAttribute.getComponentProperty().getApiParameter());
                customProperty.setDependingOn(customAttribute.getComponentProperty().getDependingOn());
                candidates.add(new PropertyCandidate(customAttribute.getProperty(), customAttribute.getGroupName() + "#" + customAttribute.getName(), customProperty, true, component));
            }
        }
        if (candidates.size() == 0) {
            for (Component currComponent : component.getRelatedComponentsFound()) {
                ComponentType oneToOneComponentType = this.metametadata.getComponentTypes().get(currComponent.getTypeId());
                for (String string : oneToOneComponentType.getProperties().keySet()) {
                    Property property = this.metametadata.getProperties().get(string);
                    if (property == null) {
                        LOGGER.warning("Something is wrong with metametadata!");
                        continue;
                    }
                    Group propertyGroup = this.metametadata.getGroups().get(property.getGroupId());
                    if (!property.getName().equals(rawParameter.getKey()) || propertyGroup == null || !propertyGroup.getName().equals(groupName)) continue;
                    candidates.add(new PropertyCandidate(property, string, oneToOneComponentType.getProperties().get(string), false, currComponent));
                }
                ComponentPlugin oneToOneComponentPlugin = currComponent.getComponentPlugin();
                if (oneToOneComponentPlugin != null) {
                    for (ComponentPlugin.CustomAttribute customAttribute : oneToOneComponentPlugin.getCustomAttributes()) {
                        if (!customAttribute.getGroupName().equals(groupName) || !customAttribute.getPropertyName().equals(rawParameter.getKey())) continue;
                        ComponentType.ComponentProperty customProperty = new ComponentType.ComponentProperty();
                        customProperty.setApiParameter(customAttribute.getComponentProperty().getApiParameter());
                        customProperty.setDependingOn(customAttribute.getComponentProperty().getDependingOn());
                        candidates.add(new PropertyCandidate(customAttribute.getProperty(), customAttribute.getGroupName() + "#" + customAttribute.getName(), customProperty, true, currComponent));
                    }
                }
                for (Component oneToOneComponent : currComponent.getRelatedComponentsFound()) {
                    ComponentType oneToOneComponentType2 = this.metametadata.getComponentTypes().get(oneToOneComponent.getTypeId());
                    for (String propertyKey3 : oneToOneComponentType2.getProperties().keySet()) {
                        Property property = this.metametadata.getProperties().get(propertyKey3);
                        if (property == null) {
                            LOGGER.warning("Something is wrong with metametadata!");
                            continue;
                        }
                        Group propertyGroup = this.metametadata.getGroups().get(property.getGroupId());
                        if (!property.getName().equals(rawParameter.getKey()) || propertyGroup == null || !propertyGroup.getName().equals(groupName)) continue;
                        candidates.add(new PropertyCandidate(property, propertyKey3, oneToOneComponentType2.getProperties().get(propertyKey3), false, oneToOneComponent));
                    }
                    if (oneToOneComponentPlugin == null) continue;
                    for (ComponentPlugin.CustomAttribute customAttribute : oneToOneComponentPlugin.getCustomAttributes()) {
                        if (!customAttribute.getGroupName().equals(groupName) || !customAttribute.getPropertyName().equals(rawParameter.getKey())) continue;
                        ComponentType.ComponentProperty customProperty = new ComponentType.ComponentProperty();
                        customProperty.setApiParameter(customAttribute.getComponentProperty().getApiParameter());
                        customProperty.setDependingOn(customAttribute.getComponentProperty().getDependingOn());
                        candidates.add(new PropertyCandidate(customAttribute.getProperty(), customAttribute.getGroupName() + "#" + customAttribute.getName(), customProperty, true, oneToOneComponent));
                    }
                }
            }
        }
        if (candidates.size() == 0) {
            if (!finalPass) {
                return false;
            }
            if (ignoreErrors) {
                LOGGER.warning("Error on: " + filename + " for component " + componentType.getName().getSingular() + " it has an invalid property (soft error): For property: " + rawParameter.getKey() + " L" + rawParameter.getLine());
            } else {
                errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid property: " + rawParameter.getKey(), rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY, null));
            }
            return true;
        }
        Object var14_19 = null;
        String propertyId = "";
        ComponentType.ComponentProperty componentProperty = null;
        Boolean pluginParameter = false;
        Object var18_30 = null;
        boolean isMultilineFile = false;
        ArrayList<PropertyCandidate> candidatesVisible = new ArrayList<PropertyCandidate>();
        if (candidates.size() > 1) {
            for (PropertyCandidate candidateProperty : candidates) {
                if (!APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(candidateProperty.getComponentToAssignProperty(), candidateProperty.getComponentProperty().getDependingOn(), this.metametadata)) continue;
                candidatesVisible.add(candidateProperty);
            }
            if (candidatesVisible.size() > 0) {
                candidates = candidatesVisible;
            }
        }
        if (candidates.size() == 1) {
            propertyId = ((PropertyCandidate)candidates.get(0)).getPropertyKey();
            Property property = ((PropertyCandidate)candidates.get(0)).getProperty();
            componentProperty = ((PropertyCandidate)candidates.get(0)).getComponentProperty();
            pluginParameter = ((PropertyCandidate)candidates.get(0)).isPluginProperty();
            Component component2 = ((PropertyCandidate)candidates.get(0)).getComponentToAssignProperty();
            isMultilineFile = ((PropertyCandidate)candidates.get(0)).isMultilineFile();
        } else if (candidates.size() > 1 && !finalPass) {
            return false;
        }
        if (var14_21 == null) {
            if (ignoreErrors) {
                LOGGER.warning("Error on: " + filename + " for component " + componentType.getName().getSingular() + " it has an invalid property (soft error): For property: " + rawParameter.getKey() + " L" + rawParameter.getLine());
            } else {
                errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid property: " + rawParameter.getKey(), rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY, null));
            }
            return true;
        }
        PropertyType propertyType = this.metametadata.getPropertyTypes().get(var14_21.getType());
        ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
        String dataType = apiParameter == null ? null : apiParameter.getDataType();
        String expression = apiParameter == null ? "" : apiParameter.getExpression();
        List<APEXLangSuggestion> suggestions = null;
        if (dataType == null) {
            dataType = "string";
        }
        if ("boolean".equals(propertyType.getDataType())) {
            suggestions = APEXLangSuggestion.fromStrings(List.of("true", "false"), APEXLangSuggestion.SuggestionType.VALUE);
        }
        try {
            void var18_32;
            String multivalueDelimiter;
            String noValue;
            String yesValue = var14_21.getYesValue();
            if (yesValue == null || yesValue.equals("")) {
                yesValue = propertyType.getDefaultYesValue();
            }
            if ((noValue = var14_21.getNoValue()) == null || noValue.equals("")) {
                noValue = propertyType.getDefaultNoValue();
            }
            if ((multivalueDelimiter = var14_21.getMultiValueDelimiter()) == null) {
                multivalueDelimiter = propertyType.getDefaultMultiValueDelimiter();
            }
            String value = rawParameter.getValue();
            APEXLangDataType data = APEXLangDataTypeFactory.createDataType(value, propertyType.getDataType(), yesValue, noValue, dataType, rawParameter.isArray(), multivalueDelimiter);
            if (propertyType.isMultiLine() && value.startsWith("```")) {
                Matcher m = MLT_REGEX.matcher(value);
                Object errMsg = null;
                if (m.matches()) {
                    String[] annotation = m.group(1);
                    if (annotation != null && annotation.isEmpty()) {
                        annotation = null;
                    }
                    String lang = propertyType.getLanguage();
                    ArrayList<String> supportedLangTags = new ArrayList<String>();
                    if (lang != null) {
                        supportedLangTags.add(lang);
                        int dashPos = lang.indexOf("-");
                        if (dashPos > 0) {
                            supportedLangTags.add(lang.substring(0, dashPos));
                        }
                    }
                    if (supportedLangTags.isEmpty() && annotation != null) {
                        errMsg = "Language annotation should not be set for this property";
                    } else if (!supportedLangTags.isEmpty() && annotation != null && !supportedLangTags.contains(annotation)) {
                        if (supportedLangTags.size() == 1) {
                            errMsg = "Language annotation should be \"" + lang + "\" for this property";
                        } else {
                            String langs = supportedLangTags.stream().map(t -> "\"" + t + "\"").collect(Collectors.joining(","));
                            errMsg = "Language annotation should be one of " + langs + " for this property";
                        }
                    }
                } else {
                    errMsg = "Badly formatted multiline text block";
                }
                if (errMsg != null) {
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), (String)errMsg, rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY, null));
                }
            }
            if (var14_21.getLov() != null && var14_21.getLov().getType() == LOV.LOVType.STATIC) {
                value = this.resolveStaticLovs((Property)var14_21, rawParameter, data, filename, errors, ignoreErrors);
                suggestions = APEXLangSuggestion.fromStrings(var14_21.getLov().getValues().stream().filter(lovv -> !lovv.isDeprecated() && !lovv.isInternal()).map(lovv -> lovv.getName()).toList(), APEXLangSuggestion.SuggestionType.VALUE);
            }
            if (var14_21.getLov() != null && var14_21.getLov().getType() == LOV.LOVType.PLUGINS) {
                HashSet<String> pluginNames = new HashSet<String>();
                String[] pluginTypes = component.getComponentType().getPlugin().getTypes();
                if (pluginTypes != null) {
                    for (String pt : pluginTypes) {
                        Map<String, Component> pluginsFound = this.pluginsLoader.getPluginTypesMap().get(pt);
                        if (pluginsFound == null) continue;
                        pluginNames.addAll(pluginsFound.keySet());
                    }
                }
                if (!pluginNames.isEmpty()) {
                    suggestions = APEXLangSuggestion.fromStrings(pluginNames, APEXLangSuggestion.SuggestionType.VALUE);
                }
                if (component.getPluginType() == null || component.getPluginType().getPropertyId() == propertyId) {
                    throw new APEXLangException("invalid plugin type");
                }
                String pluginType = component.getPluginType().getType();
                Map<String, Component> pluginsFound = this.pluginsLoader.getPluginTypesMap().get(pluginType);
                ComponentPlugin pluginFound = component.getComponentPlugin();
                if (pluginFound == null) {
                    Object validPlugins = "Valid plugins are: \n";
                    if (pluginsFound != null) {
                        for (String pluginName : pluginsFound.keySet()) {
                            validPlugins = (String)validPlugins + pluginName + "\n";
                        }
                    } else {
                        validPlugins = (String)validPlugins + "Plugin type: " + pluginType + " invalid \n";
                    }
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Plugin not found for " + componentType.getName().getSingular() + " component: " + value + "\n" + (String)validPlugins, rawParameter.getStart(), "", rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.PLUGIN_NOT_FOUND, suggestions));
                } else {
                    value = pluginFound.getName();
                }
            }
            data = APEXLangDataTypeFactory.createDataType(value, propertyType.getDataType(), yesValue, noValue, dataType, rawParameter.isArray(), multivalueDelimiter);
            data.validate((Property)var14_21, propertyType);
            String tokenString = rawParameter.getToken().getText();
            Matcher m = this.KEY_VALUE_REGEX.matcher(tokenString);
            int keyEndOffset = 0;
            int valueStartOffset = 0;
            if (m.matches()) {
                keyEndOffset = m.end(1);
                valueStartOffset = m.start(2);
            }
            var18_32.addParameter(propertyId, new ComponentParameter((Component)var18_32, data, expression, rawParameter.getStart(), rawParameter.getStart() + keyEndOffset, rawParameter.getStart() + valueStartOffset, rawParameter.getEnd() + 1, rawParameter.getLine(), rawParameter.getColumn(), true, implicitGroup, (Property)var14_21, pluginParameter, false, suggestions, isMultilineFile));
        }
        catch (APEXLangException x) {
            errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid property (" + x.getMessage() + "): " + rawParameter.getKey(), rawParameter.getStart(), rawParameter.getKey(), rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.INVALID_PROPERTY, suggestions));
        }
        return true;
    }

    private String resolveStaticLovs(Property property, RawParameter rawParameter, APEXLangDataType data, String filename, List<APEXLangSyntaxError> errors, Boolean ignoreErrors) {
        String result = rawParameter.getValue();
        if (property.getLov() != null && property.getLov().getType() == LOV.LOVType.STATIC) {
            List<LOVValue> lov = property.getLov().getValues();
            PropertyType propertyType = this.getMetametadata().getPropertyTypes().get(property.getType());
            Group group = this.getMetametadata().getGroups().get(property.getGroupId());
            String groupName = "";
            if (group == null) {
                groupName = property.getGroupName();
            }
            boolean lovFound = false;
            ArrayList<String> possibles = new ArrayList<String>();
            ArrayList<APEXLangSuggestion> suggestions = new ArrayList<APEXLangSuggestion>();
            for (LOVValue lOVValue : lov) {
                possibles.add(lOVValue.getName());
                if (lOVValue.isDeprecated() || lOVValue.isInternal()) continue;
                suggestions.add(new APEXLangSuggestion(APEXLangSuggestion.SuggestionType.VALUE, lOVValue.getName(), null));
            }
            String validLovs = possibles.stream().collect(Collectors.joining("\n-"));
            if (!(data instanceof APEXLangArrayDataType)) {
                for (LOVValue value : lov) {
                    if (!value.getName().equals(data.toString())) continue;
                    result = value.getR();
                    lovFound = true;
                }
                if (!lovFound) {
                    if (ignoreErrors.booleanValue()) {
                        LOGGER.warning("Error on: " + filename + " it has an invalid LOV property (soft error): For property: " + rawParameter.getKey() + " Line: " + rawParameter.getLine());
                    } else {
                        errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid LOV required parameter: " + groupName + " - " + property.getName() + " (" + propertyType.getDataType() + ")\nValid parameters are: " + validLovs, rawParameter.getStart(), "", rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.LOV_NOT_FOUND, suggestions));
                    }
                }
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                APEXLangArrayDataType dataArray = (APEXLangArrayDataType)data;
                for (APEXLangDataType entry : dataArray.getData()) {
                    for (LOVValue value : lov) {
                        if (!value.getName().equals(entry.toString())) continue;
                        arrayList.add(value.getR());
                        lovFound = true;
                        break;
                    }
                    if (lovFound) continue;
                    if (ignoreErrors.booleanValue()) {
                        LOGGER.warning("Error on: " + filename + " it has an invalid LOV property (soft error): For property: " + rawParameter.getKey() + " L" + rawParameter.getLine());
                        continue;
                    }
                    errors.add(new APEXLangSyntaxError(rawParameter.getLine(), rawParameter.getColumn(), "Invalid LOV required parameter: " + group.getName() + " - " + property.getName() + " (" + propertyType.getDataType() + ")\nValid parameters are: " + validLovs, rawParameter.getStart(), "", rawParameter.getStart(), rawParameter.getEnd(), filename, APEXLangSyntaxError.ErrorType.LOV_NOT_FOUND, suggestions));
                }
                result = String.join((CharSequence)"\n", arrayList);
            }
        }
        return result;
    }

    void resolveReferences(List<Component> componentsParameters, List<APEXLangSyntaxError> errors, APEXLangCompilerContext appCtx) {
        for (Component currentComponent : componentsParameters) {
            for (Map.Entry<String, ComponentParameter> componentParameterEntry : currentComponent.getParameters().entrySet()) {
                Component pointerComponent;
                String ref;
                APEXLangStringDataType data;
                List<APEXLangSuggestion> suggestions;
                ComponentParameter componentParameter = componentParameterEntry.getValue();
                Property property = componentParameter.getProperty();
                if (property.getLov() == null) continue;
                if (property.getLov().getType() == LOV.LOVType.COMPONENT) {
                    String lovScope = property.getLov().getScope();
                    suggestions = null;
                    try {
                        Map<String, Location> availableReferences;
                        if (componentParameter.getData().getClass() != APEXLangStringDataType.class) {
                            LOGGER.warning("Invalidate LOV (only supported from Strings) " + componentParameter.getData().getClass().getName());
                            throw new Exception("Invalid reference");
                        }
                        data = (APEXLangStringDataType)componentParameter.getData();
                        ref = data.getData();
                        if (property.getLov().isNotSupported()) {
                            data.setSupportsNotFlag(true);
                            if (ref.startsWith("!")) {
                                data.setNotFlag(true);
                                ref = ref.substring(1);
                            }
                        }
                        if ((availableReferences = this.getAvailableReferenceLocations(property, currentComponent, appCtx)) != null) {
                            suggestions = APEXLangSuggestion.fromStrings(availableReferences.keySet(), APEXLangSuggestion.SuggestionType.VALUE);
                            componentParameter.setSuggestions(suggestions);
                        }
                        if (ref.length() == 0 || ref.charAt(0) != '@') {
                            throw new Exception("Invalid reference: " + ref);
                        }
                        String[] chunks = ref.substring(1).split("/");
                        String componentId = chunks[chunks.length - 1];
                        if (chunks.length < 3) {
                            if (availableReferences.containsKey(ref)) {
                                data.setData(componentId);
                                data.setCentral(chunks.length == 2);
                                continue;
                            }
                            Map<String, Location> debug = this.getAvailableReferenceLocations(property, currentComponent, appCtx);
                            throw new Exception("Reference not found: " + ref);
                        }
                        if (chunks.length == 3) {
                            if (!LOV_SCOPE_WORKSPACE.equals(lovScope) && !LOV_SCOPE_INSTANCE.equals(lovScope)) {
                                throw new Exception("External reference not supported property with scope " + lovScope);
                            }
                            String refAppId = chunks[1];
                            if (!this.centralThemes.containsKey(refAppId) && !refAppId.matches("\\d+")) {
                                errors.add(new APEXLangSyntaxError(componentParameter.getLine(), componentParameter.getColumn(), "Subscribed to application ID should be numeric", componentParameter.getValueRange().getStart(), refAppId, componentParameter.getValueRange().getStart(), componentParameter.getValueRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.INVALID_PROPERTY, null));
                            }
                            data.setRefAppId(refAppId);
                            data.setData(chunks[2]);
                            data.setCentral(false);
                            continue;
                        }
                        if (chunks.length <= 3) continue;
                        throw new Exception("Invalid reference: " + ref);
                    }
                    catch (Exception e) {
                        errors.add(new APEXLangSyntaxError(componentParameter.getLine(), componentParameter.getColumn(), e.getMessage(), componentParameter.getRange().getStart(), "", componentParameter.getRange().getStart(), componentParameter.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                        continue;
                    }
                }
                if (property.getLov().getType() == LOV.LOVType.PLUGIN_ACTION_TEMPLATES) {
                    try {
                        for (pointerComponent = currentComponent; pointerComponent != null && pointerComponent.getComponentPlugin() == null; pointerComponent = pointerComponent.getParent()) {
                        }
                        if (pointerComponent == null) {
                            throw new Exception("Component plugin not found");
                        }
                        suggestions = APEXLangSuggestion.fromStrings(pointerComponent.getComponentPlugin().getActionTemplates(), APEXLangSuggestion.SuggestionType.VALUE);
                        if (componentParameter.getData().getClass() != APEXLangStringDataType.class) {
                            errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "Component plugin doesnt contain actionTemplate: " + componentParameter.getData().toString(), currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                            continue;
                        }
                        data = (APEXLangStringDataType)componentParameter.getData();
                        ref = data.getData();
                        if (!pointerComponent.getComponentPlugin().getActionTemplates().contains(ref)) {
                            errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "Component plugin doesnt contain actionTemplate: " + ref, currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                            continue;
                        }
                        data.setPluginExternalIdentifier(pointerComponent.getComponentPlugin().getPlugin().getExternalIdentifier());
                        data.setCentral(pointerComponent.getComponentPlugin().isCentral());
                    }
                    catch (Exception e) {
                        errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "lovType error: " + e.getMessage(), currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, List.of()));
                    }
                    continue;
                }
                if (property.getLov().getType() != LOV.LOVType.PLUGIN_ACTION_POSITIONS) continue;
                try {
                    for (pointerComponent = currentComponent; pointerComponent != null && pointerComponent.getComponentPlugin() == null; pointerComponent = pointerComponent.getParent()) {
                    }
                    if (pointerComponent == null) {
                        throw new Exception("Component plugin not found");
                    }
                    suggestions = APEXLangSuggestion.fromStrings(pointerComponent.getComponentPlugin().getActionTemplates(), APEXLangSuggestion.SuggestionType.VALUE);
                    if (componentParameter.getData().getClass() != APEXLangStringDataType.class) {
                        errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "Component plugin doesnt contain actionPosition for: " + componentParameter.getData().toString(), currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                        continue;
                    }
                    data = (APEXLangStringDataType)componentParameter.getData();
                    ref = data.getData();
                    if (!pointerComponent.getComponentPlugin().getActionPositions().contains(ref)) {
                        errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "Component plugin doesnt contain actionPosition: " + ref, currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                        continue;
                    }
                    data.setPluginExternalIdentifier(pointerComponent.getComponentPlugin().getPlugin().getExternalIdentifier());
                    data.setCentral(pointerComponent.getComponentPlugin().isCentral());
                }
                catch (Exception e) {
                    errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "LovType error: " + e.getMessage(), currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, List.of()));
                }
            }
        }
    }

    private Map<String, Location> getAvailableReferenceLocations(Property property, Component component, APEXLangCompilerContext appCtx) {
        if (property.getLov() != null && property.getLov().getType() == LOV.LOVType.COMPONENT) {
            String componentTypeId = property.getLov().getComponentTypeId();
            String lovScope = property.getLov().getScope();
            ComponentType.DependingOn filter = property.getLov().getFilter();
            return this.getAvailableReferenceLocations(component, appCtx, lovScope, componentTypeId, filter);
        }
        return Collections.emptyMap();
    }

    Map<String, Location> getAvailableReferenceLocations(Component component, APEXLangCompilerContext appCtx, String lovScope, String componentTypeId, ComponentType.DependingOn filter) {
        HashMap<String, Location> ret = new HashMap<String, Location>();
        String componentType = component.getTypeId();
        Function<ComponentParameter, Boolean> scopeChecker = cp -> true;
        if (lovScope != null && !lovScope.equals(LOV_SCOPE_APPLICATION)) {
            if (LOV_SCOPE_COMPONENT.equals(lovScope)) {
                String id = component.getExternalIdentifier();
                scopeChecker = cp -> {
                    Component cpComponent = cp.getComponent();
                    Component testComponent = cpComponent == null ? null : cpComponent.getParent();
                    return id != null && testComponent != null && id.equals(testComponent.getExternalIdentifier());
                };
            } else if ("GRAND_PARENT".equals(lovScope) || LOV_SCOPE_WF_VERSION.equals(lovScope)) {
                Component parent = component;
                Component gParent = parent == null ? null : parent.getParent();
                scopeChecker = cp -> {
                    Component parent2 = cp.getComponent();
                    Component gParent2 = parent2 == null ? null : parent2.getParent();
                    return gParent2 == gParent;
                };
            } else if (LOV_SCOPE_REGION.equals(lovScope)) {
                Component pointerComponent;
                for (pointerComponent = component; pointerComponent != null && pointerComponent.getTypeId() != "5110"; pointerComponent = pointerComponent.getParent()) {
                }
                if (pointerComponent == null) {
                    scopeChecker = cp -> false;
                } else {
                    String regionExternalIdentifier = pointerComponent.getExternalIdentifier();
                    for (Map.Entry<String, Object> entry : component.getParameters().entrySet()) {
                        Object property = this.metametadata.getProperties().get(entry.getKey());
                        if (property != null) continue;
                        property = new Property();
                    }
                    scopeChecker = cp -> {
                        Component pointerComponentScopeChecker;
                        for (pointerComponentScopeChecker = cp.getComponent(); pointerComponentScopeChecker != null && pointerComponentScopeChecker.getTypeId() != "5110"; pointerComponentScopeChecker = pointerComponentScopeChecker.getParent()) {
                        }
                        if (pointerComponentScopeChecker == null) {
                            return false;
                        }
                        return pointerComponentScopeChecker != null && pointerComponentScopeChecker.getExternalIdentifier().equals(regionExternalIdentifier);
                    };
                }
            } else if (LOV_SCOPE_PAGE.equals(lovScope) || LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope)) {
                Component paramPage = this.getPage(component);
                scopeChecker = cp -> {
                    Component page = this.getPage((ComponentParameter)cp);
                    return page != null && page == paramPage;
                };
            } else if (LOV_SCOPE_THEME.equals(lovScope)) {
                ThemeDefinition td = this.getThemeDefinition(this.metametadata.getMapping().getTheme().getCurrent(), component);
                scopeChecker = cp -> td != null && td.refAppId.length() == 0;
            }
        }
        for (Map.Entry<String, Map<String, Map<String, ComponentParameter>>> entry : appCtx.getReferencablesMap().entrySet()) {
            Map<String, Map<String, ComponentParameter>> componentTypeMap = entry.getValue();
            Map<String, ComponentParameter> map = componentTypeMap.get(componentTypeId);
            if (map == null) continue;
            for (Map.Entry<String, ComponentParameter> entry2 : map.entrySet()) {
                Position pos;
                ComponentParameter cp2 = entry2.getValue();
                Component referencedComponent = cp2.getComponent();
                if (filter != null && !APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(referencedComponent, filter, this.metametadata)) continue;
                if (scopeChecker.apply(cp2).booleanValue()) {
                    pos = new Position(cp2.getLine(), cp2.getColumn());
                    ret.put("@" + entry2.getKey(), new Location(entry.getKey(), pos));
                    continue;
                }
                if (!LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope) || !this.onGlobalPage(appCtx, cp2)) continue;
                pos = new Position(cp2.getLine(), cp2.getColumn());
                ret.put("@/" + entry2.getKey(), new Location(entry.getKey(), pos));
            }
        }
        Map<Object, Object> additionalReferencablesMap = Collections.emptyMap();
        Function<ComponentParameter, Boolean> additionalScopeChecker = null;
        if (componentType.equals("2000")) {
            ThemeDefinition td = this.getThemeDefinition(this.metametadata.getMapping().getTheme().getSubscribedFrom(), component);
            if (td != null && this.centralThemes.containsKey(td.refAppId)) {
                additionalReferencablesMap = this.centralThemes.get(td.refAppId).getReferencablesMap();
                additionalScopeChecker = cp -> true;
            }
        } else if (LOV_SCOPE_THEME.equals(lovScope) || LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope) || componentType.equals("2040")) {
            for (Map.Entry<String, Map<String, Map<String, ComponentParameter>>> entry : appCtx.getReferencablesMap().entrySet()) {
                String sf;
                Map<String, Map<String, ComponentParameter>> componentTypeMap = entry.getValue();
                Map<String, ComponentParameter> referencables = componentTypeMap.get(sf = this.metametadata.getMapping().getTheme().getSubscribedFrom().getComponentTypeId());
                if (referencables == null) continue;
                for (Map.Entry<String, ComponentParameter> entry2 : referencables.entrySet()) {
                    ComponentParameter cp2 = entry2.getValue();
                    ThemeDefinition td = this.getThemeDefinition(this.metametadata.getMapping().getTheme().getSubscribedFrom(), cp2.getComponent());
                    if (td == null || !this.centralThemes.containsKey(td.refAppId)) continue;
                    additionalReferencablesMap = this.centralThemes.get(td.refAppId).getReferencablesMap();
                    additionalScopeChecker = cp -> true;
                    break;
                }
                if (additionalScopeChecker == null) continue;
                break;
            }
            if (additionalScopeChecker == null) {
                if (LOV_SCOPE_THEME.equals(lovScope)) {
                    additionalScopeChecker = cp -> true;
                } else if (LOV_SCOPE_PAGE_AND_GLOBAL.equals(lovScope)) {
                    additionalScopeChecker = cp -> true;
                } else if (componentType.equals("2040")) {
                    additionalScopeChecker = cp -> true;
                }
            }
        }
        for (Map.Entry<String, Object> entry : additionalReferencablesMap.entrySet()) {
            Map referencables = (Map)((Map)entry.getValue()).get(componentTypeId);
            if (referencables == null) continue;
            for (Map.Entry entry2 : referencables.entrySet()) {
                if (!additionalScopeChecker.apply((ComponentParameter)entry2.getValue()).booleanValue()) continue;
                ret.put("@/" + (String)entry2.getKey(), null);
            }
        }
        return ret;
    }

    private Component getPage(ComponentParameter componentParameter) {
        return this.getPage(componentParameter.getComponent());
    }

    private Component getPage(Component component) {
        Component parent;
        for (parent = component; parent != null; parent = parent.getParent()) {
            String componentTypeId = parent.getTypeId();
            String componentType = this.metametadata.getComponentTypes().get(componentTypeId).getName().getSingular();
            if ("page".equals(componentType)) break;
        }
        return parent;
    }

    private boolean onGlobalPage(APEXLangCompilerContext appCtx, ComponentParameter componentParameter) {
        ComponentParameter cp;
        Component page;
        Integer globalPageNum = appCtx.getGlobalPage();
        if (globalPageNum != null && (page = this.getPage(componentParameter)) != null && (cp = page.getParameters().get(page.getExternalIdentifierPropertyId())) != null) {
            APEXLangNumericDataType data = (APEXLangNumericDataType)cp.getData();
            Integer pageNum = data.getNumber().intValue();
            return globalPageNum.equals(pageNum);
        }
        return false;
    }

    private ThemeDefinition getThemeDefinition(Mapping.ComponentTypePropertyId componentTypePropertyId, Component component) {
        String subscriptionProp = componentTypePropertyId.getPropertyId();
        ComponentParameter subsParam = component.getParameters().get(subscriptionProp);
        APEXLangDataType data = subsParam == null ? null : subsParam.getData();
        ThemeDefinition ret = null;
        if (data instanceof APEXLangStringDataType) {
            String ref = ((APEXLangStringDataType)data).getData();
            if (ref.startsWith("@/")) {
                Pattern p = Pattern.compile("^@/([^/]+)/([^/]+)$");
                Matcher m = p.matcher(data.toString());
                if (m.matches()) {
                    ret = new ThemeDefinition();
                    ret.refAppId = m.group(1);
                    ret.themeId = m.group(2);
                }
            } else {
                String refAppId = ((APEXLangStringDataType)data).getRefAppId();
                if (refAppId != null) {
                    ret = new ThemeDefinition();
                    ret.refAppId = refAppId;
                    ret.themeId = ((APEXLangStringDataType)data).getData();
                }
            }
        }
        return ret;
    }

    void checkPropertyVisibleComponentParameters(List<Component> componentsParameters) {
        HashSet<String> componentPropertyToBeDeleted = new HashSet<String>();
        for (Component currentComponent : componentsParameters) {
            for (Map.Entry<String, ComponentParameter> currentParameter : currentComponent.getParameters().entrySet()) {
                ComponentType.ComponentProperty componentProperty = this.metametadata.getComponentTypes().get(currentComponent.getTypeId()).getProperties().get(currentParameter.getKey());
                boolean propertyVisible = APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(currentComponent, componentProperty.getDependingOn(), this.metametadata);
                if (propertyVisible) continue;
                componentPropertyToBeDeleted.add(currentParameter.getKey());
            }
            for (String deletedPropertyKey : componentPropertyToBeDeleted) {
                currentComponent.getParameters().remove(deletedPropertyKey);
            }
        }
    }

    void addDefaultValues(List<Component> componentParameters, List<Component> previouslyParsedComponents) {
        for (Component currentComponent : componentParameters) {
            Set<String> componentPropertyIds = this.metametadata.getComponentTypes().get(currentComponent.getTypeId()).getProperties().keySet();
            for (String componentPropertyId : componentPropertyIds) {
                this.addDefaultValueRecursiveForDependsOn(componentParameters, currentComponent, componentPropertyId, currentComponent.getTypeId(), previouslyParsedComponents);
            }
            for (Component oneToOneComponent : currentComponent.getRelatedComponentsFound()) {
                this.addDefaultValuesForPlugin(oneToOneComponent);
                componentPropertyIds = this.metametadata.getComponentTypes().get(oneToOneComponent.getTypeId()).getProperties().keySet();
                for (String componentPropertyId : componentPropertyIds) {
                    this.addDefaultValueRecursiveForDependsOn(componentParameters, oneToOneComponent, componentPropertyId, oneToOneComponent.getTypeId(), previouslyParsedComponents);
                }
                for (Component oneToOneToOneComponent : oneToOneComponent.getRelatedComponentsFound()) {
                    this.addDefaultValuesForPlugin(oneToOneToOneComponent);
                    ComponentType oneToOneToOneComponentType = this.metametadata.getComponentTypes().get(oneToOneToOneComponent.getTypeId());
                    componentPropertyIds = oneToOneToOneComponentType.getProperties().keySet();
                    for (String componentPropertyId : componentPropertyIds) {
                        this.addDefaultValueRecursiveForDependsOn(componentParameters, oneToOneToOneComponent, componentPropertyId, oneToOneToOneComponent.getTypeId(), previouslyParsedComponents);
                    }
                }
            }
        }
    }

    void addDefaultValueRecursiveDependingOnConditions(List<Component> componentParameters, Component component, ComponentType.DependingOn dependingOn, List<Component> previouslyParsedComponents) {
        if (dependingOn.getConditions() != null) {
            for (ComponentType.DependingOn dependingOnConditions : dependingOn.getConditions()) {
                this.addDefaultValueRecursiveDependingOnConditions(componentParameters, component, dependingOnConditions, previouslyParsedComponents);
            }
        } else {
            this.addDefaultValueRecursiveForDependsOn(componentParameters, component, dependingOn.getPropertyId(), dependingOn.getComponentTypeId(), previouslyParsedComponents);
        }
    }

    void addDefaultValueRecursiveForDependsOn(List<Component> componentParameters, Component component, String parameterId, String componentTypeId, List<Component> previouslyParsedComponents) {
        String currentComponentTypeId;
        Object currComponent = component;
        ComponentParameter parameter = ((Component)currComponent).getParameters().get(parameterId);
        if (parameter != null) {
            return;
        }
        ComponentType componentType = null;
        String string = currentComponentTypeId = componentType == null ? ((Component)currComponent).getTypeId() : componentTypeId;
        if (!((Component)currComponent).getTypeId().equals(currentComponentTypeId)) {
            Object componentCursor = currComponent;
            while (((Component)componentCursor).getParent() != null) {
                if (!((Component)(componentCursor = ((Component)componentCursor).getParent())).getTypeId().equals(currentComponentTypeId)) continue;
                componentType = this.metametadata.getComponentTypes().get(((Component)componentCursor).getTypeId());
                currComponent = componentCursor;
                break;
            }
        } else {
            componentType = this.metametadata.getComponentTypes().get(currentComponentTypeId);
        }
        parameter = ((Component)currComponent).getParameters().get(parameterId);
        if (parameter != null) {
            return;
        }
        if (componentType == null) {
            for (Component previoslyParsedComponent : previouslyParsedComponents) {
                if (!previoslyParsedComponent.getTypeId().equals(currentComponentTypeId)) continue;
                componentType = this.metametadata.getComponentTypes().get(previoslyParsedComponent.getTypeId());
                currComponent = previoslyParsedComponent;
                break;
            }
        }
        if (componentType == null) {
            return;
        }
        ComponentType.ComponentProperty componentPropety = componentType.getProperties().get(parameterId);
        Property property = this.metametadata.getProperties().get(parameterId);
        if (property == null) {
            return;
        }
        PropertyType propertyType = this.metametadata.getPropertyTypes().get(property.getType());
        if (componentPropety == null) {
            return;
        }
        if (componentPropety.getIsRequired().booleanValue() && componentPropety.getDefaultValue() != null) {
            if (componentPropety.getDependingOn() != null) {
                for (ComponentType.DependingOn dependingOn : componentPropety.getDependingOn().getConditions()) {
                    if (dependingOn.getPropertyId() != null) {
                        this.addDefaultValueRecursiveForDependsOn(componentParameters, (Component)currComponent, dependingOn.getPropertyId(), dependingOn.getComponentTypeId(), previouslyParsedComponents);
                        continue;
                    }
                    this.addDefaultValueRecursiveDependingOnConditions(componentParameters, (Component)currComponent, dependingOn, previouslyParsedComponents);
                }
            }
            if (APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule((Component)currComponent, componentPropety.getDependingOn(), this.metametadata)) {
                String noValue;
                String yesValue = property.getYesValue();
                if (yesValue == null || yesValue.equals("")) {
                    yesValue = propertyType.getDefaultYesValue();
                }
                if ((noValue = property.getNoValue()) == null || noValue.equals("")) {
                    noValue = propertyType.getDefaultNoValue();
                }
                try {
                    CharSequence[] values;
                    List<APEXLangSuggestion> suggestions = null;
                    ComponentType.ComponentProperty componentProperty = componentType.getProperties().get(parameterId);
                    ComponentType.ApiParameter apiParameter = componentProperty.getApiParameter();
                    String dataType = apiParameter == null ? null : apiParameter.getDataType();
                    String expression = apiParameter == null ? "" : apiParameter.getExpression();
                    String value = componentPropety.getDefaultValue();
                    if ("boolean".equals(propertyType.getDataType())) {
                        value = componentPropety.getDefaultValue().equals(yesValue) ? "true" : "false";
                        suggestions = APEXLangSuggestion.fromStrings(List.of("true", "false"), APEXLangSuggestion.SuggestionType.VALUE);
                    }
                    if ((values = value.split(":")).length > 1) {
                        value = String.join((CharSequence)"\n", values);
                    }
                    ((Component)currComponent).addParameter(parameterId, new ComponentParameter((Component)currComponent, APEXLangDataTypeFactory.createDataType(value, propertyType.getDataType(), yesValue, noValue, dataType, values.length > 1, ":"), expression, ((Component)currComponent).getRange().getStart(), ((Component)currComponent).getRange().getEnd(), ((Component)currComponent).getRange().getStart(), ((Component)currComponent).getRange().getEnd(), ((Component)currComponent).getLine(), ((Component)currComponent).getColumn(), false, true, property, false, false, suggestions));
                }
                catch (Exception x) {
                    LOGGER.warning("Something wrong with metametadata: " + String.valueOf(x));
                }
            }
        }
    }

    void checkRequiredAttributes(List<Component> componentParameters, List<APEXLangSyntaxError> errors) {
        for (Component component : componentParameters) {
            ComponentType componentType = this.getMetametadata().getComponentTypes().get(component.getTypeId());
            for (Map.Entry<String, ComponentType.ComponentProperty> entryProperty : componentType.getProperties().entrySet()) {
                ComponentParameter componentParameter;
                String propertyId = entryProperty.getKey();
                ComponentType.ComponentProperty componentProperty = entryProperty.getValue();
                Property property = this.getMetametadata().getProperties().get(propertyId);
                PropertyType propertyType = this.getMetametadata().getPropertyTypes().get(property.getType());
                Group group = this.getMetametadata().getGroups().get(property.getGroupId());
                if (componentProperty == null || !componentProperty.getIsRequired().booleanValue() || !APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(component, componentProperty.getDependingOn(), this.metametadata) || (componentParameter = component.getParameters().get(entryProperty.getKey())) != null) continue;
                APEXLangMissingRequiredPropertyError error = new APEXLangMissingRequiredPropertyError(component.getLine(), component.getColumn(), "Missing required parameter (" + entryProperty.getKey() + "): " + group.getName() + " - " + property.getName() + " (" + propertyType.getDataType() + ")", component.getRange().getStart(), "", component.getRange().getStart(), component.getRange().getEnd(), component.getFilename(), APEXLangSyntaxError.ErrorType.MISSING_REQUIRED_PROPERTY, null);
                error.setMisssingProperty(property);
                errors.add(error);
            }
            if (component.getComponentPlugin() == null || component.getComponentPlugin().getCustomAttributes() == null) continue;
            for (ComponentPlugin.CustomAttribute customAttribute : component.getComponentPlugin().getCustomAttributes()) {
                ComponentParameter componentParameter;
                boolean isVisible = APEXLangCompilerUtils.isParameterVisibleAccordingDependOnRule(component, customAttribute.getComponentProperty().getDependingOn(), this.metametadata);
                if (!isVisible || !customAttribute.getComponentProperty().getIsRequired().booleanValue() || (componentParameter = component.getParameters().get(customAttribute.getGroupName() + "#" + customAttribute.getPropertyName())) != null) continue;
                errors.add(new APEXLangSyntaxError(component.getLine(), component.getColumn(), "Missing required parameter: " + customAttribute.getGroupName() + " - " + customAttribute.getPropertyName(), component.getRange().getStart(), "", component.getRange().getStart(), component.getRange().getEnd(), component.getFilename(), APEXLangSyntaxError.ErrorType.MISSING_REQUIRED_PROPERTY, null));
            }
        }
    }

    public APEXLangCompilerContext getCompilerContext(Map<String, APEXAppFile> fileMap) {
        ArrayList<Component> componentsFromSource = new ArrayList<Component>();
        APEXLangCompilerContext compilerContext = new APEXLangCompilerContext();
        ArrayList<Component> parsedComponents = new ArrayList<Component>();
        ArrayList<APEXLangSyntaxError> errors = new ArrayList<APEXLangSyntaxError>();
        this.readFileMap(fileMap, compilerContext, errors, componentsFromSource, parsedComponents, new ArrayList<APEXLangWarning>());
        return compilerContext;
    }

    private AppCtxData getAppCtxData(List<Component> componentsParameters) {
        String centralThemeAppId = "";
        String currentThemeId = "";
        Integer globalPage = 0;
        String currThemeProp = this.metametadata.getMapping().getTheme().getCurrent().getPropertyId();
        String globalPageProp = this.metametadata.getMapping().getPage().getGlobalPageId().getPropertyId();
        for (Component c : componentsParameters) {
            Map<String, ComponentParameter> params = c.getParameters();
            ComponentParameter currentThemeCP = params.get(currThemeProp);
            ComponentParameter globalPageCP = params.get(globalPageProp);
            if (currentThemeCP != null && (currentThemeId = currentThemeCP.getValue()).startsWith("@")) {
                currentThemeId = currentThemeId.substring(1);
            }
            if (globalPageCP == null) continue;
            APEXLangIntegerDataType data = (APEXLangIntegerDataType)globalPageCP.getData();
            globalPage = data.getNumber().intValue();
        }
        for (Component component : componentsParameters) {
            String ref;
            String[] chunks;
            ComponentParameter subscription;
            if (!component.getTypeId().equals("2000") || !component.getExternalIdentifier().equals(currentThemeId) || (subscription = component.getParameters().get("498")) == null || subscription == null || !(subscription.getData() instanceof APEXLangStringDataType) || (chunks = (ref = subscription.getData().toString()).split("/")).length != 3) continue;
            centralThemeAppId = chunks[1];
            break;
        }
        return new AppCtxData(centralThemeAppId, currentThemeId, globalPage);
    }

    public APEXLangCompilationResult compile(Map<String, APEXAppFile> fileMap, APEXLangCompilerContext appCtx) {
        ArrayList<Component> componentsFromSource = new ArrayList<Component>();
        ArrayList<APEXLangSyntaxError> errors = new ArrayList<APEXLangSyntaxError>();
        ArrayList<APEXLangWarning> warnings = new ArrayList<APEXLangWarning>();
        APEXLangCompilerContext compilerContext = appCtx == null ? new APEXLangCompilerContext() : appCtx;
        List<Component> parsedComponents = new ArrayList<Component>();
        this.readFileMap(fileMap, compilerContext, errors, componentsFromSource, parsedComponents, warnings);
        APEXLangManifest manifest = new APEXLangManifest();
        for (String filename : fileMap.keySet()) {
            if (!filename.endsWith(MANIFEST_FILENAME)) continue;
            try {
                String manifestFile = fileMap.get(filename).getContentString();
                ObjectMapper mapper = new ObjectMapper();
                APEXLangManifestObject manifestObject = (APEXLangManifestObject)mapper.readValue(manifestFile, APEXLangManifestObject.class);
                String importStatement = this.metametadata.getPreImport();
                String endStatement = this.getMetametadata().getPostImport();
                manifest = new APEXLangManifest(manifestObject.getApex_version(), manifestObject.getApi_version(), manifestObject.getApp_id(), manifestObject.getDefault_id_offset(), manifestObject.getDefault_owner(), manifestObject.getWorkspace_id(), importStatement, endStatement);
            }
            catch (Exception x) {
                LOGGER.warning("Error reading manifest");
            }
        }
        parsedComponents = parsedComponents.stream().filter(component -> !componentTypesPLSQLWrong.contains(component.getTypeId())).toList();
        this.resolveReferences(parsedComponents, errors, compilerContext);
        this.resolveExternalFiles(parsedComponents, errors, fileMap);
        this.addDefaultValues(parsedComponents, parsedComponents);
        this.checkRequiredAttributes(parsedComponents, errors);
        return new APEXLangCompilationResult(Transpiler.transpile(parsedComponents, manifest, compilerContext), errors.toArray(new APEXLangSyntaxError[errors.size()]), warnings.toArray(new APEXLangWarning[warnings.size()]), componentsFromSource);
    }

    private void readFileMap(Map<String, APEXAppFile> fileMap, APEXLangCompilerContext compilerContext, List<APEXLangSyntaxError> errors, Collection<Component> componentsFromSource, List<Component> parsedComponents, List<APEXLangWarning> warnings) {
        ArrayList<String> filenames = new ArrayList<String>();
        for (String filename : fileMap.keySet()) {
            if (!filename.endsWith(APEX_EXTENSION)) continue;
            filenames.add(filename);
        }
        SortedFilePaths.SortedFilePathsResult sortedFilePathsResult = SortedFilePaths.createSortedFilePathsFromList(filenames, this.metametadata, this.filenameComponentTypeMap, "", null);
        if (sortedFilePathsResult.getFilesIdentified().size() == 0 && filenames.size() == 1) {
            SortedFilePaths newSortedFilePaths = new SortedFilePaths((String)filenames.get(0), null, "", Map.of());
            sortedFilePathsResult = new SortedFilePaths.SortedFilePathsResult(List.of(newSortedFilePaths), filenames);
        }
        for (SortedFilePaths sortedFilePaths : sortedFilePathsResult.getSortedFilePaths()) {
            String filename = sortedFilePaths.getFilePath();
            List<Component> originalParsedComponents = this.readParameters(fileMap.get(filename).getContentString(), filename, errors, parsedComponents, compilerContext, fileMap, null, sortedFilePaths);
            for (Component component : originalParsedComponents) {
                parsedComponents.add(component);
                componentsFromSource.add(component);
            }
        }
        AppCtxData appCtxData = this.getAppCtxData(parsedComponents);
        compilerContext.setCentralThemeAppId(appCtxData.getCentralThemeAppId());
        compilerContext.setCurrentTheme(appCtxData.getCurrentThemeId());
        compilerContext.setGlobalPage(appCtxData.getGlobalPage());
        Set<String> allFiles = fileMap.keySet();
        HashSet<String> remainingFiles = new HashSet<String>();
        for (String filename : allFiles) {
            if (!filename.endsWith(APEX_EXTENSION) && !filename.endsWith(".apx")) continue;
            remainingFiles.add(filename);
        }
        for (String identifiedFiles : sortedFilePathsResult.getFilesIdentified()) {
            remainingFiles.remove(identifiedFiles);
        }
        for (String unidentifiedAPEXLangFile : remainingFiles) {
            warnings.add(new APEXLangWarning(0, 0, "APEXlang source file ignored.", 0, "", 0, 0, unidentifiedAPEXLangFile, APEXLangWarning.WarningType.FILE_IGNORED, List.of()));
        }
    }

    private void resolveExternalFiles(List<Component> parsedComponents, List<APEXLangSyntaxError> errors, Map<String, APEXAppFile> fileMap) {
        ArrayList<Component> externalFileComponents = new ArrayList<Component>();
        for (Component currentComponent : parsedComponents) {
            Map<String, ComponentParameter> componentParameters = currentComponent.getParameters();
            if (currentComponent.getComponentType().getExternalFile() != null) {
                try {
                    ComponentParameter fileNameParameter = componentParameters.get(currentComponent.getComponentType().getExternalFile().getFileNamePropertyId());
                    String fileName = fileNameParameter.getValue();
                    if (fileName == null) {
                        errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "fileName property not found", currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.MISSING_REQUIRED_PROPERTY, null));
                        continue;
                    }
                    int lastDirectoryIndex = currentComponent.getFilename().lastIndexOf("/");
                    String relativeDirectory = currentComponent.getFilename().substring(0, lastDirectoryIndex >= 0 ? lastDirectoryIndex : 0);
                    String externalFileName = relativeDirectory + "/" + currentComponent.getComponentType().getExternalFile().getPath() + fileName;
                    String suggestedFilesRoot = relativeDirectory + "/" + currentComponent.getComponentType().getExternalFile().getPath();
                    List<APEXLangSuggestion> suggestions = fileMap.keySet().stream().filter(path -> path.startsWith(suggestedFilesRoot)).map(path -> new APEXLangSuggestion(APEXLangSuggestion.SuggestionType.VALUE, path.substring(suggestedFilesRoot.length()), null)).collect(Collectors.toUnmodifiableList());
                    componentParameters.get(currentComponent.getExternalIdentifierPropertyId()).setSuggestions(suggestions);
                    APEXAppFile externalFile = fileMap.get(externalFileName);
                    if (externalFile == null) {
                        errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "referenced file " + externalFileName + " in the fileName property is not found", currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                        continue;
                    }
                    currentComponent.setExternalFileHexContent(externalFile.getContentHex());
                    ComponentType.ComponentProperty fileContentComponentProperty = currentComponent.getComponentType().getProperties().get(currentComponent.getComponentType().getExternalFile().getFileContentPropertyId());
                    ComponentType.ApiParameter apiParameter = fileContentComponentProperty.getApiParameter();
                    String outputDataType = apiParameter == null ? null : apiParameter.getDataType();
                    String expression = apiParameter == null ? "" : apiParameter.getExpression();
                    componentParameters.put(currentComponent.getComponentType().getExternalFile().getFileContentPropertyId(), new ComponentParameter(currentComponent, APEXLangDataTypeFactory.createDataType("wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)", "string", outputDataType), expression, currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getLine(), currentComponent.getColumn(), false, false, this.metametadata.getProperties().get(currentComponent.getComponentType().getExternalFile().getFileContentPropertyId()), false, false, null));
                    externalFileComponents.add(currentComponent);
                }
                catch (Exception e) {
                    errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), e.getMessage(), currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, null));
                }
            }
            for (String currentParameterKey : componentParameters.keySet()) {
                ComponentParameter currentParameter = componentParameters.get(currentParameterKey);
                if (!currentParameter.isMultilineFile()) continue;
                String fileName = currentParameter.getValue();
                ComponentType currentComponentType = currentComponent.getComponentType();
                ComponentType.ComponentProperty componentProperty = currentComponentType.getProperties().get(currentParameterKey);
                String externalFilePath = componentProperty.getExternalFilePath();
                int lastDirectoryIndex = currentComponent.getFilename().lastIndexOf("/");
                String relativeDirectory = currentComponent.getFilename().substring(0, lastDirectoryIndex >= 0 ? lastDirectoryIndex : 0);
                String sourceFilePath = externalFilePath == null || externalFilePath.equals("") ? relativeDirectory + "/" : relativeDirectory + "/" + externalFilePath;
                String externalFileName = sourceFilePath + fileName;
                APEXAppFile externalFile = fileMap.get(externalFileName);
                List<String> suggestedFiles = fileMap.keySet().stream().filter(file -> file.startsWith(sourceFilePath) && !file.endsWith(APEX_EXTENSION)).map(file -> file.replace(sourceFilePath, "")).collect(Collectors.toList());
                List<APEXLangSuggestion> suggestions = APEXLangSuggestion.fromStrings(suggestedFiles, APEXLangSuggestion.SuggestionType.VALUE);
                currentParameter.setSuggestions(suggestions);
                if (externalFile == null) {
                    errors.add(new APEXLangSyntaxError(currentComponent.getLine(), currentComponent.getColumn(), "referenced file " + externalFileName + " in the " + currentParameter.getProperty().getName() + "File property is not found", currentComponent.getRange().getStart(), "", currentComponent.getRange().getStart(), currentComponent.getRange().getEnd(), currentComponent.getFilename(), APEXLangSyntaxError.ErrorType.REFERENCE_NOT_FOUND, suggestions));
                    continue;
                }
                APEXLangDataType parameterData = currentParameter.getData();
                if (parameterData instanceof APEXLangStringDataType) {
                    ((APEXLangStringDataType)parameterData).setData("```\n" + externalFile.getContentString() + "\n```");
                    continue;
                }
                LOGGER.warning("Something is wrong with metametadata!");
            }
        }
    }

    public APEXLangCompilationResult compile(Map<String, APEXAppFile> fileMap) {
        APEXLangCompilerContext appCtx = this.getCompilerContext(fileMap);
        return this.compile(fileMap, appCtx);
    }

    public APEXLangCompilationResult compile(InputStream zip) throws Exception {
        Map<String, APEXAppFile> fileMap = new FileLoader().getFilesFromZipInputStream(zip);
        return this.compile(fileMap);
    }

    public APEXLangCompilationResult compile(String source) {
        HashMap<String, APEXAppFile> fileMap = new HashMap<String, APEXAppFile>();
        fileMap.put("file.apex", new APEXAppFile(source.getBytes()));
        return this.compile(fileMap);
    }

    public APEXLangCompilationResult compile(APEXAppFile source) {
        HashMap<String, APEXAppFile> fileMap = new HashMap<String, APEXAppFile>();
        fileMap.put("file.apx", source);
        return this.compile(fileMap);
    }

    public List<String> getAvailableReferences(Property property, Component component, APEXLangCompilerContext appCtx) {
        Map<String, Location> refLocations = this.getAvailableReferenceLocations(property, component, appCtx);
        ArrayList<String> ret = new ArrayList<String>(refLocations.keySet());
        ret.sort(Comparator.naturalOrder());
        return ret;
    }

    public Location getReferenceLocation(Property property, Component component, APEXLangCompilerContext appCtx, String reference) {
        Map<String, Location> refLocations = this.getAvailableReferenceLocations(property, component, appCtx);
        return refLocations.get(reference);
    }

    public List<APEXLangSuggestion> getSuggestions(Map<String, APEXAppFile> fileMap, APEXLangCompilerContext appCtx, String fileName, int offset) {
        if (fileMap.containsKey(fileName)) {
            APEXLangSuggestionProvider suggestionProvider = new APEXLangSuggestionProvider(this, fileMap, appCtx, fileName, offset, (component, componentType) -> componentType.getParent() != null && this.isValidParent((Component)component, (ComponentType)componentType), this.pluginsLoader);
            return suggestionProvider.getSuggestions();
        }
        return null;
    }

    private static class ComponentFoundResult {
        private String componentTypeId;
        private Component parent;

        public ComponentFoundResult(String componentTypeId, Component parent) {
            this.componentTypeId = componentTypeId;
            this.parent = parent;
        }

        public String getComponentTypeId() {
            return this.componentTypeId;
        }

        public Component getParent() {
            return this.parent;
        }
    }

    private class PropertyCandidate {
        private Property property;
        private String propertyKey;
        private ComponentType.ComponentProperty componentProperty;
        private Boolean pluginProperty;
        private Component componentToAssignProperty;
        private boolean isMultilineFile;

        public PropertyCandidate(Property property, String propertyKey, ComponentType.ComponentProperty componentProperty, Boolean pluginProperty, Component componentToAssignProperty) {
            this.property = property;
            this.propertyKey = propertyKey;
            this.componentProperty = componentProperty;
            this.pluginProperty = pluginProperty;
            this.componentToAssignProperty = componentToAssignProperty;
        }

        public PropertyCandidate(Property property, String propertyKey, ComponentType.ComponentProperty componentProperty, Boolean pluginProperty, Component componentToAssignProperty, boolean isMultilineFile) {
            this(property, propertyKey, componentProperty, pluginProperty, componentToAssignProperty);
            this.isMultilineFile = isMultilineFile;
        }

        public String getPropertyKey() {
            return this.propertyKey;
        }

        public Component getComponentToAssignProperty() {
            return this.componentToAssignProperty;
        }

        public Boolean isPluginProperty() {
            return this.pluginProperty;
        }

        public Property getProperty() {
            return this.property;
        }

        public ComponentType.ComponentProperty getComponentProperty() {
            return this.componentProperty;
        }

        public boolean isMultilineFile() {
            return this.isMultilineFile;
        }
    }

    private static class ThemeDefinition {
        String refAppId;
        String themeId;

        private ThemeDefinition() {
        }
    }

    private static class AppCtxData {
        private String centralThemeAppId;
        private String currentThemeId;
        private Integer globalPage;

        public AppCtxData(String centralThemeAppId, String currentThemeId, Integer globalPage) {
            this.centralThemeAppId = centralThemeAppId;
            this.currentThemeId = currentThemeId;
            this.globalPage = globalPage;
        }

        public String getCentralThemeAppId() {
            return this.centralThemeAppId;
        }

        public String getCurrentThemeId() {
            return this.currentThemeId;
        }

        public Integer getGlobalPage() {
            return this.globalPage;
        }
    }
}

